/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.action;

import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JOptionPane;
import org.apache.jmeter.engine.JMeterEngineException;
import org.apache.jmeter.engine.StandardJMeterEngine;
import org.apache.jmeter.engine.TreeCloner;
import org.apache.jmeter.engine.util.DisabledComponentRemover;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.action.AbstractAction;
import org.apache.jmeter.testelement.TestPlan;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.collections.HashTree;
import org.apache.jorphan.collections.HashTreeTraverser;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class Start
extends AbstractAction {
    private static Logger log = LoggingManager.getLoggerForClass();
    private static Set commands = new HashSet();
    private StandardJMeterEngine engine;

    public Set getActionNames() {
        return commands;
    }

    public void doAction(ActionEvent e) {
        if (e.getActionCommand().equals("start")) {
            this.popupShouldSave(e);
            this.startEngine();
        } else if (e.getActionCommand().equals("stop")) {
            if (this.engine != null) {
                GuiPackage.getInstance().getMainFrame().showStoppingMessage("");
                this.engine.stopTest();
                this.engine = null;
            }
        } else if (e.getActionCommand().equals("shutdown") && this.engine != null) {
            GuiPackage.getInstance().getMainFrame().showStoppingMessage("");
            this.engine.askThreadsToStop();
            this.engine = null;
        }
    }

    protected void startEngine() {
        GuiPackage gui = GuiPackage.getInstance();
        this.engine = new StandardJMeterEngine();
        HashTree testTree = gui.getTreeModel().getTestPlan();
        this.convertSubTree(testTree);
        DisabledComponentRemover remover = new DisabledComponentRemover(testTree);
        testTree.traverse((HashTreeTraverser)remover);
        testTree.add(testTree.getArray()[0], (Object)gui.getMainFrame());
        log.debug("test plan before cloning is running version: " + ((TestPlan)testTree.getArray()[0]).isRunningVersion());
        TreeCloner cloner = new TreeCloner(false);
        testTree.traverse((HashTreeTraverser)cloner);
        this.engine.configure((HashTree)cloner.getClonedTree());
        try {
            this.engine.runTest();
        }
        catch (JMeterEngineException e) {
            JOptionPane.showMessageDialog(gui.getMainFrame(), e.getMessage(), JMeterUtils.getResString("Error Occurred"), 0);
        }
        log.debug("test plan after cloning and running test is running version: " + ((TestPlan)testTree.getArray()[0]).isRunningVersion());
    }

    static {
        commands.add("start");
        commands.add("stop");
        commands.add("shutdown");
    }
}

