/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.tree;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.apache.jmeter.config.gui.AbstractConfigGui;
import org.apache.jmeter.control.gui.TestPlanGui;
import org.apache.jmeter.control.gui.WorkBenchGui;
import org.apache.jmeter.exceptions.IllegalUserActionException;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.JMeterGUIComponent;
import org.apache.jmeter.gui.tree.JMeterTreeNode;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.TestPlan;
import org.apache.jmeter.testelement.WorkBench;
import org.apache.jmeter.testelement.property.NullProperty;
import org.apache.jmeter.util.NameUpdater;
import org.apache.jorphan.collections.HashTree;
import org.apache.jorphan.collections.ListedHashTree;

public class JMeterTreeModel
extends DefaultTreeModel {
    public JMeterTreeModel() {
        super(new JMeterTreeNode(new WorkBenchGui().createTestElement(), null));
        this.initTree();
    }

    public List getNodesOfType(Class type) {
        LinkedList nodeList = new LinkedList();
        this.traverseAndFind(type, (JMeterTreeNode)this.getRoot(), nodeList);
        return nodeList;
    }

    public JMeterTreeNode getNodeOf(TestElement userObject) {
        return this.traverseAndFind(userObject, (JMeterTreeNode)this.getRoot());
    }

    public HashTree addSubTree(HashTree subTree, JMeterTreeNode current) throws IllegalUserActionException {
        Iterator iter = subTree.list().iterator();
        while (iter.hasNext()) {
            TestElement item = (TestElement)iter.next();
            if (item instanceof TestPlan) {
                current = (JMeterTreeNode)((JMeterTreeNode)this.getRoot()).getChildAt(0);
                ((TestElement)current.getUserObject()).addTestElement(item);
                ((TestPlan)current.getUserObject()).setName(item.getPropertyAsString("TestElement.name"));
                ((TestPlan)current.getUserObject()).setFunctionalMode(item.getPropertyAsBoolean("TestPlan.functional_mode"));
                ((TestPlan)current.getUserObject()).setSerialized(item.getPropertyAsBoolean("TestPlan.serialize_threadgroups"));
                this.addSubTree(subTree.getTree((Object)item), current);
                continue;
            }
            if (item instanceof WorkBench) {
                current = (JMeterTreeNode)((JMeterTreeNode)this.getRoot()).getChildAt(1);
                ((TestElement)current.getUserObject()).addTestElement(item);
                ((WorkBench)current.getUserObject()).setName(item.getPropertyAsString("TestElement.name"));
                this.addSubTree(subTree.getTree((Object)item), current);
                continue;
            }
            this.addSubTree(subTree.getTree((Object)item), this.addComponent(item, current));
        }
        return this.getCurrentSubTree(current);
    }

    public JMeterTreeNode addComponent(TestElement component, JMeterTreeNode node) throws IllegalUserActionException {
        if (node.getUserObject() instanceof AbstractConfigGui) {
            throw new IllegalUserActionException("This node cannot hold sub-elements");
        }
        component.setProperty("TestElement.gui_class", NameUpdater.getCurrentName(component.getPropertyAsString("TestElement.gui_class")));
        GuiPackage.getInstance().updateCurrentNode();
        JMeterGUIComponent guicomp = GuiPackage.getInstance().getGui(component);
        guicomp.configure(component);
        guicomp.modifyTestElement(component);
        GuiPackage.getInstance().getCurrentGui();
        JMeterTreeNode newNode = new JMeterTreeNode(component, this);
        try {
            if (component.getProperty("TestElement.enabled") instanceof NullProperty || component.getPropertyAsBoolean("TestElement.enabled")) {
                newNode.setEnabled(true);
            } else {
                newNode.setEnabled(false);
            }
        }
        catch (Exception e) {
            newNode.setEnabled(true);
        }
        this.insertNodeInto(newNode, node, node.getChildCount());
        return newNode;
    }

    public void removeNodeFromParent(JMeterTreeNode node) {
        if (!(node.getUserObject() instanceof TestPlan) && !(node.getUserObject() instanceof WorkBench)) {
            super.removeNodeFromParent(node);
        }
    }

    private void traverseAndFind(Class type, JMeterTreeNode node, List nodeList) {
        if (type.isInstance(node.getUserObject())) {
            nodeList.add(node);
        }
        Enumeration<TreeNode> enumNode = node.children();
        while (enumNode.hasMoreElements()) {
            JMeterTreeNode child = (JMeterTreeNode)enumNode.nextElement();
            this.traverseAndFind(type, child, nodeList);
        }
    }

    private JMeterTreeNode traverseAndFind(TestElement userObject, JMeterTreeNode node) {
        if (userObject == node.getUserObject()) {
            return node;
        }
        Enumeration<TreeNode> enumNode = node.children();
        while (enumNode.hasMoreElements()) {
            JMeterTreeNode child = (JMeterTreeNode)enumNode.nextElement();
            JMeterTreeNode result = this.traverseAndFind(userObject, child);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public HashTree getCurrentSubTree(JMeterTreeNode node) {
        ListedHashTree hashTree = new ListedHashTree((Object)node);
        Enumeration<TreeNode> enumNode = node.children();
        while (enumNode.hasMoreElements()) {
            JMeterTreeNode child = (JMeterTreeNode)enumNode.nextElement();
            hashTree.add((Object)node, this.getCurrentSubTree(child));
        }
        return hashTree;
    }

    public HashTree getTestPlan() {
        return this.getCurrentSubTree((JMeterTreeNode)((JMeterTreeNode)this.getRoot()).getChildAt(0));
    }

    public void clearTestPlan() {
        super.removeNodeFromParent((JMeterTreeNode)this.getChild(this.getRoot(), 0));
        this.initTree();
    }

    private void initTree() {
        TestElement tp = new TestPlanGui().createTestElement();
        TestElement wb = new WorkBenchGui().createTestElement();
        this.insertNodeInto(new JMeterTreeNode(tp, this), (JMeterTreeNode)this.getRoot(), 0);
        try {
            super.removeNodeFromParent((JMeterTreeNode)this.getChild(this.getRoot(), 1));
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        this.insertNodeInto(new JMeterTreeNode(wb, this), (JMeterTreeNode)this.getRoot(), 1);
    }
}

