/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.tree;

import java.awt.Image;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.util.Collection;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultMutableTreeNode;
import org.apache.jmeter.gui.GUIFactory;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.tree.JMeterTreeModel;
import org.apache.jmeter.testbeans.TestBean;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.BooleanProperty;
import org.apache.jmeter.testelement.property.StringProperty;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.util.JMeterError;
import org.apache.log.Logger;

public class JMeterTreeNode
extends DefaultMutableTreeNode {
    private static transient Logger log = LoggingManager.getLoggerForClass();
    private JMeterTreeModel treeModel;

    public JMeterTreeNode() {
        this(null, null);
    }

    public JMeterTreeNode(TestElement userObj, JMeterTreeModel treeModel) {
        super(userObj);
        this.treeModel = treeModel;
    }

    public boolean isEnabled() {
        return ((AbstractTestElement)this.getTestElement()).getPropertyAsBoolean("TestElement.enabled");
    }

    public void setEnabled(boolean enabled) {
        this.getTestElement().setProperty(new BooleanProperty("TestElement.enabled", enabled));
        this.treeModel.nodeChanged(this);
    }

    public ImageIcon getIcon() {
        return this.getIcon(true);
    }

    public ImageIcon getIcon(boolean enabled) {
        try {
            if (this.getTestElement() instanceof TestBean) {
                try {
                    Image img = Introspector.getBeanInfo(this.getTestElement().getClass()).getIcon(1);
                    if (img == null) {
                        Object clazz = Introspector.getBeanInfo(this.getTestElement().getClass()).getBeanDescriptor().getValue("TestElement.gui_class");
                        if (clazz == null) {
                            log.error("Can't obtain GUI class for " + this.getTestElement().getClass().getName());
                            return null;
                        }
                        return GUIFactory.getIcon(Class.forName((String)clazz), enabled);
                    }
                    return new ImageIcon(img);
                }
                catch (IntrospectionException e1) {
                    log.error("Can't obtain icon", (Throwable)e1);
                    throw new JMeterError((Throwable)e1);
                }
            }
            return GUIFactory.getIcon(Class.forName(this.getTestElement().getPropertyAsString("TestElement.gui_class")), enabled);
        }
        catch (ClassNotFoundException e) {
            log.warn("Can't get icon for class " + this.getTestElement(), (Throwable)e);
            return null;
        }
    }

    public Collection getMenuCategories() {
        try {
            return GuiPackage.getInstance().getGui(this.getTestElement()).getMenuCategories();
        }
        catch (Exception e) {
            log.error("Can't get popup menu for gui", (Throwable)e);
            return null;
        }
    }

    public JPopupMenu createPopupMenu() {
        try {
            return GuiPackage.getInstance().getGui(this.getTestElement()).createPopupMenu();
        }
        catch (Exception e) {
            log.error("Can't get popup menu for gui", (Throwable)e);
            return null;
        }
    }

    public TestElement getTestElement() {
        return (TestElement)this.getUserObject();
    }

    public String getStaticLabel() {
        return GuiPackage.getInstance().getGui((TestElement)this.getUserObject()).getStaticLabel();
    }

    public String getDocAnchor() {
        return GuiPackage.getInstance().getGui((TestElement)this.getUserObject()).getDocAnchor();
    }

    public void setName(String name) {
        ((TestElement)this.getUserObject()).setProperty(new StringProperty("TestElement.name", name));
    }

    public String getName() {
        return ((TestElement)this.getUserObject()).getPropertyAsString("TestElement.name");
    }

    public void nameChanged() {
        this.treeModel.nodeChanged(this);
    }
}

