/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.util;

import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.JMeterFileFilter;
import org.apache.jmeter.util.JMeterUtils;

public final class FileDialoger {
    private static String lastJFCDirectory = null;
    private static JFileChooser jfc = new JFileChooser();

    private FileDialoger() {
    }

    public static JFileChooser promptToOpenFile(String[] exts) {
        String start;
        if (lastJFCDirectory == null && !(start = JMeterUtils.getPropDefault("user.dir", "")).equals("")) {
            jfc.setCurrentDirectory(new File(start));
        }
        FileDialoger.clearFileFilters();
        jfc.addChoosableFileFilter(new JMeterFileFilter(exts));
        int retVal = jfc.showOpenDialog(GuiPackage.getInstance().getMainFrame());
        lastJFCDirectory = jfc.getCurrentDirectory().getAbsolutePath();
        if (retVal == 0) {
            return jfc;
        }
        return null;
    }

    private static void clearFileFilters() {
        FileFilter[] filters = jfc.getChoosableFileFilters();
        for (int x = 0; x < filters.length; ++x) {
            jfc.removeChoosableFileFilter(filters[x]);
        }
    }

    public static JFileChooser promptToOpenFile() {
        return FileDialoger.promptToOpenFile(new String[0]);
    }

    public static JFileChooser promptToSaveFile(String filename) {
        return FileDialoger.promptToSaveFile(filename, null);
    }

    public static JFileChooser promptToSaveFile(String filename, String[] extensions) {
        if (lastJFCDirectory == null) {
            String start = JMeterUtils.getPropDefault("user.dir", "");
            if (!start.equals("")) {
                jfc = new JFileChooser(new File(start));
            }
            lastJFCDirectory = jfc.getCurrentDirectory().getAbsolutePath();
        }
        String ext = ".jmx";
        if (filename != null) {
            jfc.setSelectedFile(new File(lastJFCDirectory, filename));
            int i = -1;
            i = filename.lastIndexOf(".");
            if (i > -1) {
                ext = filename.substring(i);
            }
        }
        FileDialoger.clearFileFilters();
        if (extensions != null) {
            jfc.addChoosableFileFilter(new JMeterFileFilter(extensions));
        } else {
            jfc.addChoosableFileFilter(new JMeterFileFilter(new String[]{ext}));
        }
        int retVal = jfc.showSaveDialog(GuiPackage.getInstance().getMainFrame());
        lastJFCDirectory = jfc.getCurrentDirectory().getAbsolutePath();
        if (retVal == 0) {
            return jfc;
        }
        return null;
    }
}

