/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.util;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.swing.JTextField;

public class JDateField
extends JTextField {
    private static final DateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    private static int[] fieldPositions = new int[]{1, 1, 1, 1, 1, 2, 2, 2, 5, 5, 5, 11, 11, 11, 12, 12, 12, 13, 13, 13};

    public JDateField(Date date) {
        super(20);
        this.addKeyListener(new KeyFocus());
        this.addFocusListener(new FocusClass());
        String myString = dateFormat.format(date);
        this.setText(myString);
    }

    public JDateField() {
        this(new Date());
    }

    public void setDate(Date date) {
        this.setText(dateFormat.format(date));
    }

    public Date getDate() {
        try {
            return dateFormat.parse(this.getText());
        }
        catch (ParseException e) {
            return new Date();
        }
        catch (Exception e) {
            return new Date();
        }
    }

    private static int posToField(int pos) {
        if (pos >= fieldPositions.length) {
            pos = fieldPositions.length - 1;
        }
        return fieldPositions[pos];
    }

    private static Calendar parseDate(String datetime) {
        Calendar c = Calendar.getInstance();
        try {
            Date dat = dateFormat.parse(datetime);
            c.setTime(dat);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return c;
    }

    private void update(int addend, boolean shifted) {
        Calendar c = JDateField.parseDate(this.getText());
        int pos = this.getCaretPosition();
        int field = JDateField.posToField(pos);
        if (shifted) {
            c.roll(field, true);
        } else {
            c.add(field, addend);
        }
        String newDate = dateFormat.format(c.getTime());
        this.setText(newDate);
        if (pos > newDate.length()) {
            pos = newDate.length();
        }
        this.setCaretPosition(pos);
    }

    class FocusClass
    implements FocusListener {
        FocusClass() {
        }

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
            try {
                dateFormat.parse(JDateField.this.getText());
            }
            catch (ParseException e1) {
                JDateField.this.requestFocus();
            }
        }
    }

    class KeyFocus
    extends KeyAdapter {
        KeyFocus() {
        }

        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 38) {
                JDateField.this.update(1, e.isShiftDown());
            } else if (e.getKeyCode() == 40) {
                JDateField.this.update(-1, e.isShiftDown());
            }
        }
    }
}

