/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.util;

import java.awt.Component;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.UIManager;
import org.apache.jmeter.gui.action.ActionRouter;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.util.LocaleChangeEvent;
import org.apache.jmeter.util.LocaleChangeListener;
import org.apache.jmeter.util.SSLManager;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.util.JOrphanUtils;
import org.apache.log.Logger;

public class JMeterMenuBar
extends JMenuBar
implements LocaleChangeListener {
    private static transient Logger log = LoggingManager.getLoggerForClass();
    JMenu fileMenu;
    JMenuItem file_save_as;
    JMenuItem file_load;
    JMenuItem file_merge;
    JMenuItem file_exit;
    JMenuItem file_close;
    JMenu editMenu;
    JMenu edit_add;
    JMenuItem edit_remove;
    JMenu runMenu;
    JMenuItem run_start;
    JMenu remote_start;
    JMenuItem remote_start_all;
    Collection remote_engine_start = new LinkedList();
    JMenuItem run_stop;
    private JMenuItem run_shut;
    JMenu remote_stop;
    JMenuItem remote_stop_all;
    Collection remote_engine_stop = new LinkedList();
    JMenuItem run_clear;
    JMenuItem run_clearAll;
    JMenu optionsMenu;
    JMenu lafMenu;
    JMenuItem sslManager;
    JMenu helpMenu;
    JMenuItem help_about;
    String[] remoteHosts;
    private JMenu remote_exit;
    private JMenuItem remote_exit_all;
    private Collection remote_engine_exit = new LinkedList();
    public static final String ACTION_SHUTDOWN = "shutdown";
    public static final String ACTION_STOP = "stop";
    public static final String ACTION_START = "start";

    public JMeterMenuBar() {
        this.remoteHosts = JOrphanUtils.split((String)JMeterUtils.getPropDefault("remote_hosts", ""), (String)",");
        if (this.remoteHosts.length == 1 && this.remoteHosts[0].equals("")) {
            this.remoteHosts = new String[0];
        }
        this.getRemoteItems();
        this.createMenuBar();
    }

    public void setFileSaveEnabled(boolean enabled) {
        this.file_save_as.setEnabled(enabled);
    }

    public void setFileLoadEnabled(boolean enabled) {
        if (this.file_load != null) {
            this.file_load.setEnabled(enabled);
        }
        if (this.file_merge != null) {
            this.file_merge.setEnabled(enabled);
        }
    }

    public void setEditEnabled(boolean enabled) {
        if (this.editMenu != null) {
            this.editMenu.setEnabled(enabled);
        }
    }

    public void setEditAddMenu(JMenu menu) {
        if (this.edit_add != null) {
            this.editMenu.remove(this.edit_add);
        }
        this.edit_add = menu;
        this.editMenu.insert(this.edit_add, 0);
    }

    public void setEditMenu(JPopupMenu menu) {
        if (menu != null) {
            this.editMenu.removeAll();
            Component[] comps = menu.getComponents();
            for (int i = 0; i < comps.length; ++i) {
                this.editMenu.add(comps[i]);
            }
            this.editMenu.setEnabled(true);
        } else {
            this.editMenu.setEnabled(false);
        }
    }

    public void setEditAddEnabled(boolean enabled) {
        if (this.edit_add != null) {
            this.edit_add.setEnabled(enabled);
        }
        if (enabled) {
            this.setEditEnabled(true);
        } else if (!this.edit_remove.isEnabled()) {
            this.editMenu.setEnabled(false);
        }
    }

    public void setEditRemoveEnabled(boolean enabled) {
        this.edit_remove.setEnabled(enabled);
        if (enabled) {
            this.setEditEnabled(true);
        } else if (!this.edit_add.isEnabled()) {
            this.editMenu.setEnabled(false);
        }
    }

    public void createMenuBar() {
        this.makeFileMenu();
        this.makeEditMenu();
        this.makeRunMenu();
        this.makeOptionsMenu();
        this.makeHelpMenu();
        this.add(this.fileMenu);
        this.add(this.editMenu);
        this.add(this.runMenu);
        this.add(this.optionsMenu);
        this.add(this.helpMenu);
    }

    private void makeHelpMenu() {
        this.helpMenu = new JMenu(JMeterUtils.getResString("help"));
        this.helpMenu.setMnemonic('H');
        JMenuItem contextHelp = new JMenuItem(JMeterUtils.getResString("help"), 72);
        contextHelp.setActionCommand("help");
        contextHelp.setAccelerator(KeyStroke.getKeyStroke(72, 2));
        contextHelp.addActionListener(ActionRouter.getInstance());
        this.help_about = new JMenuItem(JMeterUtils.getResString("about"), 65);
        this.help_about.setActionCommand("about");
        this.help_about.addActionListener(ActionRouter.getInstance());
        this.helpMenu.add(contextHelp);
        this.helpMenu.add(this.help_about);
    }

    private void makeOptionsMenu() {
        this.optionsMenu = new JMenu(JMeterUtils.getResString("option"));
        JMenuItem functionHelper = new JMenuItem(JMeterUtils.getResString("function_dialog_menu_item"), 70);
        functionHelper.addActionListener(ActionRouter.getInstance());
        functionHelper.setActionCommand("functions");
        functionHelper.setAccelerator(KeyStroke.getKeyStroke(70, 2));
        this.lafMenu = new JMenu(JMeterUtils.getResString("appearance"));
        UIManager.LookAndFeelInfo[] lafs = UIManager.getInstalledLookAndFeels();
        for (int i = 0; i < lafs.length; ++i) {
            JMenuItem laf = new JMenuItem(lafs[i].getName());
            laf.addActionListener(ActionRouter.getInstance());
            laf.setActionCommand("laf:" + lafs[i].getClassName());
            this.lafMenu.setMnemonic('L');
            this.lafMenu.add(laf);
        }
        this.optionsMenu.setMnemonic('O');
        this.optionsMenu.add(functionHelper);
        this.optionsMenu.add(this.lafMenu);
        if (SSLManager.isSSLSupported()) {
            this.sslManager = new JMenuItem(JMeterUtils.getResString("sslManager"));
            this.sslManager.addActionListener(ActionRouter.getInstance());
            this.sslManager.setActionCommand("sslManager");
            this.sslManager.setMnemonic('S');
            this.sslManager.setAccelerator(KeyStroke.getKeyStroke(77, 2));
            this.optionsMenu.add(this.sslManager);
        }
        this.optionsMenu.add(this.makeLanguageMenu());
    }

    private JMenu makeLanguageMenu() {
        JMenu languageMenu = new JMenu(JMeterUtils.getResString("choose_language"));
        languageMenu.setMnemonic('C');
        JMenuItem english = new JMenuItem(JMeterUtils.getResString("en"), 69);
        english.addActionListener(ActionRouter.getInstance());
        english.setActionCommand("change_language");
        english.setName(Locale.ENGLISH.getLanguage());
        languageMenu.add(english);
        JMenuItem japanese = new JMenuItem(JMeterUtils.getResString("jp"), 74);
        japanese.addActionListener(ActionRouter.getInstance());
        japanese.setActionCommand("change_language");
        japanese.setName(Locale.JAPANESE.getLanguage());
        languageMenu.add(japanese);
        JMenuItem norway = new JMenuItem(JMeterUtils.getResString("no"), 78);
        norway.addActionListener(ActionRouter.getInstance());
        norway.setActionCommand("change_language");
        norway.setName("no");
        languageMenu.add(norway);
        JMenuItem german = new JMenuItem(JMeterUtils.getResString("de"), 71);
        german.addActionListener(ActionRouter.getInstance());
        german.setActionCommand("change_language");
        german.setName(Locale.GERMAN.getLanguage());
        languageMenu.add(german);
        JMenuItem french = new JMenuItem(JMeterUtils.getResString("fr"), 70);
        french.addActionListener(ActionRouter.getInstance());
        french.setActionCommand("change_language");
        french.setName(Locale.FRENCH.getLanguage());
        languageMenu.add(french);
        JMenuItem chineseSimple = new JMenuItem(JMeterUtils.getResString("zh_cn"));
        chineseSimple.addActionListener(ActionRouter.getInstance());
        chineseSimple.setActionCommand("change_language");
        chineseSimple.setName(Locale.SIMPLIFIED_CHINESE.toString());
        languageMenu.add(chineseSimple);
        JMenuItem chineseTrad = new JMenuItem(JMeterUtils.getResString("zh_TW"));
        chineseTrad.addActionListener(ActionRouter.getInstance());
        chineseTrad.setActionCommand("change_language");
        chineseTrad.setName(Locale.TRADITIONAL_CHINESE.toString());
        languageMenu.add(chineseTrad);
        JMenuItem spanish = new JMenuItem(JMeterUtils.getResString("es"));
        spanish.addActionListener(ActionRouter.getInstance());
        spanish.setActionCommand("change_language");
        spanish.setName("es");
        languageMenu.add(spanish);
        return languageMenu;
    }

    private void makeRunMenu() {
        this.runMenu = new JMenu(JMeterUtils.getResString("run"));
        this.runMenu.setMnemonic('R');
        this.run_start = new JMenuItem(JMeterUtils.getResString(ACTION_START), 83);
        this.run_start.setAccelerator(KeyStroke.getKeyStroke(82, 2));
        this.run_start.addActionListener(ActionRouter.getInstance());
        this.run_start.setActionCommand(ACTION_START);
        this.run_stop = new JMenuItem(JMeterUtils.getResString(ACTION_STOP), 84);
        this.run_stop.setAccelerator(KeyStroke.getKeyStroke(46, 2));
        this.run_stop.setEnabled(false);
        this.run_stop.addActionListener(ActionRouter.getInstance());
        this.run_stop.setActionCommand(ACTION_STOP);
        this.run_shut = new JMenuItem(JMeterUtils.getResString(ACTION_SHUTDOWN), 89);
        this.run_shut.setAccelerator(KeyStroke.getKeyStroke(44, 2));
        this.run_shut.setEnabled(false);
        this.run_shut.addActionListener(ActionRouter.getInstance());
        this.run_shut.setActionCommand(ACTION_SHUTDOWN);
        this.run_clear = new JMenuItem(JMeterUtils.getResString("clear"), 67);
        this.run_clear.addActionListener(ActionRouter.getInstance());
        this.run_clear.setActionCommand("action.clear");
        this.run_clearAll = new JMenuItem(JMeterUtils.getResString("clear_all"), 97);
        this.run_clearAll.addActionListener(ActionRouter.getInstance());
        this.run_clearAll.setActionCommand("action.clear_all");
        this.run_clearAll.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        this.runMenu.add(this.run_start);
        if (this.remote_start != null) {
            this.runMenu.add(this.remote_start);
        }
        this.remote_start_all = new JMenuItem(JMeterUtils.getResString("remote_start_all"), 90);
        this.remote_start_all.setName("remote_start_all");
        this.remote_start_all.setAccelerator(KeyStroke.getKeyStroke(90, 2));
        this.remote_start_all.addActionListener(ActionRouter.getInstance());
        this.remote_start_all.setActionCommand("remote_start_all");
        this.runMenu.add(this.remote_start_all);
        this.runMenu.add(this.run_stop);
        this.runMenu.add(this.run_shut);
        if (this.remote_stop != null) {
            this.runMenu.add(this.remote_stop);
        }
        this.remote_stop_all = new JMenuItem(JMeterUtils.getResString("remote_stop_all"), 88);
        this.remote_stop_all.setAccelerator(KeyStroke.getKeyStroke(88, 8));
        this.remote_stop_all.addActionListener(ActionRouter.getInstance());
        this.remote_stop_all.setActionCommand("remote_stop_all");
        this.runMenu.add(this.remote_stop_all);
        if (this.remote_exit != null) {
            this.runMenu.add(this.remote_exit);
        }
        this.remote_exit_all = new JMenuItem(JMeterUtils.getResString("remote_exit_all"));
        this.remote_exit_all.addActionListener(ActionRouter.getInstance());
        this.remote_exit_all.setActionCommand("remote_exit_all");
        this.runMenu.add(this.remote_exit_all);
        this.runMenu.addSeparator();
        this.runMenu.add(this.run_clear);
        this.runMenu.add(this.run_clearAll);
    }

    private void makeEditMenu() {
        this.editMenu = new JMenu(JMeterUtils.getResString("edit"));
        this.editMenu.setEnabled(false);
    }

    private void makeFileMenu() {
        this.fileMenu = new JMenu(JMeterUtils.getResString("file"));
        this.fileMenu.setMnemonic('F');
        JMenuItem file_save = new JMenuItem(JMeterUtils.getResString("save"), 83);
        file_save.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        file_save.setActionCommand("save");
        file_save.addActionListener(ActionRouter.getInstance());
        file_save.setEnabled(true);
        this.file_save_as = new JMenuItem(JMeterUtils.getResString("save_all_as"), 65);
        this.file_save_as.setAccelerator(KeyStroke.getKeyStroke(65, 2));
        this.file_save_as.setActionCommand("save_all_as");
        this.file_save_as.addActionListener(ActionRouter.getInstance());
        this.file_save_as.setEnabled(true);
        this.file_load = new JMenuItem(JMeterUtils.getResString("menu_open"), 79);
        this.file_load.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.file_load.addActionListener(ActionRouter.getInstance());
        this.file_load.setEnabled(false);
        this.file_load.setActionCommand("open");
        this.file_close = new JMenuItem(JMeterUtils.getResString("menu_close"), 67);
        this.file_close.setAccelerator(KeyStroke.getKeyStroke(76, 2));
        this.file_close.setActionCommand("close");
        this.file_close.addActionListener(ActionRouter.getInstance());
        this.file_exit = new JMenuItem(JMeterUtils.getResString("exit"), 88);
        this.file_exit.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        this.file_exit.setActionCommand("exit");
        this.file_exit.addActionListener(ActionRouter.getInstance());
        this.file_merge = new JMenuItem(JMeterUtils.getResString("menu_merge"), 77);
        this.file_merge.addActionListener(ActionRouter.getInstance());
        this.file_merge.setEnabled(false);
        this.file_merge.setActionCommand("merge");
        this.fileMenu.add(this.file_close);
        this.fileMenu.add(this.file_load);
        this.fileMenu.add(this.file_merge);
        this.fileMenu.add(file_save);
        this.fileMenu.add(this.file_save_as);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.file_exit);
    }

    public void setRunning(boolean running, String host) {
        log.info("setRunning(" + running + "," + host + ")");
        Iterator iter = this.remote_engine_start.iterator();
        Iterator iter2 = this.remote_engine_stop.iterator();
        Iterator iter3 = this.remote_engine_exit.iterator();
        while (iter.hasNext() && iter2.hasNext() && iter3.hasNext()) {
            JMenuItem start = (JMenuItem)iter.next();
            JMenuItem stop = (JMenuItem)iter2.next();
            JMenuItem exit = (JMenuItem)iter3.next();
            if (start.getText().equals(host)) {
                log.info("Found start host: " + start.getText());
                start.setEnabled(!running);
            }
            if (stop.getText().equals(host)) {
                log.info("Found stop  host: " + stop.getText());
                stop.setEnabled(running);
            }
            if (!exit.getText().equals(host)) continue;
            log.info("Found exit  host: " + exit.getText());
            exit.setEnabled(true);
        }
    }

    public void setEnabled(boolean enable) {
        this.run_start.setEnabled(!enable);
        this.run_stop.setEnabled(enable);
        this.run_shut.setEnabled(enable);
    }

    private void getRemoteItems() {
        if (this.remoteHosts.length > 0) {
            this.remote_start = new JMenu(JMeterUtils.getResString("remote_start"));
            this.remote_stop = new JMenu(JMeterUtils.getResString("remote_stop"));
            this.remote_exit = new JMenu(JMeterUtils.getResString("remote_exit"));
            for (int i = 0; i < this.remoteHosts.length; ++i) {
                this.remoteHosts[i] = this.remoteHosts[i].trim();
                JMenuItem item = new JMenuItem(this.remoteHosts[i]);
                item.setActionCommand("remote_start");
                item.setName(this.remoteHosts[i]);
                item.addActionListener(ActionRouter.getInstance());
                this.remote_engine_start.add(item);
                this.remote_start.add(item);
                item = new JMenuItem(this.remoteHosts[i]);
                item.setActionCommand("remote_stop");
                item.setName(this.remoteHosts[i]);
                item.addActionListener(ActionRouter.getInstance());
                item.setEnabled(false);
                this.remote_engine_stop.add(item);
                this.remote_stop.add(item);
                item = new JMenuItem(this.remoteHosts[i]);
                item.setActionCommand("remote_exit");
                item.setName(this.remoteHosts[i]);
                item.addActionListener(ActionRouter.getInstance());
                item.setEnabled(false);
                this.remote_engine_exit.add(item);
                this.remote_exit.add(item);
            }
        }
    }

    public void localeChanged(LocaleChangeEvent event) {
        this.updateMenuElement(this.fileMenu);
        this.updateMenuElement(this.editMenu);
        this.updateMenuElement(this.runMenu);
        this.updateMenuElement(this.optionsMenu);
        this.updateMenuElement(this.helpMenu);
    }

    private void updateMenuElement(MenuElement menu) {
        Component component = menu.getComponent();
        if (component.getName() != null) {
            if (component instanceof JMenu) {
                ((JMenu)component).setText(JMeterUtils.getResString(component.getName()));
            } else {
                ((JMenuItem)component).setText(JMeterUtils.getResString(component.getName()));
            }
        }
        MenuElement[] subelements = menu.getSubElements();
        for (int i = 0; i < subelements.length; ++i) {
            this.updateMenuElement(subelements[i]);
        }
    }
}

