/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.JMeterGUIComponent;
import org.apache.jmeter.gui.action.ActionRouter;
import org.apache.jmeter.gui.util.MenuInfo;
import org.apache.jmeter.junit.JMeterTestCase;
import org.apache.jmeter.testbeans.gui.TestBeanGUI;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.visualizers.Printable;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.reflect.ClassFinder;
import org.apache.jorphan.util.JOrphanUtils;
import org.apache.log.Logger;

public final class MenuFactory {
    private static transient Logger log = LoggingManager.getLoggerForClass();
    public static final String TIMERS = "menu_timer";
    public static final String CONTROLLERS = "menu_logic_controller";
    public static final String SAMPLERS = "menu_generative_controller";
    public static final String CONFIG_ELEMENTS = "menu_config_element";
    public static final String POST_PROCESSORS = "menu_post_processors";
    public static final String PRE_PROCESSORS = "menu_pre_processors";
    public static final String ASSERTIONS = "menu_assertions";
    public static final String NON_TEST_ELEMENTS = "menu_non_test_elements";
    public static final String LISTENERS = "menu_listener";
    private static Map menuMap = new HashMap();
    private static Set elementsToSkip = new HashSet();
    private static final String[] MENU_ADD_CONTROLLER = new String[]{"menu_logic_controller", "menu_generative_controller", "menu_assertions", "menu_config_element", "menu_timer", "menu_listener", "menu_pre_processors", "menu_post_processors"};
    private static final String[] MENU_PARENT_CONTROLLER = new String[]{"menu_logic_controller"};
    private static final String[] MENU_ADD_SAMPLER = new String[]{"menu_config_element", "menu_assertions", "menu_timer", "menu_listener", "menu_pre_processors", "menu_post_processors"};
    private static final String[] MENU_PARENT_SAMPLER = new String[]{"menu_logic_controller"};
    private static List timers;
    private static List controllers;
    private static List samplers;
    private static List configElements;
    private static List assertions;
    private static List listeners;
    private static List nonTestElements;
    private static List postProcessors;
    private static List preProcessors;
    static /* synthetic */ Class class$org$apache$jmeter$gui$JMeterGUIComponent;
    static /* synthetic */ Class class$org$apache$jmeter$testbeans$TestBean;

    private MenuFactory() {
    }

    public static String doNothing() {
        return "doing nothing";
    }

    public static void addEditMenu(JPopupMenu menu, boolean removable) {
        MenuFactory.addSeparator(menu);
        if (removable) {
            menu.add(MenuFactory.makeMenuItem(JMeterUtils.getResString("remove"), "Remove", "remove", KeyStroke.getKeyStroke(127, 0)));
        }
        menu.add(MenuFactory.makeMenuItem(JMeterUtils.getResString("cut"), "Cut", "Cut", KeyStroke.getKeyStroke(88, 2)));
        menu.add(MenuFactory.makeMenuItem(JMeterUtils.getResString("copy"), "Copy", "Copy", KeyStroke.getKeyStroke(67, 2)));
        menu.add(MenuFactory.makeMenuItem(JMeterUtils.getResString("paste"), "Paste", "Paste", KeyStroke.getKeyStroke(86, 2)));
        menu.add(MenuFactory.makeMenuItem(JMeterUtils.getResString("paste_insert"), "Paste Insert", "Paste Insert"));
    }

    public static void addFileMenu(JPopupMenu menu) {
        MenuFactory.addSeparator(menu);
        menu.add(MenuFactory.makeMenuItem(JMeterUtils.getResString("open"), "Open", "open"));
        menu.add(MenuFactory.makeMenuItem(JMeterUtils.getResString("menu_merge"), "Merge", "merge"));
        menu.add(MenuFactory.makeMenuItem(JMeterUtils.getResString("save_as"), "Save As", "save_as"));
        JMenuItem savePicture = MenuFactory.makeMenuItem(JMeterUtils.getResString("save_as_image"), "Save Image", "save_graphics", KeyStroke.getKeyStroke(71, 2));
        menu.add(savePicture);
        if (!(GuiPackage.getInstance().getCurrentGui() instanceof Printable)) {
            savePicture.setEnabled(false);
        }
        JMenuItem disabled = MenuFactory.makeMenuItem(JMeterUtils.getResString("disable"), "Disable", "disable");
        JMenuItem enabled = MenuFactory.makeMenuItem(JMeterUtils.getResString("enable"), "Enable", "enable");
        boolean isEnabled = GuiPackage.getInstance().getTreeListener().getCurrentNode().isEnabled();
        if (isEnabled) {
            disabled.setEnabled(true);
            enabled.setEnabled(false);
        } else {
            disabled.setEnabled(false);
            enabled.setEnabled(true);
        }
        menu.add(enabled);
        menu.add(disabled);
        MenuFactory.addSeparator(menu);
        menu.add(MenuFactory.makeMenuItem(JMeterUtils.getResString("help"), "Help", "help"));
    }

    public static JMenu makeMenus(String[] categories, String label, String actionCommand) {
        JMenu addMenu = new JMenu(label);
        for (int i = 0; i < categories.length; ++i) {
            addMenu.add(MenuFactory.makeMenu(categories[i], actionCommand));
        }
        return addMenu;
    }

    public static JPopupMenu getDefaultControllerMenu() {
        JPopupMenu pop = new JPopupMenu();
        pop.add(MenuFactory.makeMenus(MENU_ADD_CONTROLLER, JMeterUtils.getResString("Add"), "Add"));
        pop.add(MenuFactory.makeMenus(MENU_PARENT_CONTROLLER, JMeterUtils.getResString("insert_parent"), "Add Parent"));
        MenuFactory.addEditMenu(pop, true);
        MenuFactory.addFileMenu(pop);
        return pop;
    }

    public static JPopupMenu getDefaultSamplerMenu() {
        JPopupMenu pop = new JPopupMenu();
        pop.add(MenuFactory.makeMenus(MENU_ADD_SAMPLER, JMeterUtils.getResString("Add"), "Add"));
        pop.add(MenuFactory.makeMenus(MENU_PARENT_SAMPLER, JMeterUtils.getResString("insert_parent"), "Add Parent"));
        MenuFactory.addEditMenu(pop, true);
        MenuFactory.addFileMenu(pop);
        return pop;
    }

    public static JPopupMenu getDefaultConfigElementMenu() {
        JPopupMenu pop = new JPopupMenu();
        MenuFactory.addEditMenu(pop, true);
        MenuFactory.addFileMenu(pop);
        return pop;
    }

    public static JPopupMenu getDefaultVisualizerMenu() {
        JPopupMenu pop = new JPopupMenu();
        MenuFactory.addEditMenu(pop, true);
        MenuFactory.addFileMenu(pop);
        return pop;
    }

    public static JPopupMenu getDefaultTimerMenu() {
        JPopupMenu pop = new JPopupMenu();
        MenuFactory.addEditMenu(pop, true);
        MenuFactory.addFileMenu(pop);
        return pop;
    }

    public static JPopupMenu getDefaultAssertionMenu() {
        JPopupMenu pop = new JPopupMenu();
        MenuFactory.addEditMenu(pop, true);
        MenuFactory.addFileMenu(pop);
        return pop;
    }

    public static JPopupMenu getDefaultExtractorMenu() {
        JPopupMenu pop = new JPopupMenu();
        MenuFactory.addEditMenu(pop, true);
        MenuFactory.addFileMenu(pop);
        return pop;
    }

    public static JMenu makeMenu(String category, String actionCommand) {
        return MenuFactory.makeMenu((Collection)menuMap.get(category), actionCommand, JMeterUtils.getResString(category));
    }

    public static JMenu makeMenu(Collection menuInfo, String actionCommand, String menuName) {
        Iterator iter = menuInfo.iterator();
        JMenu menu = new JMenu(menuName);
        while (iter.hasNext()) {
            MenuInfo info = (MenuInfo)iter.next();
            menu.add(MenuFactory.makeMenuItem(info.label, info.className, actionCommand));
        }
        return menu;
    }

    public static void setEnabled(JMenu menu) {
        if (menu.getSubElements().length == 0) {
            menu.setEnabled(false);
        }
    }

    public static JMenuItem makeMenuItem(String label, String name, String actionCommand) {
        JMenuItem newMenuChoice = new JMenuItem(label);
        newMenuChoice.setName(name);
        newMenuChoice.addActionListener(ActionRouter.getInstance());
        if (actionCommand != null) {
            newMenuChoice.setActionCommand(actionCommand);
        }
        return newMenuChoice;
    }

    public static JMenuItem makeMenuItem(String label, String name, String actionCommand, KeyStroke accel) {
        JMenuItem item = MenuFactory.makeMenuItem(label, name, actionCommand);
        item.setAccelerator(accel);
        return item;
    }

    private static void initializeMenus() {
        try {
            List guiClasses = ClassFinder.findClassesThatExtend((String[])JMeterUtils.getSearchPaths(), (Class[])new Class[]{class$org$apache$jmeter$gui$JMeterGUIComponent == null ? (class$org$apache$jmeter$gui$JMeterGUIComponent = MenuFactory.class$("org.apache.jmeter.gui.JMeterGUIComponent")) : class$org$apache$jmeter$gui$JMeterGUIComponent, class$org$apache$jmeter$testbeans$TestBean == null ? (class$org$apache$jmeter$testbeans$TestBean = MenuFactory.class$("org.apache.jmeter.testbeans.TestBean")) : class$org$apache$jmeter$testbeans$TestBean});
            timers = new LinkedList();
            controllers = new LinkedList();
            samplers = new LinkedList();
            configElements = new LinkedList();
            assertions = new LinkedList();
            listeners = new LinkedList();
            postProcessors = new LinkedList();
            preProcessors = new LinkedList();
            nonTestElements = new LinkedList();
            menuMap.put(TIMERS, timers);
            menuMap.put(ASSERTIONS, assertions);
            menuMap.put(CONFIG_ELEMENTS, configElements);
            menuMap.put(CONTROLLERS, controllers);
            menuMap.put(LISTENERS, listeners);
            menuMap.put(NON_TEST_ELEMENTS, nonTestElements);
            menuMap.put(SAMPLERS, samplers);
            menuMap.put(POST_PROCESSORS, postProcessors);
            menuMap.put(PRE_PROCESSORS, preProcessors);
            Collections.sort(guiClasses);
            Iterator iter = guiClasses.iterator();
            while (iter.hasNext()) {
                JMeterGUIComponent item;
                String name = (String)iter.next();
                if (name.endsWith("JMeterTreeNode") || name.endsWith("TestBeanGUI")) continue;
                try {
                    Class<?> c = Class.forName(name);
                    item = (class$org$apache$jmeter$testbeans$TestBean == null ? MenuFactory.class$("org.apache.jmeter.testbeans.TestBean") : class$org$apache$jmeter$testbeans$TestBean).isAssignableFrom(c) ? new TestBeanGUI(c) : (JMeterGUIComponent)c.newInstance();
                }
                catch (NoClassDefFoundError e) {
                    log.warn("Missing jar? Could not create " + name + ". " + e);
                    continue;
                }
                catch (Throwable e) {
                    log.warn("Could not instantiate " + name, e);
                    continue;
                }
                if (elementsToSkip.contains(name) || elementsToSkip.contains(item.getStaticLabel())) {
                    log.info("Skipping " + name);
                    continue;
                }
                elementsToSkip.add(name);
                Collection categories = item.getMenuCategories();
                if (categories == null) {
                    log.debug(name + " participates in no menus.");
                    continue;
                }
                if (categories.contains(TIMERS)) {
                    timers.add(new MenuInfo(item.getStaticLabel(), name));
                }
                if (categories.contains(POST_PROCESSORS)) {
                    postProcessors.add(new MenuInfo(item.getStaticLabel(), name));
                }
                if (categories.contains(PRE_PROCESSORS)) {
                    preProcessors.add(new MenuInfo(item.getStaticLabel(), name));
                }
                if (categories.contains(CONTROLLERS)) {
                    controllers.add(new MenuInfo(item.getStaticLabel(), name));
                }
                if (categories.contains(SAMPLERS)) {
                    samplers.add(new MenuInfo(item.getStaticLabel(), name));
                }
                if (categories.contains(NON_TEST_ELEMENTS)) {
                    nonTestElements.add(new MenuInfo(item.getStaticLabel(), name));
                }
                if (categories.contains(LISTENERS)) {
                    listeners.add(new MenuInfo(item.getStaticLabel(), name));
                }
                if (categories.contains(CONFIG_ELEMENTS)) {
                    configElements.add(new MenuInfo(item.getStaticLabel(), name));
                }
                if (!categories.contains(ASSERTIONS)) continue;
                assertions.add(new MenuInfo(item.getStaticLabel(), name));
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
    }

    private static void addSeparator(JPopupMenu menu) {
        MenuElement[] elements = menu.getSubElements();
        if (elements.length > 0 && !(elements[elements.length - 1] instanceof JPopupMenu.Separator)) {
            menu.addSeparator();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            String[] classesToSkip = JOrphanUtils.split((String)JMeterUtils.getPropDefault("not_in_menu", ""), (String)",");
            for (int i = 0; i < classesToSkip.length; ++i) {
                elementsToSkip.add(classesToSkip[i].trim());
            }
            MenuFactory.initializeMenus();
        }
        catch (Throwable e) {
            log.error("", e);
        }
    }

    public static class Test
    extends JMeterTestCase {
        public Test() {
        }

        public Test(String name) {
            super(name);
        }

        private static void check(String s, int i) throws Exception {
            Test.assertFalse((String)("The number of " + s + " should not be 0"), (0 == i ? 1 : 0) != 0);
        }

        public void testMenu() throws Exception {
            Test.check("menumap", menuMap.size());
            Test.check("assertions", assertions.size());
            Test.check("configElements", configElements.size());
            Test.check("controllers", controllers.size());
            Test.check("listeners", listeners.size());
            Test.check("nonTestElements", nonTestElements.size());
            Test.check("postProcessors", postProcessors.size());
            Test.check("preProcessors", preProcessors.size());
            Test.check("samplers", samplers.size());
            Test.check("timers", timers.size());
            Test.check("elementstoskip", elementsToSkip.size());
        }
    }
}

