/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.reporters;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.apache.jmeter.reporters.graphPanel;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class FileReporter
extends JPanel {
    private static transient Logger log = LoggingManager.getLoggerForClass();
    Hashtable data = new Hashtable();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(String file) throws IOException {
        File datafile = new File(file);
        BufferedReader reader = null;
        try {
            String line;
            if (datafile.canRead()) {
                reader = new BufferedReader(new FileReader(datafile));
            } else {
                JOptionPane.showMessageDialog(null, "The file you specified cannot be read.", "Information", 1);
                return;
            }
            while ((line = reader.readLine()) != null) {
                try {
                    if ((line = line.trim()).startsWith("#") || line.length() == 0) continue;
                    int splitter = line.lastIndexOf(32);
                    String key = line.substring(0, splitter);
                    int len = line.length() - 1;
                    Integer value = null;
                    value = line.charAt(len) == ',' ? new Integer(line.substring(splitter + 1, len)) : new Integer(line.substring(splitter + 1));
                    Vector<Integer> v = this.getData(key);
                    if (v == null) {
                        v = new Vector<Integer>();
                        this.data.put(key, v);
                    }
                    v.addElement(value);
                }
                catch (NumberFormatException nfe) {
                    log.error("This line could not be parsed: " + line, (Throwable)nfe);
                }
                catch (Exception e) {
                    log.error("This line caused a problem: " + line, (Throwable)e);
                }
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        this.showPanel();
    }

    public Vector getData(String key) {
        return (Vector)this.data.get(key);
    }

    public void showPanel() {
        JFrame f = new JFrame("Data File Report");
        this.setLayout(new BorderLayout());
        graphPanel gp = new graphPanel(this.data);
        this.add((Component)gp, "Center");
        this.add((Component)gp.getStats(), "East");
        this.add((Component)gp.getLegend(), "North");
        f.setSize(500, 300);
        f.getContentPane().add(this);
        f.show();
    }
}

