/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.reporters;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.Hashtable;
import org.apache.jmeter.engine.event.LoopIterationEvent;
import org.apache.jmeter.samplers.Clearable;
import org.apache.jmeter.samplers.SampleEvent;
import org.apache.jmeter.samplers.SampleListener;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jmeter.testelement.TestListener;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.visualizers.RunningSample;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.util.JOrphanUtils;
import org.apache.log.Logger;

public class Summariser
extends AbstractTestElement
implements Serializable,
SampleListener,
TestListener,
Clearable {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final long INTERVAL = JMeterUtils.getPropDefault("summariser.interval", 180);
    private static final boolean TOLOG = JMeterUtils.getPropDefault("summariser.log", true);
    private static final boolean TOOUT = JMeterUtils.getPropDefault("summariser.out", true);
    private static Hashtable accumulators = new Hashtable();
    private transient Totals myTotals = null;
    private transient String myName;
    private static final int INTERVAL_WINDOW = 5;
    private static DecimalFormat dfDouble = new DecimalFormat("#0.0");

    public Summariser() {
    }

    public Summariser(String name) {
        this();
        this.setName(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.myName = this.getName();
        Hashtable hashtable = accumulators;
        synchronized (hashtable) {
            Totals tots = (Totals)accumulators.get(this.myName);
            if (tots != null) {
                tots.clear();
            } else {
                tots = new Totals();
                accumulators.put(this.myName, tots);
            }
        }
        super.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sampleOccurred(SampleEvent e) {
        SampleResult s = e.getResult();
        if (this.myName == null) {
            this.myName = this.getName();
        }
        if (this.myTotals == null) {
            this.myTotals = (Totals)accumulators.get(this.myName);
        }
        if (s != null) {
            this.myTotals.delta.addSample(s);
        }
        long now = System.currentTimeMillis() / 1000L;
        RunningSample myDelta = null;
        RunningSample myTotal = null;
        boolean reportNow = false;
        Totals totals = this.myTotals;
        synchronized (totals) {
            if (now > this.myTotals.last + 5L && now % INTERVAL <= 5L) {
                reportNow = true;
                myDelta = new RunningSample(this.myTotals.delta);
                this.myTotals.moveDelta();
                myTotal = new RunningSample(this.myTotals.total);
                this.myTotals.last = now;
            }
        }
        if (reportNow) {
            String str = this.format(myDelta, "+");
            if (TOLOG) {
                log.info(str);
            }
            if (TOOUT) {
                System.out.println(str);
            }
            if (myTotal.getNumSamples() != myDelta.getNumSamples()) {
                str = this.format(myTotal, "=");
                if (TOLOG) {
                    log.info(str);
                }
                if (TOOUT) {
                    System.out.println(str);
                }
            }
        }
    }

    private static StringBuffer longToSb(StringBuffer sb, long l, int len) {
        sb.setLength(0);
        sb.append(l);
        return JOrphanUtils.rightAlign((StringBuffer)sb, (int)len);
    }

    private static StringBuffer doubleToSb(StringBuffer sb, double d, int len, int frac) {
        sb.setLength(0);
        dfDouble.setMinimumFractionDigits(frac);
        dfDouble.setMaximumFractionDigits(frac);
        sb.append(dfDouble.format(d));
        return JOrphanUtils.rightAlign((StringBuffer)sb, (int)len);
    }

    private String format(RunningSample s, String type) {
        StringBuffer tmp = new StringBuffer(20);
        StringBuffer sb = new StringBuffer(100);
        sb.append(this.myName);
        sb.append(" ");
        sb.append(type);
        sb.append(" ");
        sb.append(Summariser.longToSb(tmp, s.getNumSamples(), 5));
        sb.append(" in ");
        long elapsed = s.getElapsed();
        sb.append(Summariser.doubleToSb(tmp, (double)elapsed / 1000.0, 5, 1));
        sb.append("s = ");
        if (elapsed > 0L) {
            sb.append(Summariser.doubleToSb(tmp, s.getRate(), 6, 1));
        } else {
            sb.append("******");
        }
        sb.append("/s Avg: ");
        sb.append(Summariser.longToSb(tmp, s.getAverage(), 5));
        sb.append(" Min: ");
        sb.append(Summariser.longToSb(tmp, s.getMin(), 5));
        sb.append(" Max: ");
        sb.append(Summariser.longToSb(tmp, s.getMax(), 5));
        sb.append(" Err: ");
        sb.append(Summariser.longToSb(tmp, s.getErrorCount(), 5));
        sb.append(" (");
        sb.append(s.getErrorPercentageString());
        sb.append(")");
        return sb.toString();
    }

    public void sampleStarted(SampleEvent e) {
    }

    public void sampleStopped(SampleEvent e) {
    }

    public void testStarted() {
    }

    public void testEnded() {
        this.testEnded("local");
    }

    public void testStarted(String host) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEnded(String host) {
        Hashtable hashtable = accumulators;
        synchronized (hashtable) {
            Totals t = (Totals)accumulators.get(this.myName);
            if (t.last != -1L) {
                String str;
                if (t.total.getNumSamples() != 0L) {
                    str = this.format(t.delta, "+");
                    if (TOLOG) {
                        log.info(str);
                    }
                    if (TOOUT) {
                        System.out.println(str);
                    }
                }
                t.moveDelta();
                str = this.format(t.total, "=");
                if (TOLOG) {
                    log.info(str);
                }
                if (TOOUT) {
                    System.out.println(str);
                }
                t.last = -1L;
            }
        }
    }

    public void testIterationStart(LoopIterationEvent event) {
    }

    private static class Totals {
        private long last = 0L;
        private RunningSample delta = new RunningSample("DELTA", 0);
        private RunningSample total = new RunningSample("TOTAL", 0);

        private Totals() {
        }

        private void clear() {
            this.delta.clear();
            this.total.clear();
            this.last = 0L;
        }

        private synchronized void moveDelta() {
            this.total.addSample(this.delta);
            this.delta.clear();
        }
    }
}

