/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.resources;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class PackageTest
extends TestCase {
    private static PropertyResourceBundle defaultPRB;
    private static Object[] DUMMY_PARAMS;
    private int subTestFailures = 0;

    private PropertyResourceBundle getRAS(String res) throws Exception {
        InputStream ras = ((Object)((Object)this)).getClass().getResourceAsStream(res);
        return new PropertyResourceBundle(ras);
    }

    private int readRF(String res, List l) throws Exception {
        String s;
        int fails = 0;
        InputStream ras = ((Object)((Object)this)).getClass().getResourceAsStream(res);
        BufferedReader fileReader = new BufferedReader(new InputStreamReader(ras));
        while ((s = fileReader.readLine()) != null) {
            String m;
            if (s.length() <= 0 || s.startsWith("#") || s.startsWith("!")) continue;
            int equ = s.indexOf(61);
            String key = s.substring(0, equ);
            if (key.indexOf(32) >= 0 || !key.toLowerCase().equals(key)) {
                System.out.println("Invalid key for JMeterUtils " + key);
                ++fails;
            }
            String val = s.substring(equ + 1);
            l.add(key);
            if (val.indexOf("{0}") <= 0 || val.indexOf("'") <= 0 || (m = MessageFormat.format(val, DUMMY_PARAMS)).indexOf("{") <= 0) continue;
            ++fails;
            System.out.println("Incorrect message format ? (input/output): ");
            System.out.println(val);
            System.out.println(m);
        }
        return fails;
    }

    private static String getResName(String lang) {
        if (lang.length() == 0) {
            return "messages.properties";
        }
        return "messages_" + lang + ".properties";
    }

    private void check(String resname) throws Exception {
        this.check(resname, true);
    }

    private void check(String resname, boolean checkUnexpected) throws Exception {
        ArrayList alf = new ArrayList(500);
        String res = PackageTest.getResName(resname);
        this.subTestFailures += this.readRF(res, alf);
        Collections.sort(alf);
        String last = "";
        for (int i = 0; i < alf.size(); ++i) {
            String curr = (String)alf.get(i);
            if (curr.equals(last)) {
                ++this.subTestFailures;
                System.out.println("\nDuplicate key =" + curr + " in " + res);
            }
            last = curr;
        }
        if (resname.length() == 0) {
            defaultPRB = this.getRAS(res);
        } else if (checkUnexpected) {
            Enumeration<String> enumr = this.getRAS(res).getKeys();
            while (enumr.hasMoreElements()) {
                String key = null;
                try {
                    key = enumr.nextElement();
                    defaultPRB.getString(key);
                }
                catch (MissingResourceException e) {
                    ++this.subTestFailures;
                    System.out.println("Locale: " + resname + " has unexpected key: " + key);
                }
            }
        }
        if (this.subTestFailures > 0) {
            PackageTest.fail((String)"One or more subtests failed");
        }
    }

    public static Test suite() {
        TestSuite ts = new TestSuite();
        ts.addTest((Test)new PackageTest("atestDefault"));
        ts.addTest((Test)new PackageTest("atestDE"));
        ts.addTest((Test)new PackageTest("atestNO"));
        ts.addTest((Test)new PackageTest("atestJA"));
        ts.addTest((Test)new PackageTest("atestzh_CN"));
        ts.addTest((Test)new PackageTest("atestzh_TW"));
        ts.addTest((Test)new PackageTest("atestFR"));
        ts.addTest((Test)new PackageTest("atestES"));
        return ts;
    }

    public PackageTest(String string) {
        super(string);
    }

    public void atestDE() throws Exception {
        this.check("de");
    }

    public void atestJA() throws Exception {
        this.check("ja");
    }

    public void atestzh_CN() throws Exception {
        this.check("zh_CN");
    }

    public void atestzh_TW() throws Exception {
        this.check("zh_TW");
    }

    public void atestNO() throws Exception {
        this.check("no");
    }

    public void atestFR() throws Exception {
        this.check("fr");
    }

    public void atestES() throws Exception {
        this.check("es");
    }

    public void atestDefault() throws Exception {
        this.check("");
    }

    static {
        DUMMY_PARAMS = new Object[]{"1", "2", "3", "4", "5", "6", "7", "8", "9"};
    }
}

