/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.samplers;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import org.apache.jmeter.samplers.RemoteSampleListener;
import org.apache.jmeter.samplers.SampleEvent;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.SampleSender;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class BatchSampleSender
implements SampleSender,
Serializable {
    private static transient Logger log = LoggingManager.getLoggerForClass();
    private static final int DEFAULT_NUM_SAMPLE_THRESHOLD = 100;
    private static final long DEFAULT_TIME_THRESHOLD = 60000L;
    private RemoteSampleListener listener;
    private List sampleStore = new ArrayList();
    private int numSamplesThreshold;
    private long timeThreshold;
    private long batchSendTime = -1L;

    BatchSampleSender(RemoteSampleListener listener) {
        this.listener = listener;
        this.init();
        log.info("Using batching for this run. Thresholds: num=" + this.numSamplesThreshold + ", time=" + this.timeThreshold);
    }

    private void init() {
        this.numSamplesThreshold = JMeterUtils.getPropDefault("num_sample_threshold", 100);
        this.timeThreshold = JMeterUtils.getPropDefault("time_threshold", 60000L);
    }

    public void testEnded() {
        try {
            if (this.sampleStore.size() != 0) {
                this.listener.processBatch(this.sampleStore);
                this.sampleStore.clear();
            }
            this.listener.testEnded();
        }
        catch (RemoteException err) {
            log.error("testEnded()", (Throwable)err);
        }
    }

    public void testEnded(String host) {
        try {
            if (this.sampleStore.size() != 0) {
                this.listener.processBatch(this.sampleStore);
                this.sampleStore.clear();
            }
            this.listener.testEnded(host);
        }
        catch (RemoteException err) {
            log.error("testEnded(host)", (Throwable)err);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void SampleOccurred(SampleEvent e) {
        List list = this.sampleStore;
        synchronized (list) {
            this.sampleStore.add(e);
            if (this.numSamplesThreshold != -1 && this.sampleStore.size() >= this.numSamplesThreshold) {
                try {
                    log.debug("Firing sample");
                    this.listener.processBatch(this.sampleStore);
                    this.sampleStore.clear();
                }
                catch (RemoteException err) {
                    log.error("sampleOccurred", (Throwable)err);
                }
            }
            if (this.timeThreshold != -1L) {
                SampleResult sr = e.getResult();
                long timestamp = sr.getTimeStamp();
                if (this.batchSendTime == -1L) {
                    this.batchSendTime = timestamp + this.timeThreshold;
                }
                if (this.batchSendTime < timestamp) {
                    try {
                        log.debug("Firing time");
                        if (this.sampleStore.size() > 0) {
                            this.listener.processBatch(this.sampleStore);
                            this.sampleStore.clear();
                        }
                        this.batchSendTime = timestamp + this.timeThreshold;
                    }
                    catch (RemoteException err) {
                        log.error("sampleOccurred", (Throwable)err);
                    }
                }
            }
        }
    }
}

