/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.samplers;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Properties;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testelement.TestPlan;
import org.apache.jmeter.util.JMeterUtils;

public class SampleSaveConfiguration
implements Cloneable,
Serializable {
    static final long serialVersionUID = 1L;
    public static final String XML = "xml";
    public static final String CSV = "csv";
    public static final String DATABASE = "db";
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    public static final String MILLISECONDS = "ms";
    public static final String NONE = "none";
    public static final String FIRST = "first";
    public static final String ALL = "all";
    public static final String ASSERTION_RESULTS_FAILURE_MESSAGE_PROP = "jmeter.save.saveservice.assertion_results_failure_message";
    public static final String ASSERTION_RESULTS_PROP = "jmeter.save.saveservice.assertion_results";
    public static final String DEFAULT_DELIMITER_PROP = "jmeter.save.saveservice.default_delimiter";
    public static final String OUTPUT_FORMAT_PROP = "jmeter.save.saveservice.output_format";
    public static final String PRINT_FIELD_NAMES_PROP = "jmeter.save.saveservice.print_field_names";
    public static final String SAVE_DATA_TYPE_PROP = "jmeter.save.saveservice.data_type";
    public static final String SAVE_LABEL_PROP = "jmeter.save.saveservice.label";
    public static final String SAVE_RESPONSE_CODE_PROP = "jmeter.save.saveservice.response_code";
    public static final String SAVE_RESPONSE_DATA_PROP = "jmeter.save.saveservice.response_data";
    public static final String SAVE_RESPONSE_DATA_ON_ERROR_PROP = "jmeter.save.saveservice.response_data.on_error";
    public static final String SAVE_RESPONSE_MESSAGE_PROP = "jmeter.save.saveservice.response_message";
    public static final String SAVE_SUCCESSFUL_PROP = "jmeter.save.saveservice.successful";
    public static final String SAVE_THREAD_NAME_PROP = "jmeter.save.saveservice.thread_name";
    public static final String SAVE_TIME_PROP = "jmeter.save.saveservice.time";
    public static final String TIME_STAMP_FORMAT_PROP = "jmeter.save.saveservice.timestamp_format";
    public static final String PRESERVE = "preserve";
    public static final String XML_SPACE = "xml:space";
    public static final String ASSERTION_RESULT_TAG_NAME = "assertionResult";
    public static final String BINARY = "binary";
    public static final String DATA_TYPE = "dataType";
    public static final String ERROR = "error";
    public static final String FAILURE = "failure";
    public static final String FAILURE_MESSAGE = "failureMessage";
    public static final String LABEL = "label";
    public static final String RESPONSE_CODE = "responseCode";
    public static final String RESPONSE_MESSAGE = "responseMessage";
    public static final String SAMPLE_RESULT_TAG_NAME = "sampleResult";
    public static final String SUCCESSFUL = "success";
    public static final String THREAD_NAME = "threadName";
    public static final String TIME = "time";
    public static final String TIME_STAMP = "timeStamp";
    private boolean time = _time;
    private boolean latency = _latency;
    private boolean timestamp = _timestamp;
    private boolean success = _success;
    private boolean label = _label;
    private boolean code = _code;
    private boolean message = _message;
    private boolean threadName = _threadName;
    private boolean dataType = _dataType;
    private boolean encoding = _encoding;
    private boolean assertions = _assertions;
    private boolean subresults = _subresults;
    private boolean responseData = _responseData;
    private boolean samplerData = _samplerData;
    private boolean xml = _xml;
    private boolean fieldNames = _fieldNames;
    private boolean responseHeaders = _responseHeaders;
    private boolean requestHeaders = _requestHeaders;
    private boolean responseDataOnError = _responseDataOnError;
    private boolean saveAssertionResultsFailureMessage = _saveAssertionResultsFailureMessage;
    private int assertionsResultsToSave = _assertionsResultsToSave;
    private String delimiter = _delimiter;
    private boolean printMilliseconds = _printMilliseconds;
    private SimpleDateFormat formatter = _formatter;
    private static final boolean _time;
    private static final boolean _timestamp;
    private static final boolean _success;
    private static final boolean _label;
    private static final boolean _code;
    private static final boolean _message;
    private static final boolean _threadName;
    private static final boolean _xml;
    private static final boolean _responseData;
    private static final boolean _dataType;
    private static final boolean _encoding;
    private static final boolean _assertions;
    private static final boolean _latency;
    private static final boolean _subresults;
    private static final boolean _samplerData;
    private static final boolean _fieldNames;
    private static final boolean _responseHeaders;
    private static final boolean _requestHeaders;
    private static final boolean _responseDataOnError;
    private static final boolean _saveAssertionResultsFailureMessage;
    private static final String _timeStampFormat;
    private static int _assertionsResultsToSave;
    public static final int SAVE_NO_ASSERTIONS = 0;
    public static final int SAVE_FIRST_ASSERTION = 1;
    public static final int SAVE_ALL_ASSERTIONS = 2;
    private static final boolean _printMilliseconds;
    private static final SimpleDateFormat _formatter;
    private static final String _delimiter;
    private static final String DEFAULT_DELIMITER = ",";
    private static final SampleSaveConfiguration _static;

    public static SampleSaveConfiguration staticConfig() {
        return _static;
    }

    public Object clone() {
        SampleSaveConfiguration s = new SampleSaveConfiguration();
        s.time = this.time;
        s.latency = this.latency;
        s.timestamp = this.timestamp;
        s.success = this.success;
        s.label = this.label;
        s.code = this.code;
        s.message = this.message;
        s.threadName = this.threadName;
        s.dataType = this.dataType;
        s.encoding = this.encoding;
        s.assertions = this.assertions;
        s.subresults = this.subresults;
        s.responseData = this.responseData;
        s.samplerData = this.samplerData;
        s.xml = this.xml;
        s.fieldNames = this.fieldNames;
        s.responseHeaders = this.responseHeaders;
        s.requestHeaders = this.requestHeaders;
        s.formatter = this.formatter;
        s.assertionsResultsToSave = this.assertionsResultsToSave;
        s.saveAssertionResultsFailureMessage = this.saveAssertionResultsFailureMessage;
        s.delimiter = this.delimiter;
        s.printMilliseconds = this.printMilliseconds;
        s.responseDataOnError = this.responseDataOnError;
        return s;
    }

    public boolean saveResponseHeaders() {
        return this.responseHeaders;
    }

    public void setResponseHeaders(boolean r) {
        this.responseHeaders = r;
    }

    public boolean saveRequestHeaders() {
        return this.requestHeaders;
    }

    public void setRequestHeaders(boolean r) {
        this.requestHeaders = r;
    }

    public boolean saveAssertions() {
        return this.assertions;
    }

    public void setAssertions(boolean assertions) {
        this.assertions = assertions;
    }

    public boolean saveCode() {
        return this.code;
    }

    public void setCode(boolean code) {
        this.code = code;
    }

    public boolean saveDataType() {
        return this.dataType;
    }

    public void setDataType(boolean dataType) {
        this.dataType = dataType;
    }

    public boolean saveEncoding() {
        return this.encoding;
    }

    public void setEncoding(boolean encoding) {
        this.encoding = encoding;
    }

    public boolean saveLabel() {
        return this.label;
    }

    public void setLabel(boolean label) {
        this.label = label;
    }

    public boolean saveLatency() {
        return this.latency;
    }

    public void setLatency(boolean latency) {
        this.latency = latency;
    }

    public boolean saveMessage() {
        return this.message;
    }

    public void setMessage(boolean message) {
        this.message = message;
    }

    public boolean saveResponseData(SampleResult res) {
        return this.responseData || TestPlan.getFunctionalMode() || this.responseDataOnError && !res.isSuccessful();
    }

    public boolean saveResponseData() {
        return this.responseData;
    }

    public void setResponseData(boolean responseData) {
        this.responseData = responseData;
    }

    public boolean saveSamplerData(SampleResult res) {
        return this.samplerData || TestPlan.getFunctionalMode() || this.responseDataOnError && !res.isSuccessful();
    }

    public boolean saveSamplerData() {
        return this.samplerData;
    }

    public void setSamplerData(boolean samplerData) {
        this.samplerData = samplerData;
    }

    public boolean saveSubresults() {
        return this.subresults;
    }

    public void setSubresults(boolean subresults) {
        this.subresults = subresults;
    }

    public boolean saveSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public boolean saveThreadName() {
        return this.threadName;
    }

    public void setThreadName(boolean threadName) {
        this.threadName = threadName;
    }

    public boolean saveTime() {
        return this.time;
    }

    public void setTime(boolean time) {
        this.time = time;
    }

    public boolean saveTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(boolean timestamp) {
        this.timestamp = timestamp;
    }

    public boolean saveAsXml() {
        return this.xml;
    }

    public void setAsXml(boolean xml) {
        this.xml = xml;
    }

    public boolean saveFieldNames() {
        return this.fieldNames;
    }

    public void setFieldNames(boolean printFieldNames) {
        this.fieldNames = printFieldNames;
    }

    public boolean printMilliseconds() {
        return this.printMilliseconds;
    }

    public SimpleDateFormat formatter() {
        return this.formatter;
    }

    public boolean saveAssertionResultsFailureMessage() {
        return this.saveAssertionResultsFailureMessage;
    }

    public void setAssertionResultsFailureMessage(boolean b) {
        this.saveAssertionResultsFailureMessage = b;
    }

    public int assertionsResultsToSave() {
        return this.assertionsResultsToSave;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    static {
        _subresults = true;
        _assertions = true;
        _latency = true;
        _samplerData = false;
        _responseHeaders = false;
        _requestHeaders = false;
        _encoding = false;
        Properties props = JMeterUtils.getJMeterProperties();
        _delimiter = props.getProperty(DEFAULT_DELIMITER_PROP, DEFAULT_DELIMITER);
        _fieldNames = TRUE.equalsIgnoreCase(props.getProperty(PRINT_FIELD_NAMES_PROP, FALSE));
        _dataType = TRUE.equalsIgnoreCase(props.getProperty(SAVE_DATA_TYPE_PROP, TRUE));
        _label = TRUE.equalsIgnoreCase(props.getProperty(SAVE_LABEL_PROP, TRUE));
        _code = TRUE.equalsIgnoreCase(props.getProperty(SAVE_RESPONSE_CODE_PROP, TRUE));
        _responseData = TRUE.equalsIgnoreCase(props.getProperty(SAVE_RESPONSE_DATA_PROP, FALSE));
        _responseDataOnError = TRUE.equalsIgnoreCase(props.getProperty(SAVE_RESPONSE_DATA_ON_ERROR_PROP, FALSE));
        _message = TRUE.equalsIgnoreCase(props.getProperty(SAVE_RESPONSE_MESSAGE_PROP, TRUE));
        _success = TRUE.equalsIgnoreCase(props.getProperty(SAVE_SUCCESSFUL_PROP, TRUE));
        _threadName = TRUE.equalsIgnoreCase(props.getProperty(SAVE_THREAD_NAME_PROP, TRUE));
        _time = TRUE.equalsIgnoreCase(props.getProperty(SAVE_TIME_PROP, TRUE));
        _timeStampFormat = props.getProperty(TIME_STAMP_FORMAT_PROP, MILLISECONDS);
        _printMilliseconds = MILLISECONDS.equalsIgnoreCase(_timeStampFormat);
        _formatter = !_printMilliseconds && !NONE.equalsIgnoreCase(_timeStampFormat) && _timeStampFormat != null ? new SimpleDateFormat(_timeStampFormat) : null;
        _timestamp = !_timeStampFormat.equalsIgnoreCase(NONE);
        _saveAssertionResultsFailureMessage = TRUE.equalsIgnoreCase(props.getProperty(ASSERTION_RESULTS_FAILURE_MESSAGE_PROP, FALSE));
        String whichAssertionResults = props.getProperty(ASSERTION_RESULTS_PROP, NONE);
        if (NONE.equals(whichAssertionResults)) {
            _assertionsResultsToSave = 0;
        } else if (FIRST.equals(whichAssertionResults)) {
            _assertionsResultsToSave = 1;
        } else if (ALL.equals(whichAssertionResults)) {
            _assertionsResultsToSave = 2;
        }
        String howToSave = props.getProperty(OUTPUT_FORMAT_PROP, XML);
        _xml = XML.equals(howToSave);
        _static = new SampleSaveConfiguration();
    }
}

