/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.samplers;

import java.io.Serializable;
import java.rmi.RemoteException;
import org.apache.jmeter.samplers.RemoteSampleListener;
import org.apache.jmeter.samplers.SampleEvent;
import org.apache.jmeter.samplers.SampleSender;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class StandardSampleSender
implements SampleSender,
Serializable {
    private static transient Logger log = LoggingManager.getLoggerForClass();
    RemoteSampleListener listener;

    StandardSampleSender(RemoteSampleListener listener) {
        log.info("Using Standard Remote Sampler for this test run");
        this.listener = listener;
    }

    public void testEnded() {
        log.info("Test ended()");
        try {
            this.listener.testEnded();
        }
        catch (Throwable ex) {
            log.warn("testEnded()", ex);
        }
    }

    public void testEnded(String host) {
        log.info("Test Ended on " + host);
        try {
            this.listener.testEnded(host);
        }
        catch (Throwable ex) {
            log.error("testEnded(host)", ex);
        }
    }

    public void SampleOccurred(SampleEvent e) {
        log.debug("Sample occurred");
        try {
            this.listener.sampleOccurred(e);
        }
        catch (RemoteException err) {
            log.error("sampleOccurred", (Throwable)err);
        }
    }
}

