/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.save;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import javax.swing.JComponent;
import org.apache.batik.ext.awt.image.codec.ImageEncodeParam;
import org.apache.batik.ext.awt.image.codec.PNGEncodeParam;
import org.apache.batik.ext.awt.image.codec.PNGImageEncoder;
import org.apache.batik.ext.awt.image.codec.tiff.TIFFEncodeParam;
import org.apache.batik.ext.awt.image.codec.tiff.TIFFImageEncoder;
import org.apache.jmeter.save.SaveServiceConstants;

public class SaveGraphicsService
implements SaveServiceConstants {
    public static final int PNG = 0;
    public static final int TIFF = 1;
    public static final String PNG_EXTENSION = ".png";
    public static final String TIFF_EXTENSION = ".tif";
    public static final String JPEG_EXTENSION = ".jpg";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveUsingJPEGEncoder(String filename, JComponent component) {
        Dimension size = component.getSize();
        BufferedImage image = new BufferedImage(size.width, size.height, 11);
        Graphics2D grp = image.createGraphics();
        component.paint(grp);
        File outfile = new File(filename + JPEG_EXTENSION);
        FileOutputStream fos = this.createFile(outfile);
        JPEGEncodeParam param = JPEGCodec.getDefaultJPEGEncodeParam((BufferedImage)image);
        Float q = new Float(1.0);
        param.setQuality(q.floatValue(), true);
        JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)fos, (JPEGEncodeParam)param);
        try {
            encoder.encode(image);
            fos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                fos.close();
            }
            catch (Exception e) {}
        }
    }

    public void saveJComponent(String filename, int type, JComponent component) {
        Dimension size = component.getSize();
        BufferedImage image = new BufferedImage(size.width, size.height, 1);
        Graphics2D grp = image.createGraphics();
        component.paint(grp);
        if (type == 0) {
            filename = filename + PNG_EXTENSION;
            this.savePNGWithBatik(filename, image);
        } else if (type == 1) {
            filename = filename + TIFF_EXTENSION;
            this.saveTIFFWithBatik(filename, image);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void savePNGWithBatik(String filename, BufferedImage image) {
        File outfile = new File(filename);
        FileOutputStream fos = this.createFile(outfile);
        PNGEncodeParam param = PNGEncodeParam.getDefaultEncodeParam((RenderedImage)image);
        PNGImageEncoder encoder = new PNGImageEncoder((OutputStream)fos, param);
        try {
            encoder.encode((RenderedImage)image);
        }
        catch (Exception e) {
        }
        finally {
            try {
                ((OutputStream)fos).close();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveTIFFWithBatik(String filename, BufferedImage image) {
        File outfile = new File(filename);
        FileOutputStream fos = this.createFile(outfile);
        TIFFEncodeParam param = new TIFFEncodeParam();
        TIFFImageEncoder encoder = new TIFFImageEncoder((OutputStream)fos, (ImageEncodeParam)param);
        try {
            encoder.encode((RenderedImage)image);
        }
        catch (Exception e) {
        }
        finally {
            try {
                ((OutputStream)fos).close();
            }
            catch (Exception e) {}
        }
    }

    public FileOutputStream createFile(File filename) {
        try {
            return new FileOutputStream(filename);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }
}

