/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.save;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.alias.CannotResolveClassException;
import com.thoughtworks.xstream.converters.Converter;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.jmeter.junit.JMeterTestCase;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.save.OldSaveService;
import org.apache.jmeter.save.ScriptWrapper;
import org.apache.jmeter.save.TestResultWrapper;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.collections.HashTree;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class SaveService {
    private static XStream saver = new XStream();
    private static Logger log = LoggingManager.getLoggerForClass();
    public static final String version = "1.1";
    static String propertiesVersion = "";
    private static final String PROPVERSION = "1.7";
    static boolean versionsOK;
    private static final String REVPFX = "$Revision: ";
    private static final String REVSFX = " $";
    static /* synthetic */ Class class$com$thoughtworks$xstream$alias$ClassMapper;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$apache$jmeter$save$converters$BooleanPropertyConverter;
    static /* synthetic */ Class class$org$apache$jmeter$save$converters$HashTreeConverter;
    static /* synthetic */ Class class$org$apache$jmeter$save$converters$IntegerPropertyConverter;
    static /* synthetic */ Class class$org$apache$jmeter$save$converters$LongPropertyConverter;
    static /* synthetic */ Class class$org$apache$jmeter$save$converters$MultiPropertyConverter;
    static /* synthetic */ Class class$org$apache$jmeter$save$converters$SampleResultConverter;
    static /* synthetic */ Class class$org$apache$jmeter$save$converters$StringPropertyConverter;
    static /* synthetic */ Class class$org$apache$jmeter$save$converters$TestElementConverter;
    static /* synthetic */ Class class$org$apache$jmeter$save$converters$TestElementPropertyConverter;
    static /* synthetic */ Class class$org$apache$jmeter$save$ScriptWrapperConverter;
    static /* synthetic */ Class class$org$apache$jmeter$save$converters$TestResultWrapperConverter;

    private static void makeAlias(String alias, String clazz) {
        try {
            saver.alias(alias, Class.forName(clazz));
        }
        catch (ClassNotFoundException e) {
            log.warn("Could not set up alias " + alias + " " + e.toString());
        }
        catch (NoClassDefFoundError e) {
            log.warn("Could not set up alias " + alias + " " + e.toString());
        }
    }

    private static void initProps() {
        Properties nameMap = new Properties();
        try {
            nameMap.load(new FileInputStream(JMeterUtils.getJMeterHome() + JMeterUtils.getPropDefault("saveservice_properties", "/bin/saveservice.properties")));
            Iterator<Map.Entry<Object, Object>> it = nameMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Object, Object> me = it.next();
                String key = (String)me.getKey();
                String val = (String)me.getValue();
                if (!key.startsWith("_")) {
                    SaveService.makeAlias(key, val);
                    continue;
                }
                if (key.equalsIgnoreCase("_version")) {
                    val = SaveService.extractVersion(val);
                    log.info("Using SaveService properties file " + val);
                    propertiesVersion = val;
                    continue;
                }
                key = key.substring(1);
                try {
                    if (val.trim().equals("collection")) {
                        saver.registerConverter((Converter)Class.forName(key).getConstructor(class$com$thoughtworks$xstream$alias$ClassMapper == null ? SaveService.class$("com.thoughtworks.xstream.alias.ClassMapper") : class$com$thoughtworks$xstream$alias$ClassMapper, class$java$lang$String == null ? SaveService.class$("java.lang.String") : class$java$lang$String).newInstance(saver.getClassMapper(), "class"));
                        continue;
                    }
                    if (val.trim().equals("mapping")) {
                        saver.registerConverter((Converter)Class.forName(key).getConstructor(class$com$thoughtworks$xstream$alias$ClassMapper == null ? SaveService.class$("com.thoughtworks.xstream.alias.ClassMapper") : class$com$thoughtworks$xstream$alias$ClassMapper).newInstance(saver.getClassMapper()));
                        continue;
                    }
                    saver.registerConverter((Converter)Class.forName(key).newInstance());
                }
                catch (IllegalAccessException e1) {
                    log.warn("Can't register a converter: " + key, (Throwable)e1);
                }
                catch (InstantiationException e1) {
                    log.warn("Can't register a converter: " + key, (Throwable)e1);
                }
                catch (ClassNotFoundException e1) {
                    log.warn("Can't register a converter: " + key, (Throwable)e1);
                }
                catch (IllegalArgumentException e1) {
                    log.warn("Can't register a converter: " + key, (Throwable)e1);
                }
                catch (SecurityException e1) {
                    log.warn("Can't register a converter: " + key, (Throwable)e1);
                }
                catch (InvocationTargetException e1) {
                    log.warn("Can't register a converter: " + key, (Throwable)e1);
                }
                catch (NoSuchMethodException e1) {
                    log.warn("Can't register a converter: " + key, (Throwable)e1);
                }
            }
        }
        catch (IOException e) {
            log.error("Bad saveservice properties file", (Throwable)e);
        }
    }

    public static void saveTree(HashTree tree, Writer writer) throws Exception {
        ScriptWrapper wrapper = new ScriptWrapper();
        wrapper.testPlan = tree;
        saver.toXML((Object)wrapper, writer);
        writer.write(10);
    }

    public static void saveElement(Object el, Writer writer) throws Exception {
        saver.toXML(el, writer);
    }

    public static Object loadElement(InputStream in) throws Exception {
        return saver.fromXML((Reader)new InputStreamReader(in));
    }

    public static Object loadElement(Reader in) throws Exception {
        return saver.fromXML(in);
    }

    public static synchronized void saveSampleResult(SampleResult res, Writer writer) throws Exception {
        saver.toXML((Object)res, writer);
        writer.write(10);
    }

    public static synchronized void saveTestElement(TestElement elem, Writer writer) throws Exception {
        saver.toXML((Object)elem, writer);
        writer.write(10);
    }

    private static String extractVersion(String rev) {
        if (rev.length() > REVPFX.length() + REVSFX.length()) {
            return rev.substring(REVPFX.length(), rev.length() - REVSFX.length());
        }
        return rev;
    }

    private static void checkVersion(Class clazz, String expected) {
        String actual = "*NONE*";
        try {
            actual = (String)clazz.getMethod("getVersion", null).invoke(null, null);
            actual = SaveService.extractVersion(actual);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (0 != actual.compareTo(expected)) {
            versionsOK = false;
            log.warn("Version mismatch: expected '" + expected + "' found '" + actual + "' in " + clazz.getName());
        }
    }

    private static void checkVersions() {
        versionsOK = true;
        SaveService.checkVersion(class$org$apache$jmeter$save$converters$BooleanPropertyConverter == null ? (class$org$apache$jmeter$save$converters$BooleanPropertyConverter = SaveService.class$("org.apache.jmeter.save.converters.BooleanPropertyConverter")) : class$org$apache$jmeter$save$converters$BooleanPropertyConverter, "1.5");
        SaveService.checkVersion(class$org$apache$jmeter$save$converters$HashTreeConverter == null ? (class$org$apache$jmeter$save$converters$HashTreeConverter = SaveService.class$("org.apache.jmeter.save.converters.HashTreeConverter")) : class$org$apache$jmeter$save$converters$HashTreeConverter, "1.3");
        SaveService.checkVersion(class$org$apache$jmeter$save$converters$IntegerPropertyConverter == null ? (class$org$apache$jmeter$save$converters$IntegerPropertyConverter = SaveService.class$("org.apache.jmeter.save.converters.IntegerPropertyConverter")) : class$org$apache$jmeter$save$converters$IntegerPropertyConverter, "1.4");
        SaveService.checkVersion(class$org$apache$jmeter$save$converters$LongPropertyConverter == null ? (class$org$apache$jmeter$save$converters$LongPropertyConverter = SaveService.class$("org.apache.jmeter.save.converters.LongPropertyConverter")) : class$org$apache$jmeter$save$converters$LongPropertyConverter, "1.4");
        SaveService.checkVersion(class$org$apache$jmeter$save$converters$MultiPropertyConverter == null ? (class$org$apache$jmeter$save$converters$MultiPropertyConverter = SaveService.class$("org.apache.jmeter.save.converters.MultiPropertyConverter")) : class$org$apache$jmeter$save$converters$MultiPropertyConverter, "1.4");
        SaveService.checkVersion(class$org$apache$jmeter$save$converters$SampleResultConverter == null ? (class$org$apache$jmeter$save$converters$SampleResultConverter = SaveService.class$("org.apache.jmeter.save.converters.SampleResultConverter")) : class$org$apache$jmeter$save$converters$SampleResultConverter, "1.9");
        SaveService.checkVersion(class$org$apache$jmeter$save$converters$StringPropertyConverter == null ? (class$org$apache$jmeter$save$converters$StringPropertyConverter = SaveService.class$("org.apache.jmeter.save.converters.StringPropertyConverter")) : class$org$apache$jmeter$save$converters$StringPropertyConverter, PROPVERSION);
        SaveService.checkVersion(class$org$apache$jmeter$save$converters$TestElementConverter == null ? (class$org$apache$jmeter$save$converters$TestElementConverter = SaveService.class$("org.apache.jmeter.save.converters.TestElementConverter")) : class$org$apache$jmeter$save$converters$TestElementConverter, "1.4");
        SaveService.checkVersion(class$org$apache$jmeter$save$converters$TestElementPropertyConverter == null ? (class$org$apache$jmeter$save$converters$TestElementPropertyConverter = SaveService.class$("org.apache.jmeter.save.converters.TestElementPropertyConverter")) : class$org$apache$jmeter$save$converters$TestElementPropertyConverter, PROPVERSION);
        SaveService.checkVersion(class$org$apache$jmeter$save$ScriptWrapperConverter == null ? (class$org$apache$jmeter$save$ScriptWrapperConverter = SaveService.class$("org.apache.jmeter.save.ScriptWrapperConverter")) : class$org$apache$jmeter$save$ScriptWrapperConverter, "1.6");
        SaveService.checkVersion(class$org$apache$jmeter$save$converters$TestResultWrapperConverter == null ? (class$org$apache$jmeter$save$converters$TestResultWrapperConverter = SaveService.class$("org.apache.jmeter.save.converters.TestResultWrapperConverter")) : class$org$apache$jmeter$save$converters$TestResultWrapperConverter, "1.5");
        if (!PROPVERSION.equalsIgnoreCase(propertiesVersion)) {
            log.warn("Property file - expected 1.7, found " + propertiesVersion);
        }
        if (versionsOK) {
            log.info("All converter versions present and correct");
        }
    }

    public static TestResultWrapper loadTestResults(InputStream reader) throws Exception {
        TestResultWrapper wrapper = (TestResultWrapper)saver.fromXML((Reader)new InputStreamReader(reader));
        return wrapper;
    }

    public static HashTree loadTree(InputStream reader) throws Exception {
        if (!reader.markSupported()) {
            reader = new BufferedInputStream(reader);
        }
        reader.mark(Integer.MAX_VALUE);
        ScriptWrapper wrapper = null;
        try {
            wrapper = (ScriptWrapper)saver.fromXML((Reader)new InputStreamReader(reader));
            return wrapper.testPlan;
        }
        catch (CannotResolveClassException e) {
            log.warn("Problem loading new style: " + e.getLocalizedMessage());
            reader.reset();
            return OldSaveService.loadSubTree(reader);
        }
        catch (NoClassDefFoundError e) {
            log.warn("Missing class ", (Throwable)e);
            return null;
        }
    }

    public static boolean isSaveTestPlanFormat20() {
        return JMeterUtils.getPropDefault("file_format.testplan", "2.1").equals("2.0") || JMeterUtils.getPropDefault("file_format", "2.1").equals("2.0");
    }

    public static boolean isSaveTestLogFormat20() {
        return JMeterUtils.getPropDefault("file_format.testlog", "2.1").equals("2.0") || JMeterUtils.getPropDefault("file_format", "2.1").equals("2.0");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        SaveService.initProps();
        SaveService.checkVersions();
        versionsOK = true;
    }

    public static class Test
    extends JMeterTestCase {
        public Test() {
        }

        public Test(String name) {
            super(name);
        }

        public void testVersions() throws Exception {
            SaveService.initProps();
            SaveService.checkVersions();
            Test.assertTrue((String)"Unexpected version found", (boolean)versionsOK);
            Test.assertEquals((String)"Property Version mismatch", (String)SaveService.PROPVERSION, (String)propertiesVersion);
        }
    }
}

