/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.save.converters;

import com.thoughtworks.xstream.alias.ClassMapper;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.collections.AbstractCollectionConverter;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.io.UnsupportedEncodingException;
import org.apache.jmeter.assertions.AssertionResult;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.SampleSaveConfiguration;
import org.apache.jmeter.save.converters.ConversionHelp;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.util.Converter;
import org.apache.jorphan.util.JOrphanUtils;
import org.apache.log.Logger;

public class SampleResultConverter
extends AbstractCollectionConverter {
    private static final Logger log = LoggingManager.getLoggerForClass();
    static /* synthetic */ Class class$org$apache$jmeter$samplers$SampleResult;

    public static String getVersion() {
        return "$Revision: 1.9 $";
    }

    public boolean canConvert(Class arg0) {
        return (class$org$apache$jmeter$samplers$SampleResult == null ? (class$org$apache$jmeter$samplers$SampleResult = SampleResultConverter.class$("org.apache.jmeter.samplers.SampleResult")) : class$org$apache$jmeter$samplers$SampleResult).equals(arg0);
    }

    public void marshal(Object obj, HierarchicalStreamWriter writer, MarshallingContext context) {
        SampleResult res = (SampleResult)obj;
        SampleSaveConfiguration save = res.getSaveConfig();
        this.setAttributes(writer, context, res, save);
        this.saveAssertions(writer, context, res, save);
        this.saveSubResults(writer, context, res, save);
        this.saveResponseHeaders(writer, context, res, save);
        this.saveRequestHeaders(writer, context, res, save);
        this.saveResponseData(writer, context, res, save);
        this.saveSamplerData(writer, context, res, save);
    }

    protected void saveSamplerData(HierarchicalStreamWriter writer, MarshallingContext context, SampleResult res, SampleSaveConfiguration save) {
        if (save.saveSamplerData(res)) {
            this.writeString(writer, "samplerData", res.getSamplerData());
        }
    }

    protected void saveResponseData(HierarchicalStreamWriter writer, MarshallingContext context, SampleResult res, SampleSaveConfiguration save) {
        if (save.saveResponseData(res)) {
            writer.startNode("responseData");
            try {
                writer.addAttribute("class", "java.lang.String");
                writer.setValue(new String(res.getResponseData(), res.getDataEncoding()));
            }
            catch (UnsupportedEncodingException e) {
                writer.setValue("Unsupported encoding in response data, can't record.");
            }
            writer.endNode();
        }
    }

    protected void saveRequestHeaders(HierarchicalStreamWriter writer, MarshallingContext context, SampleResult res, SampleSaveConfiguration save) {
        if (save.saveRequestHeaders()) {
            this.writeString(writer, "requestHeader", res.getRequestHeaders());
        }
    }

    protected void saveResponseHeaders(HierarchicalStreamWriter writer, MarshallingContext context, SampleResult res, SampleSaveConfiguration save) {
        if (save.saveResponseHeaders()) {
            this.writeString(writer, "responseHeader", res.getResponseHeaders());
        }
    }

    protected void saveSubResults(HierarchicalStreamWriter writer, MarshallingContext context, SampleResult res, SampleSaveConfiguration save) {
        if (save.saveSubresults()) {
            SampleResult[] subResults = res.getSubResults();
            for (int i = 0; i < subResults.length; ++i) {
                subResults[i].setSaveConfig(save);
                this.writeItem(subResults[i], context, writer);
            }
        }
    }

    protected void saveAssertions(HierarchicalStreamWriter writer, MarshallingContext context, SampleResult res, SampleSaveConfiguration save) {
        if (save.saveAssertions()) {
            AssertionResult[] assertionResults = res.getAssertionResults();
            for (int i = 0; i < assertionResults.length; ++i) {
                this.writeItem(assertionResults[i], context, writer);
            }
        }
    }

    protected void setAttributes(HierarchicalStreamWriter writer, MarshallingContext context, SampleResult res, SampleSaveConfiguration save) {
        if (save.saveTime()) {
            writer.addAttribute("t", Long.toString(res.getTime()));
        }
        if (save.saveLatency()) {
            writer.addAttribute("lt", Long.toString(res.getLatency()));
        }
        if (save.saveTimestamp()) {
            writer.addAttribute("ts", Long.toString(res.getTimeStamp()));
        }
        if (save.saveSuccess()) {
            writer.addAttribute("s", JOrphanUtils.booleanToString((boolean)res.isSuccessful()));
        }
        if (save.saveLabel()) {
            writer.addAttribute("lb", ConversionHelp.encode(res.getSampleLabel()));
        }
        if (save.saveCode()) {
            writer.addAttribute("rs", ConversionHelp.encode(res.getResponseCode()));
        }
        if (save.saveMessage()) {
            writer.addAttribute("rm", ConversionHelp.encode(res.getResponseMessage()));
        }
        if (save.saveThreadName()) {
            writer.addAttribute("tn", ConversionHelp.encode(res.getThreadName()));
        }
        if (save.saveDataType()) {
            writer.addAttribute("dt", ConversionHelp.encode(res.getDataType()));
        }
        if (save.saveEncoding()) {
            writer.addAttribute("de", ConversionHelp.encode(res.getDataEncoding()));
        }
    }

    protected void writeString(HierarchicalStreamWriter writer, String tag, String value) {
        if (value != null) {
            writer.startNode(tag);
            writer.addAttribute("class", "java.lang.String");
            writer.setValue(value);
            writer.endNode();
        }
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        SampleResult res = (SampleResult)this.createCollection(context.getRequiredType());
        this.retrieveAttributes(reader, context, res);
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            Object subItem = this.readItem(reader, context, res);
            this.retrieveItem(reader, context, res, subItem);
            reader.moveUp();
        }
        return res;
    }

    protected boolean retrieveItem(HierarchicalStreamReader reader, UnmarshallingContext context, SampleResult res, Object subItem) {
        if (subItem instanceof AssertionResult) {
            res.addAssertionResult((AssertionResult)subItem);
        } else if (subItem instanceof SampleResult) {
            res.addSubResult((SampleResult)subItem);
        } else if (reader.getNodeName().equals("responseHeader")) {
            res.setResponseHeaders((String)subItem);
        } else if (reader.getNodeName().equals("requestHeader")) {
            res.setRequestHeaders((String)subItem);
        } else if (reader.getNodeName().equals("responseData")) {
            try {
                res.setResponseData(((String)subItem).getBytes(res.getDataEncoding()));
            }
            catch (UnsupportedEncodingException e) {
                res.setResponseData(("Can't support the char set: " + res.getDataEncoding()).getBytes());
            }
        } else if (reader.getNodeName().equals("samplerData")) {
            res.setSamplerData((String)subItem);
        } else {
            return false;
        }
        return true;
    }

    protected void retrieveAttributes(HierarchicalStreamReader reader, UnmarshallingContext context, SampleResult res) {
        res.setSampleLabel(ConversionHelp.decode(reader.getAttribute("lb")));
        res.setDataEncoding(ConversionHelp.decode(reader.getAttribute("de")));
        res.setDataType(ConversionHelp.decode(reader.getAttribute("dt")));
        res.setResponseCode(ConversionHelp.decode(reader.getAttribute("rc")));
        res.setResponseMessage(ConversionHelp.decode(reader.getAttribute("rm")));
        res.setSuccessful(Converter.getBoolean((Object)reader.getAttribute("s"), (boolean)true));
        res.setThreadName(ConversionHelp.decode(reader.getAttribute("tn")));
        res.setTime(Converter.getLong((Object)reader.getAttribute("t")));
        res.setTimeStamp(Converter.getLong((Object)reader.getAttribute("ts")));
        res.setLatency(Converter.getLong((Object)reader.getAttribute("lt")));
    }

    public SampleResultConverter(ClassMapper arg0, String arg1) {
        super(arg0, arg1);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

