/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.testbeans.gui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyEditorSupport;
import javax.swing.JTextField;
import junit.framework.TestCase;
import org.apache.jmeter.testbeans.gui.ComboStringEditor;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

class FieldStringEditor
extends PropertyEditorSupport
implements ActionListener,
FocusListener {
    protected static Logger log = LoggingManager.getLoggerForClass();
    private JTextField textField = new JTextField();
    private String initialValue = "";

    protected FieldStringEditor() {
        this.textField.addActionListener(this);
        this.textField.addFocusListener(this);
    }

    public String getAsText() {
        return this.textField.getText();
    }

    public void setAsText(String value) {
        this.initialValue = value;
        this.textField.setText(value);
    }

    public Object getValue() {
        return this.getAsText();
    }

    public void setValue(Object value) {
        if (!(value instanceof String)) {
            throw new IllegalArgumentException();
        }
        this.setAsText((String)value);
    }

    public Component getCustomEditor() {
        return this.textField;
    }

    public void firePropertyChange() {
        String newValue = this.getAsText();
        if (this.initialValue.equals(newValue)) {
            return;
        }
        this.initialValue = newValue;
        super.firePropertyChange();
    }

    public void actionPerformed(ActionEvent e) {
        this.firePropertyChange();
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        this.firePropertyChange();
    }

    public static class Test
    extends TestCase {
        public Test(String name) {
            super(name);
        }

        private void testSetGet(ComboStringEditor e, Object value) throws Exception {
            e.setValue(value);
            Test.assertEquals((Object)value, (Object)e.getValue());
        }

        private void testSetGetAsText(ComboStringEditor e, String text) throws Exception {
            e.setAsText(text);
            Test.assertEquals((String)text, (String)e.getAsText());
        }

        public void testSetGet() throws Exception {
            ComboStringEditor e = new ComboStringEditor();
            this.testSetGet(e, "any string");
            this.testSetGet(e, "");
            this.testSetGet(e, "${var}");
        }

        public void testSetGetAsText() throws Exception {
            ComboStringEditor e = new ComboStringEditor();
            this.testSetGetAsText(e, "any string");
            this.testSetGetAsText(e, "");
            this.testSetGetAsText(e, "${var}");
        }
    }
}

