/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.testbeans.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.BeanInfo;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.beans.PropertyEditorSupport;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.apache.jmeter.testbeans.gui.ComboStringEditor;
import org.apache.jmeter.testbeans.gui.FieldStringEditor;
import org.apache.jmeter.testbeans.gui.SharedCustomizer;
import org.apache.jmeter.testbeans.gui.WrapperEditor;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class GenericTestBeanCustomizer
extends JPanel
implements SharedCustomizer,
PropertyChangeListener {
    private static Logger log = LoggingManager.getLoggerForClass();
    public static final String GROUP = "group";
    public static final String ORDER = "order";
    public static final String TAGS = "tags";
    public static final String NOT_UNDEFINED = "notUndefined";
    public static final String NOT_EXPRESSION = "notExpression";
    public static final String NOT_OTHER = "notOther";
    public static final String DEFAULT = "default";
    public static final String RESOURCE_BUNDLE = "resourceBundle";
    public static final String DEFAULT_GROUP = "";
    private int scrollerCount = 0;
    private BeanInfo beanInfo;
    private PropertyDescriptor[] descriptors;
    private PropertyEditor[] editors;
    private MessageFormat propertyFieldLabelMessage;
    private MessageFormat propertyToolTipMessage;
    private Map propertyMap;

    public static final String ORDER(String group) {
        return "group." + group + ".order";
    }

    GenericTestBeanCustomizer(BeanInfo beanInfo) {
        this.beanInfo = beanInfo;
        this.descriptors = beanInfo.getPropertyDescriptors();
        Arrays.sort(this.descriptors, new PropertyComparator());
        this.editors = new PropertyEditor[this.descriptors.length];
        for (int i = 0; i < this.descriptors.length; ++i) {
            PropertyEditor propertyEditor;
            String name = this.descriptors[i].getName();
            if (this.descriptors[i].isHidden() || this.descriptors[i].isExpert() && !JMeterUtils.isExpertMode() || this.descriptors[i].getReadMethod() == null || this.descriptors[i].getWriteMethod() == null) {
                log.debug("No editor for property " + name);
                this.editors[i] = null;
                continue;
            }
            Class<?> editorClass = this.descriptors[i].getPropertyEditorClass();
            if (log.isDebugEnabled()) {
                log.debug("Property " + name + " has editor class " + editorClass);
            }
            if (editorClass != null) {
                try {
                    propertyEditor = (PropertyEditor)editorClass.newInstance();
                }
                catch (InstantiationException e) {
                    log.error("Can't create property editor.", (Throwable)e);
                    throw new Error(e.toString());
                }
                catch (IllegalAccessException e) {
                    log.error("Can't create property editor.", (Throwable)e);
                    throw new Error(e.toString());
                }
            } else {
                Class<?> c = this.descriptors[i].getPropertyType();
                propertyEditor = PropertyEditorManager.findEditor(c);
            }
            if (log.isDebugEnabled()) {
                log.debug("Property " + name + " has property editor " + propertyEditor);
            }
            if (propertyEditor == null) {
                log.debug("No editor for property " + name);
                this.editors[i] = null;
                continue;
            }
            if (!propertyEditor.supportsCustomEditor()) {
                propertyEditor = this.createWrapperEditor(propertyEditor, this.descriptors[i]);
                if (log.isDebugEnabled()) {
                    log.debug("Editor for property " + name + " is wrapped in " + propertyEditor);
                }
            }
            if (propertyEditor.getCustomEditor() instanceof JScrollPane) {
                ++this.scrollerCount;
            }
            this.editors[i] = propertyEditor;
            this.setEditorValue(i, this.descriptors[i].getValue(DEFAULT));
            propertyEditor.addPropertyChangeListener(this);
        }
        this.propertyFieldLabelMessage = new MessageFormat(JMeterUtils.getResString("property_as_field_label"));
        this.propertyToolTipMessage = new MessageFormat(JMeterUtils.getResString("property_tool_tip"));
        this.init();
    }

    private WrapperEditor createWrapperEditor(PropertyEditor typeEditor, PropertyDescriptor descriptor) {
        PropertyEditorSupport guiEditor;
        String[] editorTags = typeEditor.getTags();
        String[] additionalTags = (String[])descriptor.getValue(TAGS);
        String[] tags = null;
        if (editorTags == null) {
            tags = additionalTags;
        } else if (additionalTags == null) {
            tags = editorTags;
        } else {
            int i;
            tags = new String[editorTags.length + additionalTags.length];
            int j = 0;
            for (i = 0; i < editorTags.length; ++i) {
                tags[j++] = editorTags[i];
            }
            for (i = 0; i < additionalTags.length; ++i) {
                tags[j++] = additionalTags[i];
            }
        }
        boolean notNull = Boolean.TRUE.equals(descriptor.getValue(NOT_UNDEFINED));
        boolean notExpression = Boolean.TRUE.equals(descriptor.getValue(NOT_EXPRESSION));
        boolean notOther = Boolean.TRUE.equals(descriptor.getValue(NOT_OTHER));
        if (notNull && tags == null) {
            guiEditor = new FieldStringEditor();
        } else {
            ComboStringEditor e = new ComboStringEditor();
            e.setNoUndefined(notNull);
            e.setNoEdit(notExpression && notOther);
            e.setTags(tags);
            guiEditor = e;
        }
        WrapperEditor wrapper = new WrapperEditor(typeEditor, guiEditor, !notNull, !notExpression, !notOther, descriptor.getValue(DEFAULT));
        return wrapper;
    }

    private void setEditorValue(int i, Object value) throws IllegalArgumentException {
        this.editors[i].setValue(value);
    }

    public void setObject(Object map) {
        int i;
        this.propertyMap = (Map)map;
        if (this.propertyMap.size() == 0) {
            for (i = 0; i < this.editors.length; ++i) {
                Object value = this.descriptors[i].getValue(DEFAULT);
                String name = this.descriptors[i].getName();
                if (value != null) {
                    this.propertyMap.put(name, value);
                    log.debug("Set " + name + "= " + value);
                }
                this.firePropertyChange(name, null, value);
            }
        }
        for (i = 0; i < this.editors.length; ++i) {
            if (this.editors[i] == null) continue;
            try {
                this.setEditorValue(i, this.propertyMap.get(this.descriptors[i].getName()));
                continue;
            }
            catch (IllegalArgumentException e) {
                this.setEditorValue(i, this.descriptors[i].getValue(DEFAULT));
            }
        }
    }

    private int descriptorIndex(String name) {
        for (int i = 0; i < this.descriptors.length; ++i) {
            if (!this.descriptors[i].getName().equals(name)) continue;
            return i;
        }
        return -1;
    }

    private void init() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints cl = new GridBagConstraints();
        cl.gridx = 0;
        cl.anchor = 13;
        cl.insets = new Insets(0, 1, 0, 1);
        GridBagConstraints ce = new GridBagConstraints();
        ce.fill = 1;
        ce.gridx = 1;
        ce.weightx = 1.0;
        ce.insets = new Insets(0, 1, 0, 1);
        GridBagConstraints cp = new GridBagConstraints();
        cp.fill = 1;
        cp.gridx = 1;
        cp.gridy = -1;
        cp.gridwidth = 2;
        cp.weightx = 1.0;
        JPanel currentPanel = this;
        String currentGroup = DEFAULT_GROUP;
        int y = 0;
        for (int i = 0; i < this.editors.length; ++i) {
            String g;
            if (this.editors[i] == null) continue;
            if (log.isDebugEnabled()) {
                log.debug("Laying property " + this.descriptors[i].getName());
            }
            if (!currentGroup.equals(g = this.group(this.descriptors[i]))) {
                if (currentPanel != this) {
                    this.add((Component)currentPanel, cp);
                }
                currentGroup = g;
                currentPanel = new JPanel(new GridBagLayout());
                currentPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), this.groupDisplayName(g)));
                cp.weighty = 0.0;
                y = 0;
            }
            Component customEditor = this.editors[i].getCustomEditor();
            boolean multiLineEditor = false;
            if (customEditor.getPreferredSize().height > 50 || customEditor instanceof JScrollPane) {
                multiLineEditor = true;
            }
            JLabel label = this.createLabel(this.descriptors[i]);
            label.setLabelFor(customEditor);
            cl.gridy = y;
            cl.gridwidth = multiLineEditor ? 2 : 1;
            cl.anchor = multiLineEditor ? 10 : 13;
            currentPanel.add((Component)label, cl);
            ce.gridx = multiLineEditor ? 0 : 1;
            ce.gridy = multiLineEditor ? ++y : y;
            ce.gridwidth = multiLineEditor ? 2 : 1;
            ce.weighty = multiLineEditor ? 1.0 : 0.0;
            cp.weighty += ce.weighty;
            currentPanel.add(customEditor, ce);
            ++y;
        }
        if (currentPanel != this) {
            this.add((Component)currentPanel, cp);
        }
        cp.weighty = 1.0E-4;
        this.add(Box.createHorizontalStrut(0), cp);
    }

    private JLabel createLabel(PropertyDescriptor desc) {
        String text = desc.getDisplayName();
        if (!DEFAULT_GROUP.equals(text)) {
            text = this.propertyFieldLabelMessage.format(new Object[]{desc.getDisplayName()});
        }
        JLabel label = new JLabel(text);
        label.setHorizontalAlignment(11);
        text = this.propertyToolTipMessage.format(new Object[]{desc.getName(), desc.getShortDescription()});
        label.setToolTipText(text);
        return label;
    }

    private String group(PropertyDescriptor d) {
        String group = (String)d.getValue(GROUP);
        if (group == null) {
            group = DEFAULT_GROUP;
        }
        return group;
    }

    private String groupDisplayName(String group) {
        try {
            ResourceBundle b = (ResourceBundle)this.beanInfo.getBeanDescriptor().getValue(RESOURCE_BUNDLE);
            if (b == null) {
                return group;
            }
            return b.getString(group + ".displayName");
        }
        catch (MissingResourceException e) {
            return group;
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        for (int i = 0; i < this.editors.length; ++i) {
            if (this.editors[i] != evt.getSource()) continue;
            Object value = this.editors[i].getValue();
            String name = this.descriptors[i].getName();
            if (value == null) {
                this.propertyMap.remove(name);
                log.debug("Unset " + name);
            } else {
                this.propertyMap.put(name, value);
                log.debug("Set " + name + "= " + value);
            }
            this.firePropertyChange(name, evt.getOldValue(), value);
            return;
        }
        throw new Error("Unexpected propertyChange event received: " + evt);
    }

    private class PropertyComparator
    implements Comparator {
        private PropertyComparator() {
        }

        public int compare(Object o1, Object o2) {
            return this.compare((PropertyDescriptor)o1, (PropertyDescriptor)o2);
        }

        private int compare(PropertyDescriptor d1, PropertyDescriptor d2) {
            Integer po2;
            Integer go2;
            String g1 = GenericTestBeanCustomizer.this.group(d1);
            String g2 = GenericTestBeanCustomizer.this.group(d2);
            Integer go1 = this.groupOrder(g1);
            int result = go1.compareTo(go2 = this.groupOrder(g2));
            if (result != 0) {
                return result;
            }
            result = g1.compareTo(g2);
            if (result != 0) {
                return result;
            }
            Integer po1 = this.propertyOrder(d1);
            result = po1.compareTo(po2 = this.propertyOrder(d2));
            if (result != 0) {
                return result;
            }
            return d1.getName().compareTo(d2.getName());
        }

        private Integer groupOrder(String group) {
            Integer order = (Integer)GenericTestBeanCustomizer.this.beanInfo.getBeanDescriptor().getValue(GenericTestBeanCustomizer.ORDER(group));
            if (order == null) {
                order = new Integer(0);
            }
            return order;
        }

        private Integer propertyOrder(PropertyDescriptor d) {
            Integer order = (Integer)d.getValue(GenericTestBeanCustomizer.ORDER);
            if (order == null) {
                order = new Integer(0);
            }
            return order;
        }
    }
}

