/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.testbeans.gui;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;
import java.util.ResourceBundle;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.jmeter.junit.JMeterTestCase;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.reflect.ClassFinder;
import org.apache.log.Logger;

public class PackageTest
extends JMeterTestCase {
    private static Logger log = LoggingManager.getLoggerForClass();
    private ResourceBundle defaultBundle;
    private Class testBeanClass;
    private static final Locale defaultLocale = new Locale("en", "");
    private static final Locale[] locales = new Locale[]{new Locale("ja", ""), new Locale("zh", "TW")};
    private Locale testLocale;
    BeanInfo beanInfo;
    ResourceBundle bundle;
    static /* synthetic */ Class class$org$apache$jmeter$testelement$TestElement;
    static /* synthetic */ Class class$org$apache$jmeter$testbeans$TestBean;

    private PackageTest(Class testBeanClass, Locale locale, ResourceBundle defaultBundle) {
        super(testBeanClass.getName() + " - " + locale.getLanguage() + " - " + locale.getCountry());
        this.testBeanClass = testBeanClass;
        this.testLocale = locale;
        this.defaultBundle = defaultBundle;
    }

    public void setUp() {
        JMeterUtils.setLocale(this.testLocale);
        Introspector.flushFromCaches(this.testBeanClass);
        try {
            this.beanInfo = Introspector.getBeanInfo(this.testBeanClass);
            this.bundle = (ResourceBundle)this.beanInfo.getBeanDescriptor().getValue("resourceBundle");
        }
        catch (IntrospectionException e) {
            log.error("Can't get beanInfo for " + this.testBeanClass.getName(), (Throwable)e);
            throw new Error(e.toString());
        }
        if (this.bundle == null) {
            throw new Error("This can't happen!");
        }
    }

    public void tearDown() {
        JMeterUtils.setLocale(Locale.getDefault());
    }

    public void runTest() {
        if (this.bundle == this.defaultBundle) {
            this.checkAllNecessaryKeysPresent();
        } else {
            this.checkNoInventedKeys();
        }
    }

    public void checkNoInventedKeys() {
        Enumeration<String> keys = this.bundle.getKeys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            this.defaultBundle.getString(key);
        }
    }

    public void checkAllNecessaryKeysPresent() {
        String dn = this.defaultBundle.getString("displayName").toUpperCase(Locale.ENGLISH);
        if (dn.indexOf("(ALPHA") != -1 || dn.indexOf("(EXPERIMENTAL") != -1) {
            return;
        }
        PropertyDescriptor[] descriptors = this.beanInfo.getPropertyDescriptors();
        for (int i = 0; i < descriptors.length; ++i) {
            if (descriptors[i].isHidden() || descriptors[i].getReadMethod() == null || descriptors[i].getWriteMethod() == null || (class$org$apache$jmeter$testelement$TestElement == null ? PackageTest.class$("org.apache.jmeter.testelement.TestElement") : class$org$apache$jmeter$testelement$TestElement).isAssignableFrom(descriptors[i].getPropertyType()) && descriptors[i].getPropertyEditorClass() == null) continue;
            String name = descriptors[i].getName();
            this.bundle.getString(name + ".displayName");
            String group = (String)descriptors[i].getValue("group");
            if (group == null) continue;
            this.bundle.getString(group + ".displayName");
        }
    }

    public static Test suite() throws Exception {
        TestSuite suite = new TestSuite("Bean Resource Test Suite");
        Iterator iter = ClassFinder.findClassesThatExtend((String[])JMeterUtils.getSearchPaths(), (Class[])new Class[]{class$org$apache$jmeter$testbeans$TestBean == null ? (class$org$apache$jmeter$testbeans$TestBean = PackageTest.class$("org.apache.jmeter.testbeans.TestBean")) : class$org$apache$jmeter$testbeans$TestBean}).iterator();
        while (iter.hasNext()) {
            ResourceBundle defaultBundle;
            String className = (String)iter.next();
            Class<?> testBeanClass = Class.forName(className);
            JMeterUtils.setLocale(defaultLocale);
            try {
                defaultBundle = (ResourceBundle)Introspector.getBeanInfo(testBeanClass).getBeanDescriptor().getValue("resourceBundle");
            }
            catch (IntrospectionException e) {
                log.error("Can't get beanInfo for " + testBeanClass.getName(), (Throwable)e);
                throw new Error(e.toString());
            }
            if (defaultBundle == null) {
                if (className.startsWith("org.apache.jmeter.examples.")) {
                    log.warn("No default bundle found for " + className);
                    continue;
                }
                throw new Error("No default bundle for class " + className);
            }
            suite.addTest((Test)new PackageTest(testBeanClass, defaultLocale, defaultBundle));
            for (int i = 0; i < locales.length; ++i) {
                suite.addTest((Test)new PackageTest(testBeanClass, locales[i], defaultBundle));
            }
        }
        return suite;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

