/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.testelement;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.jmeter.NewDriver;
import org.apache.jmeter.config.Arguments;
import org.apache.jmeter.config.ConfigElement;
import org.apache.jmeter.engine.event.LoopIterationEvent;
import org.apache.jmeter.services.FileServer;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.TestListener;
import org.apache.jmeter.testelement.property.BooleanProperty;
import org.apache.jmeter.testelement.property.CollectionProperty;
import org.apache.jmeter.testelement.property.StringProperty;
import org.apache.jmeter.testelement.property.TestElementProperty;
import org.apache.jmeter.threads.ThreadGroup;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.util.JOrphanUtils;
import org.apache.log.Logger;

public class TestPlan
extends AbstractTestElement
implements Serializable,
TestListener {
    private static Logger log = LoggingManager.getLoggerForClass();
    public static final String THREAD_GROUPS = "TestPlan.thread_groups";
    public static final String FUNCTIONAL_MODE = "TestPlan.functional_mode";
    public static final String USER_DEFINED_VARIABLES = "TestPlan.user_defined_variables";
    public static final String SERIALIZE_THREADGROUPS = "TestPlan.serialize_threadgroups";
    public static final String CLASSPATHS = "TestPlan.user_define_classpath";
    private static final String CLASSPATH_SEPARATOR = ",";
    public static final String COMMENTS = "TestPlan.comments";
    public static final String BASEDIR = "basedir";
    private transient List threadGroups = new LinkedList();
    private transient List configs = new LinkedList();
    private static List itemsCanAdd = new LinkedList();
    private static TestPlan plan;
    private static boolean functionalMode;

    public TestPlan() {
    }

    public TestPlan(String name) {
        this.setName(name);
        this.setProperty(new CollectionProperty(THREAD_GROUPS, this.threadGroups));
    }

    public void prepareForPreCompile() {
        this.getVariables().setRunningVersion(true);
    }

    public boolean isFunctionalMode() {
        return this.getPropertyAsBoolean(FUNCTIONAL_MODE);
    }

    public void setUserDefinedVariables(Arguments vars) {
        this.setProperty(new TestElementProperty(USER_DEFINED_VARIABLES, vars));
    }

    public String getBasedir() {
        return this.getPropertyAsString(BASEDIR);
    }

    public void setBasedir(String b) {
        this.setProperty(BASEDIR, b);
    }

    public Map getUserDefinedVariables() {
        Arguments args = this.getVariables();
        return args.getArgumentsAsMap();
    }

    private Arguments getVariables() {
        Arguments args = (Arguments)this.getProperty(USER_DEFINED_VARIABLES).getObjectValue();
        if (args == null) {
            args = new Arguments();
            this.setUserDefinedVariables(args);
        }
        return args;
    }

    public void setFunctionalMode(boolean funcMode) {
        this.setProperty(new BooleanProperty(FUNCTIONAL_MODE, funcMode));
        functionalMode = funcMode;
    }

    public static boolean getFunctionalMode() {
        return functionalMode;
    }

    public void setSerialized(boolean serializeTGs) {
        this.setProperty(new BooleanProperty(SERIALIZE_THREADGROUPS, serializeTGs));
    }

    public void setTestPlanClasspath(String text) {
        this.setProperty(CLASSPATHS, text);
    }

    public void setTestPlanClasspathArray(String[] text) {
        StringBuffer cat = new StringBuffer();
        for (int idx = 0; idx < text.length; ++idx) {
            if (idx > 0) {
                cat.append(CLASSPATH_SEPARATOR);
            }
            cat.append(text[idx]);
        }
        this.setTestPlanClasspath(cat.toString());
    }

    public String[] getTestPlanClasspathArray() {
        return JOrphanUtils.split((String)this.getTestPlanClasspath(), (String)CLASSPATH_SEPARATOR);
    }

    public String getTestPlanClasspath() {
        return this.getPropertyAsString(CLASSPATHS);
    }

    public boolean isSerialized() {
        return this.getPropertyAsBoolean(SERIALIZE_THREADGROUPS);
    }

    public void addParameter(String name, String value) {
        this.getVariables().addArgument(name, value);
    }

    public static TestPlan createTestPlan(String name) {
        if (plan == null) {
            plan = name == null ? new TestPlan() : new TestPlan(name);
            plan.setProperty(new StringProperty("TestElement.gui_class", "org.apache.jmeter.control.gui.TestPlanGui"));
        }
        return plan;
    }

    public void addTestElement(TestElement tg) {
        super.addTestElement(tg);
        if (tg instanceof ThreadGroup && !this.isRunningVersion()) {
            this.addThreadGroup((ThreadGroup)tg);
        }
    }

    public void addJMeterComponent(TestElement child) {
        if (child instanceof ThreadGroup) {
            this.addThreadGroup((ThreadGroup)child);
        }
    }

    public Collection getThreadGroups() {
        return this.threadGroups;
    }

    public void addConfigElement(ConfigElement c) {
        this.configs.add(c);
    }

    public void addThreadGroup(ThreadGroup group) {
        this.threadGroups.add(group);
    }

    public void testEnded() {
        try {
            FileServer.getFileServer().closeFiles();
        }
        catch (IOException e) {
            log.error("Problem closing files at end of test", (Throwable)e);
        }
    }

    public void testEnded(String host) {
        this.testEnded();
    }

    public void testIterationStart(LoopIterationEvent event) {
    }

    public void testStarted() {
        if (this.getBasedir() != null && this.getBasedir().length() > 0) {
            try {
                FileServer.getFileServer().setBasedir(FileServer.getFileServer().getBaseDir() + this.getBasedir());
            }
            catch (IOException e) {
                log.error("Failed to set file server base dir with " + this.getBasedir(), (Throwable)e);
            }
        }
        String[] paths = this.getTestPlanClasspathArray();
        for (int idx = 0; idx < paths.length; ++idx) {
            NewDriver.addURL(paths[idx]);
            log.info("add " + paths[idx] + " to classpath");
        }
    }

    public void testStarted(String host) {
        this.testStarted();
    }

    static {
        functionalMode = false;
        itemsCanAdd.add(JMeterUtils.getResString("threadgroup"));
    }
}

