/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.testelement.property;

import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.NumberProperty;

public class IntegerProperty
extends NumberProperty {
    int value;
    int savedValue;

    public IntegerProperty(String name, int value) {
        super(name);
        this.value = value;
    }

    public void setRunningVersion(boolean runningVersion) {
        this.savedValue = this.value;
        super.setRunningVersion(runningVersion);
    }

    public void recoverRunningVersion(TestElement owner) {
        this.value = this.savedValue;
    }

    public IntegerProperty(String name) {
        super(name);
    }

    public IntegerProperty() {
    }

    public void setValue(int value) {
        this.value = value;
    }

    protected void setNumberValue(Number n) {
        this.value = n.intValue();
    }

    protected void setNumberValue(String n) throws NumberFormatException {
        this.value = Integer.parseInt(n);
    }

    public String getStringValue() {
        return Integer.toString(this.value);
    }

    public Object getObjectValue() {
        return new Integer(this.value);
    }

    public Object clone() {
        IntegerProperty prop = (IntegerProperty)super.clone();
        prop.value = this.value;
        return prop;
    }

    public boolean getBooleanValue() {
        return this.getIntValue() > 0;
    }

    public double getDoubleValue() {
        return this.value;
    }

    public float getFloatValue() {
        return this.value;
    }

    public int getIntValue() {
        return this.value;
    }

    public long getLongValue() {
        return this.value;
    }
}

