/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.testelement.property;

import java.util.Map;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.MultiProperty;
import org.apache.jmeter.testelement.property.PropertyIterator;

public class MapProperty
extends MultiProperty {
    Map value;
    transient Map savedValue = null;
    static /* synthetic */ Class class$org$apache$jmeter$testelement$property$NullProperty;

    public MapProperty(String name, Map value) {
        super(name);
        log.info("map = " + value);
        this.value = this.normalizeMap(value);
        log.info("normalized map = " + this.value);
    }

    public MapProperty() {
    }

    public boolean equals(Object o) {
        if (o instanceof MapProperty && this.value != null) {
            return ((Object)this.value).equals(((JMeterProperty)o).getObjectValue());
        }
        return false;
    }

    public void setObjectValue(Object v) {
        if (v instanceof Map) {
            this.setMap((Map)v);
        }
    }

    public void addProperty(JMeterProperty prop) {
        this.addProperty(prop.getName(), prop);
    }

    public JMeterProperty get(String key) {
        return (JMeterProperty)this.value.get(key);
    }

    protected Class getPropertyType() {
        if (this.value.size() > 0) {
            return this.valueIterator().next().getClass();
        }
        return class$org$apache$jmeter$testelement$property$NullProperty == null ? (class$org$apache$jmeter$testelement$property$NullProperty = MapProperty.class$("org.apache.jmeter.testelement.property.NullProperty")) : class$org$apache$jmeter$testelement$property$NullProperty;
    }

    public String getStringValue() {
        return this.value.toString();
    }

    public Object getObjectValue() {
        return this.value;
    }

    public Object clone() {
        MapProperty prop = (MapProperty)super.clone();
        prop.value = this.cloneMap();
        return prop;
    }

    private Map cloneMap() {
        try {
            Map newCol = (Map)this.value.getClass().newInstance();
            PropertyIterator iter = this.valueIterator();
            while (iter.hasNext()) {
                JMeterProperty item = iter.next();
                newCol.put(item.getName(), item.clone());
            }
            return newCol;
        }
        catch (Exception e) {
            log.error("Couldn't clone map", (Throwable)e);
            return this.value;
        }
    }

    public PropertyIterator valueIterator() {
        return this.getIterator(this.value.values());
    }

    public void addProperty(String name, JMeterProperty prop) {
        if (!this.value.containsKey(name)) {
            this.value.put(name, prop);
        }
    }

    public void setMap(Map newMap) {
        this.value = this.normalizeMap(newMap);
    }

    public void recoverRunningVersion(TestElement owner) {
        if (this.savedValue != null) {
            this.value = this.savedValue;
        }
        this.recoverRunningVersionOfSubElements(owner);
    }

    public void clear() {
        this.value.clear();
    }

    public PropertyIterator iterator() {
        return this.valueIterator();
    }

    public void setRunningVersion(boolean running) {
        super.setRunningVersion(running);
        this.savedValue = running ? this.value : null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

