/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.testelement.property;

import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.MultiProperty;
import org.apache.jmeter.testelement.property.PropertyIterator;

public class TestElementProperty
extends MultiProperty {
    TestElement value;
    transient TestElement savedValue = null;

    public TestElementProperty(String name, TestElement value) {
        super(name);
        this.value = value;
    }

    public TestElementProperty() {
    }

    public boolean equals(Object o) {
        if (o instanceof TestElementProperty) {
            if (this == o) {
                return true;
            }
            if (this.value != null) {
                return this.value.equals(((JMeterProperty)o).getObjectValue());
            }
        }
        return false;
    }

    public int hashCode() {
        return this.value == null ? 0 : this.value.hashCode();
    }

    public String getStringValue() {
        return this.value.toString();
    }

    public void setObjectValue(Object v) {
        if (v instanceof TestElement) {
            this.value = (TestElement)v;
        }
    }

    public Object getObjectValue() {
        return this.value;
    }

    public TestElement getElement() {
        return this.value;
    }

    public void setElement(TestElement el) {
        this.value = el;
    }

    public Object clone() {
        TestElementProperty prop = (TestElementProperty)super.clone();
        prop.value = (TestElement)this.value.clone();
        return prop;
    }

    public void mergeIn(JMeterProperty prop) {
        if (this.isEqualType(prop)) {
            this.value.addTestElement((TestElement)prop.getObjectValue());
        }
    }

    public void recoverRunningVersion(TestElement owner) {
        if (this.savedValue != null) {
            this.value = this.savedValue;
        }
        this.value.recoverRunningVersion();
    }

    public void setRunningVersion(boolean runningVersion) {
        super.setRunningVersion(runningVersion);
        this.value.setRunningVersion(runningVersion);
        this.savedValue = runningVersion ? this.value : null;
    }

    public void addProperty(JMeterProperty prop) {
        this.value.setProperty(prop);
    }

    public void clear() {
        this.value.clear();
    }

    public PropertyIterator iterator() {
        return this.value.propertyIterator();
    }
}

