/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.threads;

import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.Buffer;
import org.apache.commons.collections.BufferUtils;
import org.apache.commons.collections.UnboundedFifoBuffer;
import org.apache.jmeter.samplers.SampleEvent;
import org.apache.jmeter.samplers.SampleListener;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class ListenerNotifier {
    private static Logger log = LoggingManager.getLoggerForClass();
    private static final int SLEEP_TIME = 2000;
    private boolean running = true;
    private boolean isStopped = true;
    private Buffer listenerEvents = BufferUtils.synchronizedBuffer((Buffer)new UnboundedFifoBuffer());

    public void stop() {
        this.running = false;
    }

    public boolean isStopped() {
        return this.isStopped;
    }

    public void run() {
        boolean isMaximumPriority = false;
        int normalCount = 0;
        while (this.running) {
            long startTime = System.currentTimeMillis();
            this.processNotifications();
            long sleep = 2000L - (System.currentTimeMillis() - startTime);
            if (!this.running) break;
            if (sleep < 0L) {
                isMaximumPriority = true;
                normalCount = 0;
                if (log.isInfoEnabled()) {
                    log.info("ListenerNotifier exceeded maximum notification time by " + -sleep + "ms");
                }
                this.boostPriority();
                continue;
            }
            if (isMaximumPriority && ++normalCount >= 3) {
                isMaximumPriority = false;
                this.unboostPriority();
            }
            if (log.isDebugEnabled()) {
                log.debug("ListenerNotifier sleeping for " + sleep + "ms");
            }
            try {
                Thread.sleep(sleep);
            }
            catch (InterruptedException e) {}
        }
        this.processNotifications();
        this.isStopped = true;
    }

    private void processNotifications() {
        int listenerEventsSize = this.listenerEvents.size();
        if (log.isDebugEnabled()) {
            log.debug("ListenerNotifier: processing " + listenerEventsSize + " events");
        }
        while (listenerEventsSize > 0) {
            SampleEvent res = (SampleEvent)this.listenerEvents.remove();
            List listeners = (List)this.listenerEvents.remove();
            this.notifyListeners(res, listeners);
            listenerEventsSize -= 2;
        }
    }

    private void boostPriority() {
        if (Thread.currentThread().getPriority() != 10) {
            log.info("ListenerNotifier: Boosting thread priority to maximum.");
            Thread.currentThread().setPriority(10);
        }
    }

    private void unboostPriority() {
        if (Thread.currentThread().getPriority() != 5) {
            log.info("ListenerNotifier: Returning thread priority to normal.");
            Thread.currentThread().setPriority(5);
        }
    }

    public void notifyListeners(SampleEvent res, List listeners) {
        Iterator iter = listeners.iterator();
        while (iter.hasNext()) {
            try {
                ((SampleListener)iter.next()).sampleOccurred(res);
            }
            catch (RuntimeException e) {
                log.error("Detected problem in Listener: ", (Throwable)e);
                log.info("Continuing to process further listeners");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLast(SampleEvent item, List listeners) {
        Buffer buffer = this.listenerEvents;
        synchronized (buffer) {
            this.listenerEvents.add((Object)item);
            this.listenerEvents.add((Object)listeners);
        }
    }
}

