/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.util.JMeterError;
import org.apache.jorphan.util.JMeterException;
import org.apache.log.Logger;

public class BeanShellInterpreter {
    private static Logger log;
    private static final Method bshGet;
    private static final Method bshSet;
    private static final Method bshEval;
    private static final Method bshSource;
    private static final Class bshClass;
    private transient Object bshInstance = null;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Object;

    public BeanShellInterpreter() throws ClassNotFoundException {
        if (bshClass == null) {
            throw new ClassNotFoundException("bsh.Interpreter");
        }
        try {
            this.bshInstance = bshClass.newInstance();
        }
        catch (InstantiationException e) {
            log.error("Can't instantiate BeanShell", (Throwable)e);
            throw new ClassNotFoundException("Can't instantiate BeanShell", e);
        }
        catch (IllegalAccessException e) {
            log.error("Can't instantiate BeanShell", (Throwable)e);
            throw new ClassNotFoundException("Can't instantiate BeanShell", e);
        }
    }

    public void init(String initFile, Object logger) throws IOException, JMeterException {
        if (logger != null) {
            try {
                this.set("log", logger);
            }
            catch (JMeterException e) {
                log.error("Can't set logger variable", (Throwable)e);
                throw e;
            }
        }
        if (initFile != null && initFile.length() > 0) {
            File in = new File(initFile);
            if (!in.exists()) {
                throw new FileNotFoundException("initFile");
            }
            if (!in.canRead()) {
                throw new IOException("initFile");
            }
            this.source(initFile);
        }
    }

    private Object bshInvoke(Method m, String s) throws JMeterException {
        Object r = null;
        try {
            r = m.invoke(this.bshInstance, s);
        }
        catch (IllegalArgumentException e) {
            log.error("Error invoking bsh method " + m.getName() + "\n", (Throwable)e);
            throw new JMeterError("Error invoking bsh method " + m.getName(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            log.error("Error invoking bsh method " + m.getName() + "\n", (Throwable)e);
            throw new JMeterError("Error invoking bsh method " + m.getName(), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            log.error("Error invoking bsh method " + m.getName() + "\n", (Throwable)e);
            throw new JMeterException("Error invoking bsh method " + m.getName(), (Throwable)e);
        }
        return r;
    }

    private Object bshInvoke(Method m, String s, Object o) throws JMeterException {
        Object r = null;
        try {
            r = m.invoke(this.bshInstance, s, o);
        }
        catch (IllegalArgumentException e) {
            log.error("Error invoking bsh method " + m.getName() + "\n", (Throwable)e);
            throw new JMeterError("Error invoking bsh method " + m.getName(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            log.error("Error invoking bsh method " + m.getName() + "\n", (Throwable)e);
            throw new JMeterError("Error invoking bsh method " + m.getName(), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            log.error("Error invoking bsh method " + m.getName() + "\n", (Throwable)e);
            throw new JMeterException("Error invoking bsh method " + m.getName(), (Throwable)e);
        }
        return r;
    }

    public Object eval(String s) throws JMeterException {
        return this.bshInvoke(bshEval, s);
    }

    public Object set(String s, Object o) throws JMeterException {
        return this.bshInvoke(bshSet, s, o);
    }

    public Object set(String s, boolean b) throws JMeterException {
        return this.bshInvoke(bshSet, s, b ? Boolean.TRUE : Boolean.FALSE);
    }

    public Object source(String s) throws JMeterException {
        return this.bshInvoke(bshSource, s);
    }

    public Object get(String s) throws JMeterException {
        return this.bshInvoke(bshGet, s);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        block6: {
            log = LoggingManager.getLoggerForClass();
            Method get = null;
            Method eval = null;
            Method set = null;
            Method source = null;
            Class<?> clazz = null;
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            try {
                try {
                    clazz = loader.loadClass("bsh.Interpreter");
                    Class string = class$java$lang$String == null ? (class$java$lang$String = BeanShellInterpreter.class$("java.lang.String")) : class$java$lang$String;
                    Class object = class$java$lang$Object == null ? (class$java$lang$Object = BeanShellInterpreter.class$("java.lang.Object")) : class$java$lang$Object;
                    get = clazz.getMethod("get", string);
                    eval = clazz.getMethod("eval", string);
                    set = clazz.getMethod("set", string, object);
                    source = clazz.getMethod("source", string);
                }
                catch (ClassNotFoundException e) {
                    log.error("Beanshell Interpreter not found");
                    Object var9_12 = null;
                    bshEval = eval;
                    bshGet = get;
                    bshSet = set;
                    bshSource = source;
                    bshClass = clazz;
                    break block6;
                }
                catch (SecurityException e) {
                    log.error("Beanshell Interpreter not found", (Throwable)e);
                    Object var9_13 = null;
                    bshEval = eval;
                    bshGet = get;
                    bshSet = set;
                    bshSource = source;
                    bshClass = clazz;
                    break block6;
                }
                catch (NoSuchMethodException e) {
                    log.error("Beanshell Interpreter not found", (Throwable)e);
                    Object var9_14 = null;
                    bshEval = eval;
                    bshGet = get;
                    bshSet = set;
                    bshSource = source;
                    bshClass = clazz;
                }
                Object var9_11 = null;
                bshEval = eval;
                bshGet = get;
                bshSet = set;
                bshSource = source;
                bshClass = clazz;
            }
            catch (Throwable throwable) {
                Object var9_15 = null;
                bshEval = eval;
                bshGet = get;
                bshSet = set;
                bshSource = source;
                bshClass = clazz;
                throw throwable;
            }
        }
    }
}

