/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.util;

import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.Random;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.util.JMeterVersion;
import org.apache.jmeter.util.LocaleChangeEvent;
import org.apache.jmeter.util.LocaleChangeListener;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.test.UnitTestManager;
import org.apache.jorphan.util.JOrphanUtils;
import org.apache.log.Logger;
import org.apache.oro.text.PatternCacheLRU;
import org.apache.oro.text.regex.PatternCompiler;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.xml.sax.XMLReader;

public class JMeterUtils
implements UnitTestManager {
    private static PatternCacheLRU patternCache = new PatternCacheLRU(1000, (PatternCompiler)new Perl5Compiler());
    private static transient Logger log = LoggingManager.getLoggerForClass();
    private static final String EXPERT_MODE_PROPERTY = "jmeter.expertMode";
    private static Properties appProperties;
    private static Vector localeChangeListeners;
    private static Locale locale;
    private static ResourceBundle resources;
    private static ThreadLocal localMatcher;
    private static Random rand;
    public static final String RES_KEY_PFX = "[res_key=";
    private static String jmDir;
    public static final String JMETER = "jmeter";
    public static final String ENGINE = "jmeter.engine";
    public static final String ELEMENTS = "jmeter.elements";
    public static final String GUI = "jmeter.gui";
    public static final String UTIL = "jmeter.util";
    public static final String CLASSFINDER = "jmeter.util.classfinder";
    public static final String TEST = "jmeter.test";
    public static final String HTTP = "jmeter.protocol.http";
    public static final String JDBC = "jmeter.protocol.jdbc";
    public static final String FTP = "jmeter.protocol.ftp";
    public static final String JAVA = "jmeter.protocol.java";
    public static final String PROPERTIES = "jmeter.elements.properties";
    static /* synthetic */ Class class$org$apache$jmeter$util$JMeterUtils;

    public static Perl5Matcher getMatcher() {
        return (Perl5Matcher)localMatcher.get();
    }

    public static Properties getProperties(String file) {
        Properties p = new Properties(System.getProperties());
        try {
            File f = new File(file);
            p.load(new FileInputStream(f));
        }
        catch (IOException e) {
            try {
                InputStream is = ClassLoader.getSystemResourceAsStream("org/apache/jmeter/jmeter.properties");
                if (is == null) {
                    throw new RuntimeException("Could not read JMeter properties file");
                }
                p.load(is);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        appProperties = p;
        LoggingManager.initializeLogging((Properties)appProperties);
        log = LoggingManager.getLoggerForClass();
        String loc = appProperties.getProperty("language");
        if (loc != null) {
            JMeterUtils.setLocale(new Locale(loc, ""));
        } else {
            JMeterUtils.setLocale(Locale.getDefault());
        }
        return p;
    }

    public static Properties loadProperties(String file) {
        Properties p = new Properties();
        try {
            File f = new File(file);
            p.load(new FileInputStream(f));
        }
        catch (IOException e) {
            try {
                InputStream is = (class$org$apache$jmeter$util$JMeterUtils == null ? (class$org$apache$jmeter$util$JMeterUtils = JMeterUtils.class$("org.apache.jmeter.util.JMeterUtils")) : class$org$apache$jmeter$util$JMeterUtils).getClassLoader().getResource(file).openStream();
                if (is == null) {
                    log.warn("Cannot find " + file);
                    return null;
                }
                p.load(is);
            }
            catch (IOException ex) {
                log.warn("Error reading " + file + " " + ex.toString());
                return null;
            }
        }
        return p;
    }

    public static PatternCacheLRU getPatternCache() {
        return patternCache;
    }

    public void initializeProperties(String file) {
        System.out.println("Initializing Properties: " + file);
        JMeterUtils.getProperties(file);
        int pathend = file.lastIndexOf("/");
        String home = pathend == -1 ? "." : file.substring(0, pathend);
        home = new File(home + "/..").getAbsolutePath();
        System.out.println("Setting JMeter home: " + home);
        JMeterUtils.setJMeterHome(home);
    }

    public static String[] getSearchPaths() {
        String p = JMeterUtils.getPropDefault("search_paths", null);
        String[] result = new String[1];
        if (p != null) {
            String[] paths = JOrphanUtils.split((String)p, (String)";");
            result = new String[paths.length + 1];
            for (int i = 1; i < result.length; ++i) {
                result[i] = paths[i - 1];
            }
        }
        result[0] = JMeterUtils.getJMeterHome() + "/lib/ext";
        return result;
    }

    public static int getRandomInt(int r) {
        return rand.nextInt(r);
    }

    public static void setLocale(Locale loc) {
        log.info("Setting Locale to " + loc.toString());
        locale = loc;
        Locale def = null;
        if (loc.getLanguage() == Locale.ENGLISH.getLanguage()) {
            def = Locale.getDefault();
            if (def.getLanguage() != Locale.ENGLISH.getLanguage()) {
                Locale.setDefault(Locale.ENGLISH);
            } else {
                def = null;
            }
        }
        resources = ResourceBundle.getBundle("org.apache.jmeter.resources.messages", locale);
        JMeterUtils.notifyLocaleChangeListeners();
        if (def != null) {
            Locale.setDefault(def);
        }
    }

    public static Locale getLocale() {
        return locale;
    }

    public static void addLocaleChangeListener(LocaleChangeListener listener) {
        localeChangeListeners.add(listener);
    }

    public static void removeLocaleChangeListener(LocaleChangeListener listener) {
        localeChangeListeners.remove(listener);
    }

    private static void notifyLocaleChangeListeners() {
        LocaleChangeEvent event = new LocaleChangeEvent(class$org$apache$jmeter$util$JMeterUtils == null ? (class$org$apache$jmeter$util$JMeterUtils = JMeterUtils.class$("org.apache.jmeter.util.JMeterUtils")) : class$org$apache$jmeter$util$JMeterUtils, locale);
        Iterator iterator = ((Vector)localeChangeListeners.clone()).iterator();
        while (iterator.hasNext()) {
            LocaleChangeListener listener = (LocaleChangeListener)iterator.next();
            listener.localeChanged(event);
        }
    }

    public static String getResString(String key) {
        return JMeterUtils.getResStringDefault(key, RES_KEY_PFX + key + "]");
    }

    public static String getResString(String key, String defaultValue) {
        return JMeterUtils.getResStringDefault(key, defaultValue);
    }

    private static String getResStringDefault(String key, String defaultValue) {
        if (key == null) {
            return null;
        }
        key = key.replace(' ', '_');
        key = key.toLowerCase();
        String resString = null;
        try {
            resString = resources.getString(key);
        }
        catch (MissingResourceException mre) {
            log.warn("ERROR! Resource string not found: [" + key + "]", (Throwable)mre);
            resString = defaultValue;
        }
        return resString;
    }

    public static Properties getJMeterProperties() {
        return appProperties;
    }

    public static ImageIcon getImage(String name) {
        try {
            return new ImageIcon((class$org$apache$jmeter$util$JMeterUtils == null ? (class$org$apache$jmeter$util$JMeterUtils = JMeterUtils.class$("org.apache.jmeter.util.JMeterUtils")) : class$org$apache$jmeter$util$JMeterUtils).getClassLoader().getResource("org/apache/jmeter/images/" + name.trim()));
        }
        catch (NullPointerException e) {
            log.warn("no icon for " + name);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static String getResourceFileAsText(String name) {
        String string;
        BufferedReader fileReader;
        block12: {
            fileReader = null;
            String lineEnd = System.getProperty("line.separator");
            fileReader = new BufferedReader(new InputStreamReader((class$org$apache$jmeter$util$JMeterUtils == null ? (class$org$apache$jmeter$util$JMeterUtils = JMeterUtils.class$("org.apache.jmeter.util.JMeterUtils")) : class$org$apache$jmeter$util$JMeterUtils).getClassLoader().getResourceAsStream(name)));
            StringBuffer text = new StringBuffer();
            String line = "NOTNULL";
            while (line != null) {
                line = fileReader.readLine();
                if (line == null) continue;
                text.append(line);
                text.append(lineEnd);
            }
            string = text.toString();
            Object var7_10 = null;
            if (fileReader == null) break block12;
            try {
                fileReader.close();
            }
            catch (IOException e1) {
                // empty catch block
            }
        }
        return string;
        catch (NullPointerException e) {
            String string2;
            block13: {
                string2 = "";
                Object var7_11 = null;
                if (fileReader == null) break block13;
                try {
                    fileReader.close();
                }
                catch (IOException e1) {
                    // empty catch block
                }
            }
            return string2;
        }
        catch (IOException e) {
            String string3;
            block14: {
                string3 = "";
                Object var7_12 = null;
                if (fileReader == null) break block14;
                {
                    catch (Throwable throwable) {
                        block15: {
                            Object var7_13 = null;
                            if (fileReader == null) break block15;
                            try {
                                fileReader.close();
                            }
                            catch (IOException e1) {}
                        }
                        throw throwable;
                    }
                }
                try {
                    fileReader.close();
                }
                catch (IOException e1) {
                    // empty catch block
                }
            }
            return string3;
        }
    }

    public static Vector getTimers(Properties properties) {
        return JMeterUtils.instantiate(JMeterUtils.getVector(properties, "timer."), "org.apache.jmeter.timers.Timer");
    }

    public static Vector getVisualizers(Properties properties) {
        return JMeterUtils.instantiate(JMeterUtils.getVector(properties, "visualizer."), "org.apache.jmeter.visualizers.Visualizer");
    }

    public static Vector getControllers(Properties properties) {
        String name = "controller.";
        Vector<Object> v = new Vector<Object>();
        Enumeration<Object> names = properties.keys();
        while (names.hasMoreElements()) {
            String prop = (String)names.nextElement();
            if (!prop.startsWith(name)) continue;
            Object o = JMeterUtils.instantiate(properties.getProperty(prop), "org.apache.jmeter.control.SamplerController");
            v.addElement(o);
        }
        return v;
    }

    public static String[] getTestSamples(Properties properties, String name) {
        return JMeterUtils.getVector(properties, name + ".testsample").toArray(new String[0]);
    }

    public static XMLReader getXMLParser(Properties properties) {
        return JMeterUtils.getXMLParser();
    }

    public static XMLReader getXMLParser() {
        XMLReader reader = null;
        try {
            reader = (XMLReader)JMeterUtils.instantiate(JMeterUtils.getPropDefault("xml.parser", "org.apache.xerces.parsers.SAXParser"), "org.xml.sax.XMLReader");
        }
        catch (Exception e) {
            reader = (XMLReader)JMeterUtils.instantiate(JMeterUtils.getPropDefault("xml.parser", "org.apache.xerces.parsers.SAXParser"), "org.xml.sax.XMLReader");
        }
        return reader;
    }

    public static Hashtable getAlias(Properties properties) {
        return JMeterUtils.getHashtable(properties, "alias.");
    }

    public static Vector getVector(Properties properties, String name) {
        Vector<String> v = new Vector<String>();
        Enumeration<Object> names = properties.keys();
        while (names.hasMoreElements()) {
            String prop = (String)names.nextElement();
            if (!prop.startsWith(name)) continue;
            v.addElement(properties.getProperty(prop));
        }
        return v;
    }

    public static Hashtable getHashtable(Properties properties, String name) {
        Hashtable<String, String> t = new Hashtable<String, String>();
        Enumeration<Object> names = properties.keys();
        while (names.hasMoreElements()) {
            String prop = (String)names.nextElement();
            if (!prop.startsWith(name)) continue;
            t.put(prop.substring(name.length()), properties.getProperty(prop));
        }
        return t;
    }

    public static int getPropDefault(String propName, int defaultVal) {
        int ans;
        try {
            ans = Integer.valueOf(appProperties.getProperty(propName, Integer.toString(defaultVal)).trim());
        }
        catch (Exception e) {
            ans = defaultVal;
        }
        return ans;
    }

    public static boolean getPropDefault(String propName, boolean defaultVal) {
        boolean ans;
        try {
            String strVal = appProperties.getProperty(propName, JOrphanUtils.booleanToString((boolean)defaultVal)).trim();
            ans = strVal.equalsIgnoreCase("true") || strVal.equalsIgnoreCase("t") ? true : (strVal.equalsIgnoreCase("false") || strVal.equalsIgnoreCase("f") ? false : Integer.valueOf(strVal) == 1);
        }
        catch (Exception e) {
            ans = defaultVal;
        }
        return ans;
    }

    public static long getPropDefault(String propName, long defaultVal) {
        long ans;
        try {
            ans = Long.valueOf(appProperties.getProperty(propName, Long.toString(defaultVal)).trim());
        }
        catch (Exception e) {
            ans = defaultVal;
        }
        return ans;
    }

    public static String getPropDefault(String propName, String defaultVal) {
        String ans;
        try {
            ans = appProperties.getProperty(propName, defaultVal).trim();
        }
        catch (Exception e) {
            ans = defaultVal;
        }
        return ans;
    }

    public static String getProperty(String propName) {
        String ans = null;
        try {
            ans = appProperties.getProperty(propName);
        }
        catch (Exception e) {
            ans = null;
        }
        return ans;
    }

    public static Object setProperty(String propName, String propValue) {
        return appProperties.setProperty(propName, propValue);
    }

    public static void selJComboBoxItem(Properties properties, JComboBox combo, Vector namVec, String name) {
        int idx = namVec.indexOf(name);
        combo.setSelectedIndex(idx);
        combo.updateUI();
    }

    public static Object instantiate(String className, String impls) {
        if (className != null) {
            className = className.trim();
        }
        if (impls != null) {
            impls = impls.trim();
        }
        try {
            Class<?> c = Class.forName(impls);
            try {
                Class<?> o = Class.forName(className);
                Object res = o.newInstance();
                if (c.isInstance(res)) {
                    return res;
                }
                throw new IllegalArgumentException(className + " is not an instance of " + impls);
            }
            catch (ClassNotFoundException e) {
                log.error("Error loading class " + className + ": class is not found");
            }
            catch (IllegalAccessException e) {
                log.error("Error loading class " + className + ": does not have access");
            }
            catch (InstantiationException e) {
                log.error("Error loading class " + className + ": could not instantiate");
            }
            catch (NoClassDefFoundError e) {
                log.error("Error loading class " + className + ": couldn't find class " + e.getMessage());
            }
        }
        catch (ClassNotFoundException e) {
            log.error("Error loading class " + impls + ": was not found.");
        }
        return null;
    }

    public static Vector instantiate(Vector v, String className) {
        Vector i = new Vector();
        try {
            Class<?> c = Class.forName(className);
            Enumeration elements = v.elements();
            while (elements.hasMoreElements()) {
                String name = (String)elements.nextElement();
                try {
                    Object o = Class.forName(name).newInstance();
                    if (!c.isInstance(o)) continue;
                    i.addElement(o);
                }
                catch (ClassNotFoundException e) {
                    log.error("Error loading class " + name + ": class is not found");
                }
                catch (IllegalAccessException e) {
                    log.error("Error loading class " + name + ": does not have access");
                }
                catch (InstantiationException e) {
                    log.error("Error loading class " + name + ": could not instantiate");
                }
                catch (NoClassDefFoundError e) {
                    log.error("Error loading class " + name + ": couldn't find class " + e.getMessage());
                }
            }
        }
        catch (ClassNotFoundException e) {
            log.error("Error loading class " + className + ": class is not found");
        }
        return i;
    }

    public static Vector tokenize(String string, String separator) {
        Vector<String> v = new Vector<String>();
        StringTokenizer s = new StringTokenizer(string, separator);
        while (s.hasMoreTokens()) {
            v.addElement(s.nextToken());
        }
        return v;
    }

    public static JButton createButton(String name, ActionListener listener) {
        JButton button = new JButton(JMeterUtils.getImage(name + ".on.gif"));
        button.setDisabledIcon(JMeterUtils.getImage(name + ".off.gif"));
        button.setRolloverIcon(JMeterUtils.getImage(name + ".over.gif"));
        button.setPressedIcon(JMeterUtils.getImage(name + ".down.gif"));
        button.setActionCommand(name);
        button.addActionListener(listener);
        button.setRolloverEnabled(true);
        button.setFocusPainted(false);
        button.setBorderPainted(false);
        button.setOpaque(false);
        button.setPreferredSize(new Dimension(24, 24));
        return button;
    }

    public static JButton createSimpleButton(String name, ActionListener listener) {
        JButton button = new JButton(JMeterUtils.getImage(name + ".gif"));
        button.setActionCommand(name);
        button.addActionListener(listener);
        button.setFocusPainted(false);
        button.setBorderPainted(false);
        button.setOpaque(false);
        button.setPreferredSize(new Dimension(25, 25));
        return button;
    }

    public static String[] split(String splittee, String splitChar, String def) {
        int spot;
        if (splittee == null || splitChar == null) {
            return new String[0];
        }
        while ((spot = splittee.indexOf(splitChar + splitChar)) != -1) {
            splittee = splittee.substring(0, spot + splitChar.length()) + def + splittee.substring(spot + 1 * splitChar.length(), splittee.length());
        }
        Vector<String> returns = new Vector<String>();
        int start = 0;
        int length = splittee.length();
        spot = 0;
        while (start < length && (spot = splittee.indexOf(splitChar, start)) > -1) {
            if (spot > 0) {
                returns.addElement(splittee.substring(start, spot));
            }
            start = spot + splitChar.length();
        }
        if (start < length) {
            returns.add(splittee.substring(start));
        }
        Object[] values = new String[returns.size()];
        returns.copyInto(values);
        return values;
    }

    public static void reportErrorToUser(String errorMsg) {
        if (errorMsg == null) {
            errorMsg = "Unknown error - see log file";
            log.warn("Unknown error", new Throwable("errorMsg == null"));
        }
        try {
            JOptionPane.showMessageDialog(GuiPackage.getInstance().getMainFrame(), errorMsg, "Error", 0);
        }
        catch (RuntimeException e) {
            if (e.getClass().getName().equals("java.awt.HeadlessException")) {
                log.warn("reportErrorToUser(\"" + errorMsg + "\") caused", (Throwable)e);
            }
            throw e;
        }
    }

    public static int findInArray(String[] array, String value) {
        int count = -1;
        int index = -1;
        if (array != null && value != null) {
            while (++count < array.length) {
                if (array[count] == null || !array[count].equals(value)) continue;
                index = count;
                break;
            }
        }
        return index;
    }

    public static String unsplit(Object[] splittee, Object splitChar) {
        StringBuffer retVal = new StringBuffer("");
        int count = -1;
        while (++count < splittee.length) {
            if (splittee[count] != null) {
                retVal.append(splittee[count]);
            }
            if (count + 1 >= splittee.length || splittee[count + 1] == null) continue;
            retVal.append(splitChar);
        }
        return retVal.toString();
    }

    public static String unsplit(Object[] splittee, Object splitChar, String def) {
        StringBuffer retVal = new StringBuffer("");
        int count = -1;
        while (++count < splittee.length) {
            if (splittee[count] != null) {
                retVal.append(splittee[count]);
            } else {
                retVal.append(def);
            }
            if (count + 1 >= splittee.length) continue;
            retVal.append(splitChar);
        }
        return retVal.toString();
    }

    public static String getJMeterHome() {
        return jmDir;
    }

    public static void setJMeterHome(String home) {
        jmDir = home;
    }

    public static String getJMeterVersion() {
        return JMeterVersion.getVERSION();
    }

    public static String getJMeterCopyright() {
        return "Copyright (c) 1998-2005 The Apache Software Foundation";
    }

    public static String getExtendedFrameTitle(String fname) {
        if (fname == null) {
            return "Apache JMeter";
        }
        String temp = fname.replace('\\', '/');
        String simpleName = temp.substring(temp.lastIndexOf("/") + 1);
        return simpleName + " (" + fname + ") - Apache JMeter";
    }

    public static boolean isExpertMode() {
        return JMeterUtils.getPropDefault(EXPERT_MODE_PROPERTY, false);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        localeChangeListeners = new Vector();
        localMatcher = new ThreadLocal(){

            protected Object initialValue() {
                return new Perl5Matcher();
            }
        };
        rand = new Random();
    }
}

