/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.visualizers.Sample;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.math.StatCalculator;
import org.apache.log.Logger;

public class SamplingStatCalculator
implements Serializable {
    static Logger log = LoggingManager.getLoggerForClass();
    private static DecimalFormat rateFormatter = new DecimalFormat("#.0");
    private static DecimalFormat errorFormatter = new DecimalFormat("#0.00%");
    private static DecimalFormat kbFormatter = new DecimalFormat("#0.00");
    private final StatCalculator calculator = new StatCalculator();
    private final List storedValues = new Vector();
    private double maxThroughput;
    private long firstTime;
    private String label;

    private SamplingStatCalculator() {
    }

    public SamplingStatCalculator(String label) {
        this.label = label;
        this.init();
    }

    public SamplingStatCalculator(SamplingStatCalculator stat) {
        this(stat.label);
        this.addSamples(stat);
    }

    private void init() {
        this.firstTime = Long.MAX_VALUE;
        this.calculator.clear();
        this.storedValues.clear();
        this.maxThroughput = Double.MIN_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSamples(SamplingStatCalculator ssc) {
        this.calculator.addAll(ssc.calculator);
        List list = this.storedValues;
        synchronized (list) {
            this.storedValues.addAll(ssc.storedValues);
            Collections.sort(this.storedValues);
        }
        if (this.firstTime > ssc.firstTime) {
            this.firstTime = ssc.firstTime;
        }
    }

    public synchronized void clear() {
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sample getCurrentSample() {
        List list = this.storedValues;
        synchronized (list) {
            if (this.storedValues.size() == 0) {
                return new Sample();
            }
            return (Sample)this.storedValues.get(this.storedValues.size() - 1);
        }
    }

    public long getElapsed() {
        if (this.getCurrentSample().endTime == 0L) {
            return 0L;
        }
        return this.getCurrentSample().endTime - this.firstTime;
    }

    public double getRate() {
        if (this.calculator.getCount() == 0) {
            return 0.0;
        }
        return this.getCurrentSample().throughput;
    }

    public String getRateString() {
        double rate = this.getRate();
        if (rate == Double.MAX_VALUE) {
            return "N/A";
        }
        String unit = "sec";
        if (rate < 1.0) {
            rate *= 60.0;
            unit = "min";
        }
        if (rate < 1.0) {
            rate *= 60.0;
            unit = "hour";
        }
        String rval = rateFormatter.format(rate) + "/" + unit;
        return rval;
    }

    public double getPageSize() {
        double rate = 0.0;
        if (this.getElapsed() > 0L && this.calculator.getTotalBytes() > 0L) {
            rate = (double)this.calculator.getTotalBytes() / ((double)this.getElapsed() / 1000.0);
        }
        if (rate < 0.0) {
            rate = 0.0;
        }
        return rate;
    }

    public String getPageSizeString() {
        double rate = this.getPageSize() / 1024.0;
        return kbFormatter.format(rate);
    }

    public String getLabel() {
        return this.label;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sample addSample(SampleResult res) {
        boolean rbool;
        long cpercent;
        long cmedian;
        long cstdv;
        long cmean;
        long rtime;
        double throughput;
        long endTime;
        long eCount;
        Object object = this.calculator;
        synchronized (object) {
            long byteslength = 0L;
            byteslength = res.getResponseData() == null || res.getResponseData().length == 0 ? (long)res.getBytes() : (long)res.getResponseData().length;
            if (res.getSampleCount() > 1) {
                long time = res.getTime() / (long)res.getSampleCount();
                long resbytes = byteslength / (long)res.getSampleCount();
                for (int idx = 0; idx < res.getSampleCount(); ++idx) {
                    this.calculator.addValue(time);
                    this.calculator.addBytes(resbytes);
                }
            } else {
                this.calculator.addValue(res.getTime());
                this.calculator.addBytes(byteslength);
            }
            this.setStartTime(res);
            eCount = this.getCurrentSample().errorCount;
            if (!res.isSuccessful()) {
                ++eCount;
            }
            endTime = this.getEndTime(res);
            long howLongRunning = endTime - this.firstTime;
            throughput = (double)this.calculator.getCount() / (double)howLongRunning * 1000.0;
            if (throughput > this.maxThroughput) {
                this.maxThroughput = throughput;
            }
            rtime = res.getTime();
            cmean = (long)this.calculator.getMean();
            cstdv = (long)this.calculator.getStandardDeviation();
            cmedian = this.calculator.getMedian().longValue();
            cpercent = this.calculator.getPercentPoint(0.5).longValue();
            rbool = res.isSuccessful();
        }
        object = this.storedValues;
        synchronized (object) {
            int count = this.storedValues.size() + 1;
            Sample s = new Sample(null, rtime, cmean, cstdv, cmedian, cpercent, throughput, eCount, rbool, count, endTime);
            this.storedValues.add(s);
            return s;
        }
    }

    public List getSamples() {
        return this.storedValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sample getSample(int index) {
        List list = this.storedValues;
        synchronized (list) {
            if (index < this.storedValues.size()) {
                return (Sample)this.storedValues.get(index);
            }
            return null;
        }
    }

    private long getEndTime(SampleResult res) {
        long endTime = res.getTimeStamp();
        long lastTime = this.getCurrentSample().endTime;
        if (res.isStampedAtStart()) {
            endTime += res.getTime();
        }
        if (lastTime < endTime) {
            lastTime = endTime;
        }
        return lastTime;
    }

    private void setStartTime(SampleResult res) {
        long startTime = res.getTimeStamp();
        if (!res.isStampedAtStart()) {
            startTime -= res.getTime();
        }
        if (this.firstTime > startTime) {
            this.firstTime = startTime;
        }
    }

    public double getErrorPercentage() {
        double rval = 0.0;
        if (this.calculator.getCount() == 0) {
            return rval;
        }
        rval = (double)this.getCurrentSample().errorCount / (double)this.calculator.getCount();
        return rval;
    }

    public String getErrorPercentageString() {
        double myErrorPercentage = this.getErrorPercentage();
        if (myErrorPercentage < 0.0) {
            myErrorPercentage = 0.0;
        }
        return errorFormatter.format(myErrorPercentage);
    }

    public String toString() {
        StringBuffer mySB = new StringBuffer();
        mySB.append("Samples: " + this.getCount() + "  ");
        mySB.append("Avg: " + this.getMean() + "  ");
        mySB.append("Min: " + this.getMin() + "  ");
        mySB.append("Max: " + this.getMax() + "  ");
        mySB.append("Error Rate: " + this.getErrorPercentageString() + "  ");
        mySB.append("Sample Rate: " + this.getRateString());
        return mySB.toString();
    }

    public long getErrorCount() {
        return this.getCurrentSample().errorCount;
    }

    public double getMaxThroughput() {
        return this.maxThroughput;
    }

    public HashMap getDistribution() {
        return this.calculator.getDistribution();
    }

    public Number getPercentPoint(double percent) {
        return this.calculator.getPercentPoint(percent);
    }

    public int getCount() {
        return this.calculator.getCount();
    }

    public Number getMax() {
        return this.calculator.getMax();
    }

    public double getMean() {
        return this.calculator.getMean();
    }

    public Number getMeanAsNumber() {
        return new Long((long)this.calculator.getMean());
    }

    public Number getMedian() {
        return this.calculator.getMedian();
    }

    public Number getMin() {
        if (this.calculator.getMin().longValue() < 0L) {
            return new Long(0L);
        }
        return this.calculator.getMin();
    }

    public Number getPercentPoint(float percent) {
        return this.calculator.getPercentPoint(percent);
    }

    public double getStandardDeviation() {
        return this.calculator.getStandardDeviation();
    }
}

