/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jorphan.collections;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.util.JOrphanUtils;
import org.apache.log.Logger;

public class Data
implements Serializable {
    private static Logger log = LoggingManager.getLoggerForClass();
    Map data;
    ArrayList header = new ArrayList();
    int currentPos = -1;
    int size;

    public Data() {
        this.data = new HashMap();
        this.size = this.currentPos + 1;
    }

    public void replaceHeader(String oldHeader, String newHeader) {
        int index = this.header.indexOf(oldHeader);
        this.header.set(index, newHeader);
        List tempList = (List)this.data.remove(oldHeader);
        this.data.put(newHeader, tempList);
    }

    public void append(Data d) {
        int count;
        String[] dHeaders;
        boolean valid = true;
        String[] headers = this.getHeaders();
        if (headers.length != (dHeaders = d.getHeaders()).length) {
            valid = false;
        } else {
            for (count = 0; count < dHeaders.length; ++count) {
                if (this.header.contains(dHeaders[count])) continue;
                valid = false;
            }
        }
        if (valid) {
            this.currentPos = this.size;
            d.reset();
            while (d.next()) {
                for (count = 0; count < headers.length; ++count) {
                    this.addColumnValue(headers[count], d.getColumnValue(headers[count]));
                }
            }
        }
    }

    public int getCurrentPos() {
        return this.currentPos;
    }

    public void removeRow() {
        Iterator it = this.data.keySet().iterator();
        log.debug("removing row, size = " + this.size);
        if (this.currentPos > -1 && this.currentPos < this.size) {
            log.debug("got to here");
            while (it.hasNext()) {
                List tempList = (List)this.data.get(it.next());
                tempList.remove(this.currentPos);
            }
            if (this.currentPos > 0) {
                --this.currentPos;
            }
            --this.size;
        }
    }

    public void removeRow(int index) {
        log.debug("Removing row: " + index);
        if (index < this.size) {
            this.setCurrentPos(index);
            log.debug("Setting currentpos to " + index);
            this.removeRow();
        }
    }

    public void addRow() {
        String[] headers = this.getHeaders();
        ArrayList<String> tempList = new ArrayList<String>();
        for (int i = 0; i < headers.length; ++i) {
            tempList = (ArrayList<String>)this.data.get(this.header.get(i));
            if (tempList == null) {
                tempList = new ArrayList<String>();
                this.data.put(headers[i], tempList);
            }
            tempList.add("");
        }
        this.size = tempList.size();
        this.setCurrentPos(this.size - 1);
    }

    public void setCurrentPos(int r) {
        this.currentPos = r;
    }

    public void sort(String column, boolean asc) {
        this.sortData(column, 0, this.size);
    }

    private void swapRows(int row1, int row2) {
        Iterator it = this.data.keySet().iterator();
        while (it.hasNext()) {
            List temp = (List)this.data.get(it.next());
            Object o = temp.get(row1);
            temp.set(row1, temp.get(row2));
            temp.set(row2, o);
        }
    }

    private void sortData(String column, int start, int end) {
        int x = start;
        int y = end - 1;
        String basis = ((List)this.data.get(column)).get((x + y) / 2).toString();
        if (x == y) {
            return;
        }
        while (x <= y) {
            while (x < end && ((List)this.data.get(column)).get(x).toString().compareTo(basis) < 0) {
                ++x;
            }
            while (y >= start - 1 && ((List)this.data.get(column)).get(y).toString().compareTo(basis) > 0) {
                --y;
            }
            if (x > y) continue;
            this.swapRows(x, y);
            ++x;
            --y;
        }
        if (x == y) {
            ++x;
        }
        y = end - x;
        if (x > 0) {
            this.sortData(column, start, x);
        }
        if (y > 0) {
            this.sortData(column, x, end);
        }
    }

    public int size() {
        return this.size;
    }

    public void addColumnValue(String column, Object value) {
        ArrayList<Object> tempList = (ArrayList<Object>)this.data.get(column);
        if (tempList == null) {
            tempList = new ArrayList<Object>();
            this.data.put(column, tempList);
        }
        int s = tempList.size();
        if (this.currentPos == -1) {
            this.currentPos = this.size;
        }
        if (this.currentPos >= this.size) {
            this.size = this.currentPos + 1;
        }
        while (this.currentPos > s) {
            ++s;
            tempList.add(null);
        }
        if (this.currentPos == s) {
            tempList.add(value);
        } else {
            tempList.set(this.currentPos, value);
        }
    }

    public int findValue(String column, Object value) {
        List list = (List)this.data.get(column);
        int ret = -1;
        ret = list.indexOf(value);
        return ret;
    }

    public void setColumnValue(String column, Object value) {
        ArrayList<Object> tempList = (ArrayList<Object>)this.data.get(column);
        if (tempList == null) {
            tempList = new ArrayList<Object>();
            this.data.put(column, tempList);
        }
        if (this.currentPos == -1) {
            this.currentPos = 0;
        }
        if (this.currentPos >= this.size) {
            ++this.size;
            tempList.add(value);
        } else if (this.currentPos >= tempList.size()) {
            tempList.add(value);
        } else {
            tempList.set(this.currentPos, value);
        }
    }

    public boolean hasHeader(String column) {
        return this.data.containsKey(column);
    }

    public boolean next() {
        return ++this.currentPos < this.size;
    }

    public static Data getDataFromResultSet(ResultSet rs) throws SQLException {
        int i;
        ResultSetMetaData meta = rs.getMetaData();
        Data data = new Data();
        int numColumns = meta.getColumnCount();
        String[] dbCols = new String[numColumns];
        for (i = 0; i < numColumns; ++i) {
            dbCols[i] = meta.getColumnName(i + 1);
            data.addHeader(dbCols[i]);
        }
        while (rs.next()) {
            data.next();
            for (i = 0; i < numColumns; ++i) {
                Object o = rs.getObject(i + 1);
                if (o instanceof byte[]) {
                    o = new String((byte[])o);
                }
                data.addColumnValue(dbCols[i], o);
            }
        }
        return data;
    }

    public boolean previous() {
        return --this.currentPos >= 0;
    }

    public void reset() {
        this.currentPos = -1;
    }

    public Object getColumnValue(String column) {
        try {
            if (this.currentPos < this.size) {
                return ((List)this.data.get(column)).get(this.currentPos);
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public Object getColumnValue(int column) {
        String columnName = (String)this.header.get(column);
        try {
            if (this.currentPos < this.size) {
                return ((List)this.data.get(columnName)).get(this.currentPos);
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public Object getColumnValue(int column, int row) {
        this.setCurrentPos(row);
        return this.getColumnValue(column);
    }

    public void removeColumn(int col) {
        String columnName = (String)this.header.get(col);
        this.data.remove(columnName);
        this.header.remove(columnName);
    }

    public void setHeaders(String[] h) {
        int x = 0;
        this.header = new ArrayList(h.length);
        for (x = 0; x < h.length; ++x) {
            this.header.add(h[x]);
            this.data.put(h[x], new ArrayList());
        }
    }

    public String[] getHeaders() {
        String[] r = new String[this.header.size()];
        if (r.length > 0) {
            r = this.header.toArray(r);
        }
        return r;
    }

    public List getColumnAsObjectArray(String columnName) {
        return (List)this.data.get(columnName);
    }

    public String[] getColumn(String columnName) {
        String[] returnValue;
        List temp = (List)this.data.get(columnName);
        if (temp != null) {
            returnValue = new String[temp.size()];
            Iterator it = temp.iterator();
            int index = 0;
            while (it.hasNext()) {
                Object o = it.next();
                if (o == null) continue;
                if (o instanceof String) {
                    returnValue[index++] = (String)o;
                    continue;
                }
                returnValue[index++] = o.toString();
            }
        } else {
            returnValue = new String[]{};
        }
        return returnValue;
    }

    public void setData(String[] contents, String delimiter) {
        this.setHeaders(JOrphanUtils.split(contents[0], delimiter));
        int x = 1;
        while (x < contents.length) {
            this.setLine(JOrphanUtils.split(contents[x++], delimiter));
        }
    }

    public void setColumnData(String colName, Object value) {
        List list = this.getColumnAsObjectArray(colName);
        while (list.size() < this.size()) {
            list.add(value);
        }
    }

    public void setColumnData(int col, List data) {
        this.reset();
        Iterator iter = data.iterator();
        String columnName = (String)this.header.get(col);
        while (iter.hasNext()) {
            this.next();
            this.setColumnValue(columnName, iter.next());
        }
    }

    public void addHeader(String s) {
        this.header.add(s);
        this.data.put(s, new ArrayList(Math.max(this.size(), 100)));
    }

    public void setLine(String[] line) {
        String[] h = this.getHeaders();
        for (int count = 0; count < h.length; ++count) {
            List tempList = (List)this.data.get(h[count]);
            if (count < line.length && line[count].length() > 0) {
                tempList.add(line[count]);
                continue;
            }
            tempList.add("N/A");
        }
        ++this.size;
    }

    public void setLine(String[] line, String deflt) {
        String[] h = this.getHeaders();
        for (int count = 0; count < h.length; ++count) {
            List tempList = (List)this.data.get(h[count]);
            if (count < line.length && line[count].length() > 0) {
                tempList.add(line[count]);
                continue;
            }
            tempList.add(deflt);
        }
        ++this.size;
    }

    public String[] getDataAsText() {
        StringBuffer temp = new StringBuffer("");
        String[] line = new String[this.size + 1];
        String[] elements = this.getHeaders();
        for (int count = 0; count < elements.length; ++count) {
            temp.append(elements[count]);
            if (count + 1 >= elements.length) continue;
            temp.append("\t");
        }
        line[0] = temp.toString();
        this.reset();
        int index = 1;
        while (this.next()) {
            temp = new StringBuffer("");
            for (int count = 0; count < elements.length; ++count) {
                temp.append(this.getColumnValue(count));
                if (count + 1 >= elements.length) continue;
                temp.append("\t");
            }
            line[index++] = temp.toString();
        }
        return line;
    }

    public String toString() {
        String[] contents = this.getDataAsText();
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        for (int x = 0; x < contents.length; ++x) {
            if (!first) {
                sb.append("\n");
            } else {
                first = false;
            }
            sb.append(contents[x]);
        }
        return sb.toString();
    }
}

