/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jorphan.collections;

import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.jorphan.collections.HashTree;

public class SortedHashTree
extends HashTree
implements Serializable {
    protected Comparator comparator;

    public SortedHashTree() {
        this.data = new TreeMap();
    }

    public SortedHashTree(Comparator comper) {
        this.comparator = comper;
        this.data = new TreeMap(this.comparator);
    }

    public SortedHashTree(Object key) {
        this.data = new TreeMap();
        this.data.put(key, new SortedHashTree());
    }

    public SortedHashTree(Object key, Comparator comper) {
        this.comparator = comper;
        this.data = new TreeMap(this.comparator);
        this.data.put(key, new SortedHashTree(this.comparator));
    }

    public SortedHashTree(Collection keys) {
        this.data = new TreeMap();
        Iterator it = keys.iterator();
        while (it.hasNext()) {
            this.data.put(it.next(), new SortedHashTree());
        }
    }

    public SortedHashTree(Collection keys, Comparator comper) {
        this.comparator = comper;
        this.data = new TreeMap(this.comparator);
        Iterator it = keys.iterator();
        while (it.hasNext()) {
            this.data.put(it.next(), new SortedHashTree(this.comparator));
        }
    }

    public SortedHashTree(Object[] keys) {
        this.data = new TreeMap();
        for (int x = 0; x < keys.length; ++x) {
            this.data.put(keys[x], new SortedHashTree());
        }
    }

    public SortedHashTree(Object[] keys, Comparator comper) {
        this.comparator = comper;
        this.data = new TreeMap(this.comparator);
        for (int x = 0; x < keys.length; ++x) {
            this.data.put(keys[x], new SortedHashTree(this.comparator));
        }
    }

    protected HashTree createNewTree() {
        if (this.comparator == null) {
            return new SortedHashTree();
        }
        return new SortedHashTree(this.comparator);
    }

    protected HashTree createNewTree(Object key) {
        if (this.comparator == null) {
            return new SortedHashTree(key);
        }
        return new SortedHashTree(key, this.comparator);
    }

    protected HashTree createNewTree(Collection values) {
        if (this.comparator == null) {
            return new SortedHashTree(values);
        }
        return new SortedHashTree(values, this.comparator);
    }

    public Object clone() {
        SortedHashTree newTree = null;
        newTree = this.comparator == null ? new SortedHashTree() : new SortedHashTree(this.comparator);
        newTree.data = (Map)((HashMap)this.data).clone();
        return newTree;
    }

    public void setComparator(Comparator comparator) {
        this.comparator = comparator;
    }
}

