/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jorphan.gui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableModel;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.reflect.Functor;
import org.apache.log.Logger;

public class ObjectTableModel
extends DefaultTableModel {
    private static Logger log = LoggingManager.getLoggerForClass();
    private transient ArrayList objects = new ArrayList();
    private transient List headers = new ArrayList();
    private transient ArrayList classes = new ArrayList();
    private transient ArrayList readFunctors = new ArrayList();
    private transient ArrayList writeFunctors = new ArrayList();

    public ObjectTableModel(String[] headers, Functor[] readFunctors, Functor[] writeFunctors, Class[] editorClasses) {
        this.headers.addAll(Arrays.asList(headers));
        this.classes.addAll(Arrays.asList(editorClasses));
        this.readFunctors = new ArrayList<Functor>(Arrays.asList(readFunctors));
        this.writeFunctors = new ArrayList<Functor>(Arrays.asList(writeFunctors));
    }

    public Iterator iterator() {
        return this.objects.iterator();
    }

    public void clearData() {
        int size = this.getRowCount();
        this.objects.clear();
        super.fireTableRowsDeleted(0, size);
    }

    public void addRow(Object value) {
        log.debug("Adding row value: " + value);
        this.objects.add(value);
        super.fireTableRowsInserted(this.objects.size() - 1, this.objects.size());
    }

    public void insertRow(Object value, int index) {
        this.objects.add(index, value);
        super.fireTableRowsInserted(index, index + 1);
    }

    public int getColumnCount() {
        return this.headers.size();
    }

    public String getColumnName(int col) {
        return (String)this.headers.get(col);
    }

    public int getRowCount() {
        if (this.objects == null) {
            return 0;
        }
        return this.objects.size();
    }

    public Object getValueAt(int row, int col) {
        log.debug("Getting row value");
        Object value = this.objects.get(row);
        if (this.headers.size() == 1 && col >= this.readFunctors.size()) {
            return value;
        }
        Functor getMethod = (Functor)this.readFunctors.get(col);
        if (getMethod != null && value != null) {
            return getMethod.invoke(value);
        }
        return null;
    }

    public boolean isCellEditable(int arg0, int arg1) {
        return true;
    }

    public void moveRow(int start, int end, int to) {
        List subList = this.objects.subList(start, end);
        for (int x = end - 1; x >= start; --x) {
            this.objects.remove(x);
        }
        this.objects.addAll(to, subList);
        super.fireTableChanged(new TableModelEvent(this));
    }

    public void removeRow(int row) {
        this.objects.remove(row);
        super.fireTableRowsDeleted(row, row);
    }

    public void setValueAt(Object cellValue, int row, int col) {
        if (row < this.objects.size()) {
            Object value = this.objects.get(row);
            if (col < this.writeFunctors.size()) {
                Functor setMethod = (Functor)this.writeFunctors.get(col);
                if (setMethod != null) {
                    setMethod.invoke(value, new Object[]{cellValue});
                    super.fireTableDataChanged();
                }
            } else if (this.headers.size() == 1) {
                this.objects.set(row, cellValue);
            }
        }
    }

    public Class getColumnClass(int arg0) {
        return (Class)this.classes.get(arg0);
    }
}

