/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jorphan.math;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;

public class StatCalculator
implements Serializable {
    List values = new ArrayList();
    double sum = 0.0;
    double sumOfSquares = 0.0;
    double mean = 0.0;
    double deviation = 0.0;
    int count = 0;
    long bytes = 0L;

    public void clear() {
        this.values.clear();
        this.sum = 0.0;
        this.sumOfSquares = 0.0;
        this.mean = 0.0;
        this.deviation = 0.0;
        this.count = 0;
    }

    public void addValue(long newValue) {
        Long val = new Long(newValue);
        this.addValue(val);
    }

    public void addValue(int newValue) {
        Integer val = new Integer(newValue);
        this.addValue(val);
    }

    public void addValue(float newValue) {
        Float val = new Float(newValue);
        this.addValue(val);
    }

    public void addValue(double newValue) {
        Double val = new Double(newValue);
        this.addValue(val);
    }

    public void addBytes(long newValue) {
        this.bytes += newValue;
    }

    public void addAll(StatCalculator calc) {
        Iterator iter = this.values.iterator();
        while (iter.hasNext()) {
            this.addValue((Number)iter.next());
        }
    }

    public Number getMedian() {
        if (this.count > 0) {
            return (Number)this.values.get((int)((double)this.values.size() * 0.5));
        }
        return new Long(0L);
    }

    public long getTotalBytes() {
        return this.bytes;
    }

    public Number getPercentPoint(float percent) {
        if (this.count > 0) {
            return (Number)this.values.get((int)((float)this.values.size() * percent));
        }
        return new Long(0L);
    }

    public Number getPercentPoint(double percent) {
        if (this.count > 0) {
            return (Number)this.values.get((int)((double)this.values.size() * percent));
        }
        return new Long(0L);
    }

    public synchronized HashMap getDistribution() {
        HashMap<Long, Number[]> items = new HashMap<Long, Number[]>();
        Iterator itr = this.values.iterator();
        Long n = new Long(0L);
        Number[] dis = new Number[]{};
        while (itr.hasNext()) {
            Long nx = (Long)itr.next();
            if (items.containsKey(nx)) {
                dis = (Number[])items.get(nx);
                dis[1] = new Integer(dis[1].intValue() + 1);
                items.put(nx, dis);
                continue;
            }
            n = nx;
            dis = new Number[]{n, new Integer(1)};
            items.put(n, dis);
        }
        return items;
    }

    public double getMean() {
        return this.mean;
    }

    public double getStandardDeviation() {
        return this.deviation;
    }

    public Number getMin() {
        if (this.count > 0) {
            return (Number)this.values.get(0);
        }
        return new Long(Long.MIN_VALUE);
    }

    public Number getMax() {
        if (this.count > 0) {
            return (Number)this.values.get(this.count - 1);
        }
        return new Long(Long.MAX_VALUE);
    }

    public int getCount() {
        return this.count;
    }

    public void addValue(Number val) {
        this.addSortedValue(val);
        ++this.count;
        double currentVal = val.doubleValue();
        this.sum += currentVal;
        this.sumOfSquares += currentVal * currentVal;
        this.mean = this.sum / (double)this.count;
        this.deviation = Math.sqrt(this.sumOfSquares / (double)this.count - this.mean * this.mean);
    }

    private void addSortedValue(Number val) {
        int index = Collections.binarySearch(this.values, val);
        if (index >= 0 && index < this.values.size()) {
            this.values.add(index, val);
        } else if (index == this.values.size() || this.values.size() == 0) {
            this.values.add(val);
        } else {
            this.values.add(index * -1 - 1, val);
        }
    }

    public static class Test
    extends TestCase {
        StatCalculator calc;

        public Test(String name) {
            super(name);
        }

        public void setUp() {
            this.calc = new StatCalculator();
        }

        public void testCalculation() {
            this.calc.addValue(18);
            this.calc.addValue(10);
            this.calc.addValue(9);
            this.calc.addValue(11);
            this.calc.addValue(28);
            this.calc.addValue(3);
            this.calc.addValue(30);
            this.calc.addValue(15);
            this.calc.addValue(15);
            this.calc.addValue(21);
            Test.assertEquals((int)16, (int)((int)this.calc.getMean()));
            Test.assertEquals((float)8.062258f, (float)((float)this.calc.getStandardDeviation()), (float)0.0f);
            Test.assertEquals((int)30, (int)this.calc.getMax().intValue());
            Test.assertEquals((int)3, (int)this.calc.getMin().intValue());
            Test.assertEquals((int)15, (int)this.calc.getMedian().intValue());
        }
    }
}

