/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jorphan.reflect;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public final class ClassFinder {
    private static transient Logger log = LoggingManager.getLoggerForClass();

    private ClassFinder() {
    }

    public static List findClassesThatExtend(String[] paths, Class[] superClasses) throws IOException, ClassNotFoundException {
        return ClassFinder.findClassesThatExtend(paths, superClasses, false);
    }

    private static String[] addJarsInPath(String[] paths) {
        HashSet<String> fullList = new HashSet<String>();
        for (int i = 0; i < paths.length; ++i) {
            File dir;
            fullList.add(paths[i]);
            if (paths[i].endsWith(".jar") || !(dir = new File(paths[i])).exists() || !dir.isDirectory()) continue;
            String[] jars = dir.list(new FilenameFilter(){

                public boolean accept(File f, String name) {
                    return name.endsWith(".jar");
                }
            });
            for (int x = 0; x < jars.length; ++x) {
                fullList.add(jars[x]);
            }
        }
        return fullList.toArray(new String[0]);
    }

    public static List findClassesThatExtend(String[] strPathsOrJars, Class[] superClasses, boolean innerClasses) throws IOException, ClassNotFoundException {
        List listPaths = null;
        TreeSet listClasses = null;
        ArrayList<String> listSuperClasses = null;
        strPathsOrJars = ClassFinder.addJarsInPath(strPathsOrJars);
        if (log.isDebugEnabled()) {
            for (int k = 0; k < strPathsOrJars.length; ++k) {
                log.debug("strPathsOrJars : " + strPathsOrJars[k]);
            }
        }
        listPaths = ClassFinder.getClasspathMatches(strPathsOrJars);
        if (log.isDebugEnabled()) {
            Iterator tIter = listPaths.iterator();
            while (tIter.hasNext()) {
                log.debug("listPaths : " + tIter.next());
            }
        }
        listClasses = new TreeSet();
        listSuperClasses = new ArrayList<String>();
        for (int i = 0; i < superClasses.length; ++i) {
            listSuperClasses.add(superClasses[i].getName());
        }
        ClassFinder.findClassesInPaths(listPaths, listClasses);
        if (log.isDebugEnabled()) {
            Iterator tIter = listClasses.iterator();
            while (tIter.hasNext()) {
                log.debug("listClasses : " + tIter.next());
            }
        }
        Set subClassList = ClassFinder.findAllSubclasses(listSuperClasses, listClasses, innerClasses);
        return new ArrayList(subClassList);
    }

    private static List getClasspathMatches(String[] strPathsOrJars) {
        int i;
        ArrayList<String> listPaths = null;
        StringTokenizer stPaths = null;
        String strPath = null;
        listPaths = new ArrayList<String>();
        log.debug("Classpath = " + System.getProperty("java.class.path"));
        stPaths = new StringTokenizer(System.getProperty("java.class.path"), System.getProperty("path.separator"));
        if (strPathsOrJars != null) {
            strPathsOrJars = ClassFinder.fixDotDirs(strPathsOrJars);
            strPathsOrJars = ClassFinder.fixSlashes(strPathsOrJars);
            strPathsOrJars = ClassFinder.fixEndingSlashes(strPathsOrJars);
        }
        if (log.isDebugEnabled()) {
            for (i = 0; i < strPathsOrJars.length; ++i) {
                log.debug("strPathsOrJars[" + i + "] : " + strPathsOrJars[i]);
            }
        }
        while (stPaths.hasMoreTokens()) {
            strPath = ClassFinder.fixDotDir(stPaths.nextToken());
            strPath = ClassFinder.fixSlashes(strPath);
            strPath = ClassFinder.fixEndingSlashes(strPath);
            if (strPathsOrJars == null) {
                log.debug("Adding: " + strPath);
                listPaths.add(strPath);
                continue;
            }
            boolean found = false;
            for (i = 0; i < strPathsOrJars.length; ++i) {
                if (!strPath.endsWith(strPathsOrJars[i])) continue;
                found = true;
                log.debug("Adding " + strPath + " found at " + i);
                listPaths.add(strPath);
                break;
            }
            if (found) continue;
            log.debug("Did not find: " + strPath);
        }
        return listPaths;
    }

    private static String[] fixDotDirs(String[] paths) {
        for (int i = 0; i < paths.length; ++i) {
            paths[i] = ClassFinder.fixDotDir(paths[i]);
        }
        return paths;
    }

    private static String fixDotDir(String path) {
        if (path == null) {
            return null;
        }
        if (path.equals(".")) {
            return System.getProperty("user.dir");
        }
        return path.trim();
    }

    private static String[] fixEndingSlashes(String[] strings) {
        String[] strNew = new String[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            strNew[i] = ClassFinder.fixEndingSlashes(strings[i]);
        }
        return strNew;
    }

    private static String fixEndingSlashes(String string) {
        if (string.endsWith("/") || string.endsWith("\\")) {
            string = string.substring(0, string.length() - 1);
            string = ClassFinder.fixEndingSlashes(string);
        }
        return string;
    }

    private static String[] fixSlashes(String[] strings) {
        String[] strNew = new String[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            strNew[i] = ClassFinder.fixSlashes(strings[i]);
        }
        return strNew;
    }

    private static String fixSlashes(String str) {
        str = str.replace('\\', '/');
        str = ClassFinder.replaceString(str, "//", "_____");
        str = ClassFinder.replaceString(str, "_____", "/");
        return str;
    }

    private static String replaceString(String s, String strToFind, String strToReplace) {
        int index;
        StringBuffer buffer = null;
        if (s.indexOf(strToFind) == -1) {
            return s;
        }
        int currentPos = 0;
        buffer = new StringBuffer();
        while ((index = s.indexOf(strToFind, currentPos)) != -1) {
            buffer.append(s.substring(currentPos, index));
            buffer.append(strToReplace);
            currentPos = index + strToFind.length();
        }
        buffer.append(s.substring(currentPos));
        return buffer.toString();
    }

    private static Set findAllSubclasses(List listSuperClasses, Set listAllClasses, boolean innerClasses) {
        Iterator iterClasses = null;
        TreeSet listSubClasses = null;
        String strClassName = null;
        Class<?> tempClass = null;
        listSubClasses = new TreeSet();
        iterClasses = listSuperClasses.iterator();
        while (iterClasses.hasNext()) {
            strClassName = (String)iterClasses.next();
            if (strClassName.indexOf("$") != -1 && !innerClasses) continue;
            try {
                tempClass = Class.forName(strClassName, false, Thread.currentThread().getContextClassLoader());
                ClassFinder.findAllSubclassesOneClass(tempClass, listAllClasses, listSubClasses, innerClasses);
            }
            catch (Throwable ignored) {}
        }
        return listSubClasses;
    }

    private static void findAllSubclassesOneClass(Class theClass, Set listAllClasses, Set listSubClasses, boolean innerClasses) {
        Iterator iterClasses = null;
        String strClassName = null;
        Class<?> c = null;
        boolean bIsSubclass = false;
        iterClasses = listAllClasses.iterator();
        while (iterClasses.hasNext()) {
            strClassName = (String)iterClasses.next();
            if (strClassName.indexOf("$") != -1 && !innerClasses) continue;
            try {
                c = Class.forName(strClassName, false, Thread.currentThread().getContextClassLoader());
                bIsSubclass = !c.isInterface() && !Modifier.isAbstract(c.getModifiers()) ? theClass.isAssignableFrom(c) : false;
                if (!bIsSubclass) continue;
                listSubClasses.add(strClassName);
            }
            catch (Throwable ignored) {}
        }
    }

    private static String fixClassName(String strClassName) {
        strClassName = strClassName.replace('\\', '.');
        strClassName = strClassName.replace('/', '.');
        strClassName = strClassName.substring(0, strClassName.length() - 6);
        return strClassName;
    }

    private static void findClassesInOnePath(String strPath, Set listClasses) throws IOException {
        File file = null;
        ZipFile zipFile = null;
        Enumeration<? extends ZipEntry> entries = null;
        String strEntry = null;
        file = new File(strPath);
        if (file.isDirectory()) {
            ClassFinder.findClassesInPathsDir(strPath, file, listClasses);
        } else if (file.exists()) {
            zipFile = new ZipFile(file);
            entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                strEntry = ((Object)entries.nextElement()).toString();
                if (!strEntry.endsWith(".class")) continue;
                listClasses.add(ClassFinder.fixClassName(strEntry));
            }
        }
    }

    private static void findClassesInPaths(List listPaths, Set listClasses) throws IOException {
        Iterator iterPaths = listPaths.iterator();
        while (iterPaths.hasNext()) {
            ClassFinder.findClassesInOnePath((String)iterPaths.next(), listClasses);
        }
    }

    private static void findClassesInPathsDir(String strPathElement, File dir, Set listClasses) throws IOException {
        File file = null;
        String[] list = dir.list();
        for (int i = 0; i < list.length; ++i) {
            file = new File(dir, list[i]);
            if (file.isDirectory()) {
                ClassFinder.findClassesInPathsDir(strPathElement, file, listClasses);
                continue;
            }
            if (!file.exists() || file.length() == 0L || !list[i].endsWith(".class")) continue;
            listClasses.add(file.getPath().substring(strPathElement.length() + 1, file.getPath().lastIndexOf(".")).replace(File.separator.charAt(0), '.'));
        }
    }
}

