/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jorphan.timer;

import org.apache.jorphan.timer.ITimer;
import org.apache.jorphan.timer.ITimerConstants;

public abstract class AbstractTimer
implements ITimer,
ITimerConstants {
    private int m_state;
    private double m_data;

    public void start() {
        if (this.m_state != 0) {
            throw new IllegalStateException(this + ": start() must be called from READY state, " + "current state is " + STATE_NAMES[this.m_state]);
        }
        this.m_state = 1;
        this.m_data = this.getCurrentTime();
    }

    public void stop() {
        double data = this.getCurrentTime();
        if (this.m_state != 1) {
            throw new IllegalStateException(this + ": stop() must be called from STARTED state, " + "current state is " + STATE_NAMES[this.m_state]);
        }
        this.m_data = data - this.m_data;
        this.m_state = 2;
    }

    public double getDuration() {
        if (this.m_state != 2) {
            throw new IllegalStateException(this + ": getDuration() must be called from STOPPED state, " + "current state is " + STATE_NAMES[this.m_state]);
        }
        return this.m_data;
    }

    public void reset() {
        this.m_state = 0;
    }

    protected abstract double getCurrentTime();
}

