/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jorphan.util;

import java.net.URLEncoder;
import java.sql.Date;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;

public class Converter {
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$util$Calendar;
    static /* synthetic */ Class class$java$lang$Class;

    public static Object convert(Object value, Class toType) {
        if (value == null) {
            value = "";
        } else {
            if (toType.isAssignableFrom(value.getClass())) {
                return value;
            }
            if (toType.equals(Float.TYPE) || toType.equals(class$java$lang$Float == null ? (class$java$lang$Float = Converter.class$("java.lang.Float")) : class$java$lang$Float)) {
                return new Float(Converter.getFloat(value));
            }
            if (toType.equals(Double.TYPE) || toType.equals(class$java$lang$Double == null ? (class$java$lang$Double = Converter.class$("java.lang.Double")) : class$java$lang$Double)) {
                return new Double(Converter.getDouble(value));
            }
            if (toType.equals(class$java$lang$String == null ? (class$java$lang$String = Converter.class$("java.lang.String")) : class$java$lang$String)) {
                return Converter.getString(value);
            }
            if (toType.equals(Integer.TYPE) || toType.equals(class$java$lang$Integer == null ? (class$java$lang$Integer = Converter.class$("java.lang.Integer")) : class$java$lang$Integer)) {
                return new Integer(Converter.getInt(value));
            }
            if (toType.equals(Character.TYPE) || toType.equals(class$java$lang$Character == null ? (class$java$lang$Character = Converter.class$("java.lang.Character")) : class$java$lang$Character)) {
                return new Character(Converter.getChar(value));
            }
            if (toType.equals(Long.TYPE) || toType.equals(class$java$lang$Long == null ? (class$java$lang$Long = Converter.class$("java.lang.Long")) : class$java$lang$Long)) {
                return new Long(Converter.getLong(value));
            }
            if (toType.equals(Boolean.TYPE) || toType.equals(class$java$lang$Boolean == null ? (class$java$lang$Boolean = Converter.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
                return new Boolean(Converter.getBoolean(value));
            }
            if (toType.equals(class$java$util$Date == null ? (class$java$util$Date = Converter.class$("java.util.Date")) : class$java$util$Date)) {
                return Converter.getDate(value);
            }
            if (toType.equals(class$java$util$Calendar == null ? (class$java$util$Calendar = Converter.class$("java.util.Calendar")) : class$java$util$Calendar)) {
                return Converter.getCalendar(value);
            }
            if (toType.equals(class$java$lang$Class == null ? (class$java$lang$Class = Converter.class$("java.lang.Class")) : class$java$lang$Class)) {
                try {
                    return Class.forName(value.toString());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return value;
    }

    public static Calendar getCalendar(Object date, Calendar defaultValue) {
        Calendar cal = new GregorianCalendar();
        if (date != null && date instanceof java.util.Date) {
            cal.setTime((java.util.Date)date);
            return cal;
        }
        if (date != null) {
            DateFormat formatter = DateFormat.getDateInstance(3);
            java.util.Date d = null;
            try {
                d = formatter.parse(date.toString());
            }
            catch (ParseException e) {
                formatter = DateFormat.getDateInstance(2);
                try {
                    d = formatter.parse((String)date);
                }
                catch (ParseException e1) {
                    formatter = DateFormat.getDateInstance(1);
                    try {
                        d = formatter.parse((String)date);
                    }
                    catch (ParseException e2) {
                        formatter = DateFormat.getDateInstance(0);
                        try {
                            d = formatter.parse((String)date);
                        }
                        catch (ParseException e3) {
                            return defaultValue;
                        }
                    }
                }
            }
            cal.setTime(d);
        } else {
            cal = defaultValue;
        }
        return cal;
    }

    public static Calendar getCalendar(Object o) {
        return Converter.getCalendar(o, new GregorianCalendar());
    }

    public static java.util.Date getDate(Object date) {
        return Converter.getDate(date, Calendar.getInstance().getTime());
    }

    public static String urlEncode(Object toEncode) {
        return URLEncoder.encode(Converter.getString(toEncode));
    }

    public static java.util.Date getDate(Object date, java.util.Date defaultValue) {
        java.util.Date val = null;
        if (date != null && date instanceof java.util.Date) {
            return (java.util.Date)date;
        }
        if (date != null) {
            DateFormat formatter = DateFormat.getDateInstance(3);
            try {
                val = formatter.parse(date.toString());
            }
            catch (ParseException e) {
                formatter = DateFormat.getDateInstance(2);
                try {
                    val = formatter.parse((String)date);
                }
                catch (ParseException e1) {
                    formatter = DateFormat.getDateInstance(1);
                    try {
                        val = formatter.parse((String)date);
                    }
                    catch (ParseException e2) {
                        formatter = DateFormat.getDateInstance(0);
                        try {
                            val = formatter.parse((String)date);
                        }
                        catch (ParseException e3) {
                            return defaultValue;
                        }
                    }
                }
            }
        } else {
            return defaultValue;
        }
        return val;
    }

    public String formatNumber(float num, String pattern) {
        DecimalFormat format = new DecimalFormat(pattern);
        return format.format(num);
    }

    public static float getFloat(Object o, float defaultValue) {
        try {
            if (o == null) {
                return defaultValue;
            }
            if (o instanceof Number) {
                return ((Number)o).floatValue();
            }
            return Float.parseFloat(o.toString());
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static float getFloat(Object o) {
        return Converter.getFloat(o, 0.0f);
    }

    public static double getDouble(Object o, double defaultValue) {
        try {
            if (o == null) {
                return defaultValue;
            }
            if (o instanceof Number) {
                return ((Number)o).doubleValue();
            }
            return Double.parseDouble(o.toString());
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static double getDouble(Object o) {
        return Converter.getDouble(o, 0.0);
    }

    public static boolean getBoolean(Object o) {
        return Converter.getBoolean(o, false);
    }

    public static boolean getBoolean(Object o, boolean defaultValue) {
        if (o == null) {
            return defaultValue;
        }
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        return new Boolean(o.toString());
    }

    public static int getInt(Object o, int defaultValue) {
        try {
            if (o == null) {
                return defaultValue;
            }
            if (o instanceof Number) {
                return ((Number)o).intValue();
            }
            return Integer.parseInt(o.toString());
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static char getChar(Object o) {
        return Converter.getChar(o, ' ');
    }

    public static char getChar(Object o, char defaultValue) {
        try {
            if (o == null) {
                return defaultValue;
            }
            if (o instanceof Character) {
                return ((Character)o).charValue();
            }
            if (o instanceof Byte) {
                return (char)((Byte)o).byteValue();
            }
            if (o instanceof Integer) {
                return (char)((Integer)o).intValue();
            }
            String s = o.toString();
            if (s.length() > 0) {
                return o.toString().charAt(0);
            }
            return defaultValue;
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static int getInt(Object o) {
        return Converter.getInt(o, 0);
    }

    public static long getLong(Object o, long defaultValue) {
        try {
            if (o == null) {
                return defaultValue;
            }
            if (o instanceof Number) {
                return ((Number)o).longValue();
            }
            return Long.parseLong(o.toString());
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static long getLong(Object o) {
        return Converter.getLong(o, 0L);
    }

    public static String formatDate(java.util.Date date, String pattern) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        return format.format(date);
    }

    public static String formatDate(Date date, String pattern) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        return format.format(date);
    }

    public static String formatDate(String date, String pattern) {
        return Converter.formatDate(Converter.getCalendar(date, null), pattern);
    }

    public static String formatDate(Calendar date, String pattern) {
        return Converter.formatCalendar(date, pattern);
    }

    public static String formatCalendar(Calendar date, String pattern) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        return format.format(date.getTime());
    }

    public static String getString(Object o, String defaultValue) {
        if (o == null) {
            return defaultValue;
        }
        return o.toString();
    }

    public static String insertLineBreaks(String v, String insertion) {
        if (v == null) {
            return "";
        }
        StringBuffer replacement = new StringBuffer();
        StringTokenizer tokens = new StringTokenizer(v, "\n", true);
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            if (token.compareTo("\n") == 0) {
                replacement.append(insertion);
                continue;
            }
            replacement.append(token);
        }
        return replacement.toString();
    }

    public static String getString(Object o) {
        return Converter.getString(o, "");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

