/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application;

import com.sun.faces.application.ApplicationAssociate;
import com.sun.faces.application.ConfigNavigationCase;
import com.sun.faces.config.ConfigureListener;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.application.ApplicationFactory;
import javax.faces.application.NavigationHandler;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NavigationHandlerImpl
extends NavigationHandler {
    private static final Log log = LogFactory.getLog((Class)(class$com$sun$faces$application$NavigationHandlerImpl == null ? (class$com$sun$faces$application$NavigationHandlerImpl = NavigationHandlerImpl.class$("com.sun.faces.application.NavigationHandlerImpl")) : class$com$sun$faces$application$NavigationHandlerImpl));
    private ApplicationAssociate associate = null;
    static /* synthetic */ Class class$com$sun$faces$application$NavigationHandlerImpl;

    public NavigationHandlerImpl() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Created NavigationHandler instance ");
        }
        ApplicationFactory aFactory = (ApplicationFactory)FactoryFinder.getFactory((String)"javax.faces.application.ApplicationFactory");
        aFactory.getApplication();
        this.associate = ApplicationAssociate.getInstance(ConfigureListener.getServletContextDuringInitialize());
    }

    public void handleNavigation(FacesContext context, String fromAction, String outcome) {
        if (context == null) {
            String message = Util.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR");
            message = message + " context " + context;
            throw new NullPointerException(message);
        }
        if (outcome == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("No navigation rule found for outcome " + outcome + "and viewId " + context.getViewRoot().getViewId() + " Explicitly remain on the current view "));
            }
            return;
        }
        CaseStruct caseStruct = this.getViewId(context, fromAction, outcome);
        ExternalContext extContext = context.getExternalContext();
        if (caseStruct != null) {
            ViewHandler viewHandler = Util.getViewHandler(context);
            Util.doAssert(null != viewHandler);
            if (caseStruct.navCase.hasRedirect()) {
                String newPath = viewHandler.getActionURL(context, caseStruct.viewId);
                try {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Redirecting to path " + newPath + " for outcome " + outcome + "and viewId " + caseStruct.viewId));
                    }
                    extContext.redirect(newPath);
                }
                catch (IOException ioe) {
                    String message = "Redirect to " + newPath + " failed.";
                    if (log.isErrorEnabled()) {
                        log.error((Object)message);
                    }
                    throw new FacesException(message, (Throwable)ioe);
                }
                context.responseComplete();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Response complete for " + caseStruct.viewId));
                }
            } else {
                UIViewRoot newRoot = viewHandler.createView(context, caseStruct.viewId);
                context.setViewRoot(newRoot);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Set new view in FacesContext for " + caseStruct.viewId));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CaseStruct getViewId(FacesContext context, String fromAction, String outcome) {
        Object nextViewId = null;
        String viewId = context.getViewRoot().getViewId();
        CaseStruct caseStruct = null;
        NavigationHandlerImpl navigationHandlerImpl = this;
        synchronized (navigationHandlerImpl) {
            caseStruct = this.findExactMatch(viewId, fromAction, outcome);
            if (caseStruct == null) {
                caseStruct = this.findWildCardMatch(viewId, fromAction, outcome);
            }
            if (caseStruct == null) {
                caseStruct = this.findDefaultMatch(fromAction, outcome);
            }
        }
        return caseStruct;
    }

    private synchronized CaseStruct findExactMatch(String viewId, String fromAction, String outcome) {
        Object returnViewId = null;
        if (null == this.associate) {
            return null;
        }
        Map caseListMap = this.associate.getNavigationCaseListMappings();
        Util.doAssert(null != caseListMap);
        List caseList = (List)caseListMap.get(viewId);
        if (caseList == null) {
            return null;
        }
        return this.determineViewFromActionOutcome(caseList, fromAction, outcome);
    }

    private synchronized CaseStruct findWildCardMatch(String viewId, String fromAction, String outcome) {
        CaseStruct result = null;
        if (null == this.associate) {
            return null;
        }
        Map caseListMap = this.associate.getNavigationCaseListMappings();
        Util.doAssert(null != caseListMap);
        TreeSet wildcardMatchList = this.associate.getNavigationWildCardList();
        Util.doAssert(null != wildcardMatchList);
        Iterator iter = wildcardMatchList.iterator();
        while (iter.hasNext()) {
            String fromViewId = (String)iter.next();
            if (viewId.indexOf(fromViewId, 0) == -1) continue;
            String wcFromViewId = fromViewId + "*";
            List caseList = (List)caseListMap.get(wcFromViewId);
            if (caseList == null) {
                return null;
            }
            result = this.determineViewFromActionOutcome(caseList, fromAction, outcome);
            if (result != null) break;
        }
        return result;
    }

    private synchronized CaseStruct findDefaultMatch(String fromAction, String outcome) {
        Object returnViewId = null;
        if (null == this.associate) {
            return null;
        }
        Map caseListMap = this.associate.getNavigationCaseListMappings();
        Util.doAssert(null != caseListMap);
        List caseList = (List)caseListMap.get("*");
        if (caseList == null) {
            return null;
        }
        return this.determineViewFromActionOutcome(caseList, fromAction, outcome);
    }

    private synchronized CaseStruct determineViewFromActionOutcome(List caseList, String fromAction, String outcome) {
        String cncFromAction = null;
        String fromOutcome = null;
        String toViewId = null;
        CaseStruct result = new CaseStruct();
        int i = 0;
        while (i < caseList.size()) {
            ConfigNavigationCase cnc = (ConfigNavigationCase)caseList.get(i);
            cncFromAction = cnc.getFromAction();
            fromOutcome = cnc.getFromOutcome();
            toViewId = cnc.getToViewId();
            if (cncFromAction != null && fromOutcome != null && cncFromAction.equals(fromAction) && fromOutcome.equals(outcome)) {
                result.viewId = toViewId;
                result.navCase = cnc;
                return result;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < caseList.size()) {
            ConfigNavigationCase cnc = (ConfigNavigationCase)caseList.get(i2);
            cncFromAction = cnc.getFromAction();
            fromOutcome = cnc.getFromOutcome();
            toViewId = cnc.getToViewId();
            if (cncFromAction == null && fromOutcome != null && fromOutcome.equals(outcome)) {
                result.viewId = toViewId;
                result.navCase = cnc;
                return result;
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < caseList.size()) {
            ConfigNavigationCase cnc = (ConfigNavigationCase)caseList.get(i3);
            cncFromAction = cnc.getFromAction();
            fromOutcome = cnc.getFromOutcome();
            toViewId = cnc.getToViewId();
            if (cncFromAction != null && fromOutcome == null && cncFromAction.equals(fromAction)) {
                result.viewId = toViewId;
                result.navCase = cnc;
                return result;
            }
            ++i3;
        }
        int i4 = 0;
        while (i4 < caseList.size()) {
            ConfigNavigationCase cnc = (ConfigNavigationCase)caseList.get(i4);
            cncFromAction = cnc.getFromAction();
            fromOutcome = cnc.getFromOutcome();
            toViewId = cnc.getToViewId();
            if (cncFromAction == null && fromOutcome == null) {
                result.viewId = toViewId;
                result.navCase = cnc;
                return result;
            }
            ++i4;
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class CaseStruct {
        String viewId;
        ConfigNavigationCase navCase;

        CaseStruct() {
        }
    }
}

