/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config;

import com.sun.faces.config.ServletBean;
import com.sun.faces.config.ServletMappingBean;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.faces.FacesException;
import javax.servlet.ServletContext;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.Rule;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class WebXmlParser {
    private static final Log log = LogFactory.getLog((Class)(class$com$sun$faces$config$WebXmlParser == null ? (class$com$sun$faces$config$WebXmlParser = WebXmlParser.class$("com.sun.faces.config.WebXmlParser")) : class$com$sun$faces$config$WebXmlParser));
    Digester digester;
    ServletContext context;
    String servletName;
    List servletMappings;
    static /* synthetic */ Class class$com$sun$faces$config$WebXmlParser;
    static /* synthetic */ Class class$com$sun$faces$config$ServletBean;
    static /* synthetic */ Class class$com$sun$faces$config$ServletMappingBean;

    public WebXmlParser(ServletContext context) {
        this.context = context;
        this.servletMappings = new ArrayList();
    }

    public List getFacesServletMappings() {
        this.digester = new Digester();
        this.digester.setUseContextClassLoader(true);
        this.digester.setEntityResolver(new EntityResolver(){

            public InputSource resolveEntity(String string, String string1) throws SAXException, IOException {
                return new InputSource(new CharArrayReader(new char[0]));
            }
        });
        this.configureRules();
        URL url = null;
        try {
            url = this.context.getResource("/WEB-INF/web.xml");
        }
        catch (MalformedURLException mue) {
            // empty catch block
        }
        if (url == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Missing web.xml file. Cannot parse.");
            }
            return this.servletMappings;
        }
        InputSource in = new InputSource(WebXmlParser.escapeSpaces(url.toExternalForm()));
        InputStream inStream = null;
        try {
            URLConnection conn = url.openConnection();
            conn.setUseCaches(false);
            inStream = conn.getInputStream();
            in.setByteStream(inStream);
            this.digester.parse(in);
        }
        catch (Exception e) {
            String message = "Unexpected error parsing /WEB-INF/web.xml: " + e;
            if (log.isErrorEnabled()) {
                log.error((Object)message, (Throwable)e);
            }
            throw new FacesException(message, (Throwable)e);
        }
        finally {
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (IOException ioe) {}
            }
            this.digester = null;
        }
        return this.servletMappings;
    }

    private void configureRules() {
        this.digester.addObjectCreate("web-app/servlet", class$com$sun$faces$config$ServletBean == null ? (class$com$sun$faces$config$ServletBean = WebXmlParser.class$("com.sun.faces.config.ServletBean")) : class$com$sun$faces$config$ServletBean);
        this.digester.addCallMethod("web-app/servlet/servlet-name", "setServletName", 0);
        this.digester.addCallMethod("web-app/servlet/servlet-class", "setServletClass", 0);
        this.digester.addRule("web-app/servlet", (Rule)new ServletRule());
        this.digester.addObjectCreate("web-app/servlet-mapping", class$com$sun$faces$config$ServletMappingBean == null ? (class$com$sun$faces$config$ServletMappingBean = WebXmlParser.class$("com.sun.faces.config.ServletMappingBean")) : class$com$sun$faces$config$ServletMappingBean);
        this.digester.addCallMethod("web-app/servlet-mapping/servlet-name", "setServletName", 0);
        this.digester.addCallMethod("web-app/servlet-mapping/url-pattern", "setUrlPattern", 0);
        this.digester.addRule("web-app/servlet-mapping", (Rule)new ServletMappingRule());
    }

    public static String escapeSpaces(String src) {
        if (src.indexOf(" ") == -1) {
            return src;
        }
        StringBuffer result = new StringBuffer(src.length());
        StringTokenizer toker = new StringTokenizer(src, " ", true);
        while (toker.hasMoreTokens()) {
            String curToken = toker.nextToken();
            if (curToken.equals(" ")) {
                result.append("%20");
                continue;
            }
            result.append(curToken);
        }
        return result.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ServletMappingRule
    extends Rule {
        private ServletMappingRule() {
        }

        public void end(String namespace, String name) throws Exception {
            ServletMappingBean mappingBean = (ServletMappingBean)this.digester.peek();
            if (WebXmlParser.this.servletName != null && WebXmlParser.this.servletName.equals(mappingBean.getServletName())) {
                String urlPattern = mappingBean.getUrlPattern();
                if (urlPattern.charAt(0) == '*') {
                    urlPattern = urlPattern.substring(1);
                } else if (urlPattern.endsWith("/*")) {
                    urlPattern = urlPattern.substring(0, urlPattern.length() - 2);
                }
                WebXmlParser.this.servletMappings.add(urlPattern);
            }
        }
    }

    private class ServletRule
    extends Rule {
        private ServletRule() {
        }

        public void end(String namespace, String name) throws Exception {
            ServletBean servletBean = (ServletBean)this.digester.peek();
            String servletClass = servletBean.getServletClass();
            if (servletClass != null && servletClass.equals("javax.faces.webapp.FacesServlet")) {
                if (WebXmlParser.this.servletName == null) {
                    WebXmlParser.this.servletName = servletBean.getServletName();
                } else {
                    throw new FacesException("More than one FacesServlet was defined in this application.");
                }
            }
        }
    }
}

