/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest;

import com.sun.javatest.Status;
import com.sun.tdk.signaturetest.ArchiveFinder;
import com.sun.tdk.signaturetest.ClassDescrLoader;
import com.sun.tdk.signaturetest.ClassDescription;
import com.sun.tdk.signaturetest.DescriptionFormat;
import com.sun.tdk.signaturetest.ErrorFormatter;
import com.sun.tdk.signaturetest.FullItemDescription;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class SigTest {
    protected static final int ALL_PUBLIC = 2;
    protected int trackMode;
    protected PackageGroup packages = new PackageGroup(true);
    protected PackageGroup purePackages = new PackageGroup(false);
    protected PackageGroup excludedPackages = new PackageGroup(true);
    protected String classpath;
    protected Properties details = new Properties();
    protected ErrorFormatter errorManager;
    protected ClassDescrLoader loader;
    protected boolean isReflectUsed = false;
    protected DescriptionFormat converter;
    protected ArchiveFinder classIterator;
    protected String apiVersion;
    protected boolean isStatic;
    protected int cacheSize = 100;
    static /* synthetic */ Class class$com$sun$tdk$signaturetest$ArchiveFinder;

    protected Status parseParameters(Vector vector) {
        boolean bl = false;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (string.equals("-Package")) {
                if (!enumeration.hasMoreElements()) {
                    return Status.failed("Missing value for option -Package");
                }
                this.packages.addPackageName((String)enumeration.nextElement());
                bl = true;
                continue;
            }
            if (string.equals("-PackageWithoutSubpackages")) {
                if (!enumeration.hasMoreElements()) {
                    return Status.failed("Missing value for option -PackageWithoutSubpackages");
                }
                this.purePackages.addPackageName((String)enumeration.nextElement());
                bl = true;
                continue;
            }
            if (string.equals("-Exclude")) {
                if (!enumeration.hasMoreElements()) {
                    return Status.failed("Missing value for option -Exclude");
                }
                this.excludedPackages.addPackageName((String)enumeration.nextElement());
                continue;
            }
            if (string.equals("-Classpath")) {
                if (!enumeration.hasMoreElements()) {
                    return Status.failed("Missing value for option -Classpath");
                }
                this.classpath = (String)enumeration.nextElement();
                continue;
            }
            if (string.equals("-Detail")) {
                if (!enumeration.hasMoreElements()) {
                    return Status.failed("Missing value for option -Detail");
                }
                ((Hashtable)this.details).put((String)enumeration.nextElement(), "true");
                continue;
            }
            if (string.equals("-Version")) {
                if (!enumeration.hasMoreElements()) {
                    return Status.failed("Missing value for option -Version");
                }
                this.apiVersion = (String)enumeration.nextElement();
                continue;
            }
            if (string.equals("-static")) {
                this.isStatic = true;
                continue;
            }
            if (string.equals("-ClassCacheSize")) {
                this.cacheSize = 0;
                try {
                    if (enumeration.hasMoreElements()) {
                        this.cacheSize = Integer.parseInt((String)enumeration.nextElement());
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    this.cacheSize = 0;
                }
                if (this.cacheSize > 0) continue;
                return Status.failed("Invalid value for option: " + string);
            }
            if (string.equals("-AllPublic")) {
                this.trackMode = 2;
                continue;
            }
            if (string.equals("-UseReflect")) {
                this.isReflectUsed = true;
                continue;
            }
            return Status.failed("Incorrect option: " + string);
        }
        if (this.apiVersion == null) {
            try {
                this.apiVersion = System.getProperty("java.version");
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        if (!bl) {
            this.packages.addPackageName("java");
        }
        return Status.passed("");
    }

    protected String getDefaultClassPath() {
        return "";
    }

    protected boolean isPackageMember(String string) {
        return !this.excludedPackages.checkName(string) && (this.packages.checkName(string) || this.purePackages.checkName(string));
    }

    protected boolean isAccessible(ClassDescription classDescription) {
        if (this.trackMode == 2) {
            return classDescription.isPublic() || classDescription.isProtected();
        }
        ClassDescription classDescription2 = classDescription;
        while (classDescription2 != null) {
            if (!classDescription2.isPublic() && !classDescription2.isProtected()) {
                return false;
            }
            FullItemDescription fullItemDescription = classDescription2.getEnclosingClass();
            if (fullItemDescription == null) {
                return true;
            }
            if (fullItemDescription instanceof ClassDescription) {
                classDescription2 = (ClassDescription)fullItemDescription;
                continue;
            }
            try {
                classDescription2 = this.loader.loadClass(fullItemDescription.getName());
            }
            catch (ClassNotFoundException classNotFoundException) {
                return true;
            }
            catch (LinkageError linkageError) {
                if (this.errorManager != null) {
                    this.errorManager.addError("LinkageError", classDescription.getName(), "can't track accessibility : " + linkageError + "thrown", null);
                }
                return false;
            }
        }
        return true;
    }

    protected boolean isThrowsTracked() {
        try {
            Class clazz = class$com$sun$tdk$signaturetest$ArchiveFinder == null ? (class$com$sun$tdk$signaturetest$ArchiveFinder = SigTest.class$("com.sun.tdk.signaturetest.ArchiveFinder")) : class$com$sun$tdk$signaturetest$ArchiveFinder;
            Method method = clazz.getDeclaredMethod("getCurrentClass", new Class[0]);
            Class<?>[] classArray = method.getExceptionTypes();
            return classArray != null && classArray.length != 0;
        }
        catch (Throwable throwable) {
            this.errorManager.addError("LinkageError", "", "Can not track that Method.getExceptionTypes() works correctly. " + throwable + " thrown.", "");
            return false;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class PackageGroup {
        boolean isSubpackagesUses = true;
        Vector group;

        public PackageGroup(boolean bl) {
            this.isSubpackagesUses = bl;
            this.group = new Vector();
        }

        public boolean isEmpty() {
            return this.group.isEmpty();
        }

        public String toString() {
            return this.group.toString();
        }

        public void addPackageName(String string) {
            this.group.addElement(string);
        }

        public boolean checkName(String string) {
            Enumeration enumeration = this.group.elements();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                if ((!string.startsWith(PackageGroup.getPackageName(string2)) || string.lastIndexOf(46) > string2.length() && !this.isSubpackagesUses) && !string.equals(string2)) continue;
                return true;
            }
            return false;
        }

        private static String getPackageName(String string) {
            return string + (string.endsWith(".") || string.equals("") ? "" : ".");
        }
    }
}

