/*
 * Decompiled with CFR 0.152.
 */
package de.odysseus.el;

import de.odysseus.el.ObjectValueExpression;
import de.odysseus.el.TreeMethodExpression;
import de.odysseus.el.TreeValueExpression;
import de.odysseus.el.misc.TypeConversions;
import de.odysseus.el.tree.TreeStore;
import de.odysseus.el.tree.impl.Builder;
import de.odysseus.el.tree.impl.Cache;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.EnumSet;
import java.util.Properties;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ExpressionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionFactoryImpl
extends ExpressionFactory {
    private final TreeStore store;

    public ExpressionFactoryImpl() {
        this.store = this.createTreeStore(1000, this.loadProperties("el.properties"));
    }

    public ExpressionFactoryImpl(Properties properties) {
        this.store = this.createTreeStore(1000, properties);
    }

    public ExpressionFactoryImpl(TreeStore treeStore) {
        this.store = treeStore;
    }

    private Properties loadDefaultProperties() {
        String string = System.getProperty("java.home");
        String string2 = string + File.separator + "lib" + File.separator + "el.properties";
        File file = new File(string2);
        if (file.exists()) {
            Properties properties = new Properties();
            InputStream inputStream = null;
            try {
                inputStream = new FileInputStream(file);
                properties.load(inputStream);
            }
            catch (IOException iOException) {
                throw new ELException("Cannot read default EL properties", (Throwable)iOException);
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            String string3 = properties.getProperty("javax.el.ExpressionFactory");
            if (((Object)((Object)this)).getClass().getName().equals(string3)) {
                return properties;
            }
        }
        return null;
    }

    private Properties loadProperties(String string) {
        Properties properties = new Properties(this.loadDefaultProperties());
        InputStream inputStream = null;
        try {
            inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(string);
        }
        catch (SecurityException securityException) {
            inputStream = ClassLoader.getSystemResourceAsStream(string);
        }
        if (inputStream != null) {
            try {
                properties.load(inputStream);
            }
            catch (IOException iOException) {
                throw new ELException("Cannot read EL properties", (Throwable)iOException);
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return properties;
    }

    protected TreeStore createTreeStore(int n, Properties properties) {
        EnumSet<Builder.Feature> enumSet = EnumSet.noneOf(Builder.Feature.class);
        if (properties != null) {
            if (Boolean.valueOf(properties.getProperty("javax.el.methodInvocations")).booleanValue()) {
                enumSet.add(Builder.Feature.METHOD_INVOCATIONS);
            }
            if (Boolean.valueOf(properties.getProperty("javax.el.nullProperties")).booleanValue()) {
                enumSet.add(Builder.Feature.NULL_PROPERTIES);
            }
        }
        Builder builder = new Builder(enumSet.toArray(new Builder.Feature[enumSet.size()]));
        int n2 = n;
        if (properties != null && properties.containsKey("javax.el.cacheSize")) {
            try {
                n2 = Integer.parseInt(properties.getProperty("javax.el.cacheSize"));
            }
            catch (NumberFormatException numberFormatException) {
                throw new ELException("Cannot parse EL property javax.el.cacheSize", (Throwable)numberFormatException);
            }
        }
        Cache cache = n2 > 0 ? new Cache(n2) : null;
        return new TreeStore(builder, cache);
    }

    public final Object coerceToType(Object object, Class<?> clazz) {
        return TypeConversions.coerceToType(object, clazz);
    }

    public final ObjectValueExpression createValueExpression(Object object, Class<?> clazz) {
        return new ObjectValueExpression(object, clazz);
    }

    public final TreeValueExpression createValueExpression(ELContext eLContext, String string, Class<?> clazz) {
        return new TreeValueExpression(this.store, eLContext.getFunctionMapper(), eLContext.getVariableMapper(), string, clazz);
    }

    public final TreeMethodExpression createMethodExpression(ELContext eLContext, String string, Class<?> clazz, Class<?>[] classArray) {
        return new TreeMethodExpression(this.store, eLContext.getFunctionMapper(), eLContext.getVariableMapper(), string, clazz, classArray);
    }
}

