/*
 * Decompiled with CFR 0.152.
 */
package de.odysseus.el.tree;

import de.odysseus.el.tree.Node;
import java.io.PrintWriter;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodePrinter {
    private static boolean isLastSibling(Node node, Node node2) {
        if (node2 != null) {
            return node == node2.getChild(node2.getCardinality() - 1);
        }
        return true;
    }

    private static void dump(PrintWriter printWriter, Node node, Stack<Node> stack) {
        Node node2;
        if (!stack.isEmpty()) {
            node2 = null;
            for (Node node3 : stack) {
                if (NodePrinter.isLastSibling(node3, node2)) {
                    printWriter.print("   ");
                } else {
                    printWriter.print("|  ");
                }
                node2 = node3;
            }
            printWriter.println("|");
        }
        node2 = null;
        for (Node node3 : stack) {
            if (NodePrinter.isLastSibling(node3, node2)) {
                printWriter.print("   ");
            } else {
                printWriter.print("|  ");
            }
            node2 = node3;
        }
        printWriter.print("+- ");
        printWriter.println(node.toString());
        stack.push(node);
        for (int i = 0; i < node.getCardinality(); ++i) {
            NodePrinter.dump(printWriter, node.getChild(i), stack);
        }
        stack.pop();
    }

    public static void dump(PrintWriter printWriter, Node node) {
        NodePrinter.dump(printWriter, node, new Stack<Node>());
    }
}

