/*
 * Decompiled with CFR 0.152.
 */
package de.odysseus.el.tree.impl;

import de.odysseus.el.misc.LocalMessages;
import de.odysseus.el.tree.FunctionNode;
import de.odysseus.el.tree.IdentifierNode;
import de.odysseus.el.tree.Tree;
import de.odysseus.el.tree.impl.Builder;
import de.odysseus.el.tree.impl.Scanner;
import de.odysseus.el.tree.impl.ast.AstBinary;
import de.odysseus.el.tree.impl.ast.AstBoolean;
import de.odysseus.el.tree.impl.ast.AstBracket;
import de.odysseus.el.tree.impl.ast.AstChoice;
import de.odysseus.el.tree.impl.ast.AstComposite;
import de.odysseus.el.tree.impl.ast.AstDot;
import de.odysseus.el.tree.impl.ast.AstEval;
import de.odysseus.el.tree.impl.ast.AstFunction;
import de.odysseus.el.tree.impl.ast.AstIdentifier;
import de.odysseus.el.tree.impl.ast.AstLiteral;
import de.odysseus.el.tree.impl.ast.AstMethod;
import de.odysseus.el.tree.impl.ast.AstNested;
import de.odysseus.el.tree.impl.ast.AstNode;
import de.odysseus.el.tree.impl.ast.AstNull;
import de.odysseus.el.tree.impl.ast.AstNumber;
import de.odysseus.el.tree.impl.ast.AstString;
import de.odysseus.el.tree.impl.ast.AstText;
import de.odysseus.el.tree.impl.ast.AstUnary;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Parser {
    private static final String EXPR_FIRST = (Object)((Object)Scanner.Symbol.IDENTIFIER) + "|" + (Object)((Object)Scanner.Symbol.STRING) + "|" + (Object)((Object)Scanner.Symbol.FLOAT) + "|" + (Object)((Object)Scanner.Symbol.INTEGER) + "|" + (Object)((Object)Scanner.Symbol.TRUE) + "|" + (Object)((Object)Scanner.Symbol.FALSE) + "|" + (Object)((Object)Scanner.Symbol.NULL) + "|" + (Object)((Object)Scanner.Symbol.MINUS) + "|" + (Object)((Object)Scanner.Symbol.NOT) + "|" + (Object)((Object)Scanner.Symbol.EMPTY) + "|" + (Object)((Object)Scanner.Symbol.LPAREN);
    private final Builder context;
    private final Scanner scanner;
    private List<IdentifierNode> identifiers = Collections.emptyList();
    private List<FunctionNode> functions = Collections.emptyList();
    private List<LookaheadToken> lookahead = Collections.emptyList();
    private Scanner.Symbol symbol;
    private String image;
    private int position;

    public Parser(Builder builder, String string) {
        this.context = builder;
        this.scanner = new Scanner(string);
    }

    private Number parseInteger(String string) throws ParseException {
        try {
            return this.context.parseInteger(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.fail(Scanner.Symbol.INTEGER);
            return null;
        }
    }

    private Number parseFloat(String string) throws ParseException {
        try {
            return this.context.parseFloat(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.fail(Scanner.Symbol.FLOAT);
            return null;
        }
    }

    private void fail(String string) throws ParseException {
        String string2 = this.image == null ? this.symbol.toString() : "'" + this.image + "'";
        throw new ParseException(this.position, string2, string);
    }

    private void fail(Scanner.Symbol symbol) throws ParseException {
        this.fail(symbol.toString());
    }

    private Scanner.Symbol lookahead(int n) throws Scanner.ScanException, ParseException {
        if (this.lookahead.isEmpty()) {
            this.lookahead = new LinkedList<LookaheadToken>();
        }
        while (n >= this.lookahead.size()) {
            this.lookahead.add(new LookaheadToken(this.scanner.next(), this.scanner.getImage(), this.scanner.getPosition()));
        }
        return this.lookahead.get((int)n).symbol;
    }

    private void consumeToken() throws Scanner.ScanException, ParseException {
        if (this.lookahead.isEmpty()) {
            this.symbol = this.scanner.next();
            this.image = this.scanner.getImage();
            this.position = this.scanner.getPosition();
        } else {
            LookaheadToken lookaheadToken = this.lookahead.remove(0);
            this.symbol = lookaheadToken.symbol;
            this.image = lookaheadToken.image;
            this.position = lookaheadToken.position;
        }
    }

    private void consumeToken(Scanner.Symbol symbol) throws Scanner.ScanException, ParseException {
        if (this.symbol != symbol) {
            this.fail(symbol);
        }
        this.consumeToken();
    }

    public Tree tree() throws Scanner.ScanException, ParseException {
        this.consumeToken();
        AstNode astNode = this.text();
        if (this.symbol == Scanner.Symbol.EOF) {
            if (astNode == null) {
                astNode = new AstText("");
            }
            return new Tree(astNode, this.functions, this.identifiers, false);
        }
        AstEval astEval = this.eval();
        if (this.symbol == Scanner.Symbol.EOF && astNode == null) {
            return new Tree(astEval, this.functions, this.identifiers, astEval.isDeferred());
        }
        ArrayList<AstNode> arrayList = new ArrayList<AstNode>();
        if (astNode != null) {
            arrayList.add(astNode);
        }
        arrayList.add(astEval);
        astNode = this.text();
        if (astNode != null) {
            arrayList.add(astNode);
        }
        while (this.symbol != Scanner.Symbol.EOF) {
            if (astEval.isDeferred()) {
                arrayList.add(this.eval(true, true));
            } else {
                arrayList.add(this.eval(true, false));
            }
            if ((astNode = this.text()) == null) continue;
            arrayList.add(astNode);
        }
        return new Tree(new AstComposite(arrayList), this.functions, this.identifiers, astEval.isDeferred());
    }

    private AstNode text() throws Scanner.ScanException, ParseException {
        AstText astText = null;
        if (this.symbol == Scanner.Symbol.TEXT) {
            astText = new AstText(this.image);
            this.consumeToken();
        }
        return astText;
    }

    private AstEval eval() throws Scanner.ScanException, ParseException {
        AstEval astEval = this.eval(false, false);
        if (astEval == null && (astEval = this.eval(false, true)) == null) {
            this.fail((Object)((Object)Scanner.Symbol.START_EVAL_DEFERRED) + "|" + (Object)((Object)Scanner.Symbol.START_EVAL_DYNAMIC));
        }
        return astEval;
    }

    private AstEval eval(boolean bl, boolean bl2) throws Scanner.ScanException, ParseException {
        Scanner.Symbol symbol;
        AstEval astEval = null;
        Scanner.Symbol symbol2 = symbol = bl2 ? Scanner.Symbol.START_EVAL_DEFERRED : Scanner.Symbol.START_EVAL_DYNAMIC;
        if (this.symbol == symbol) {
            this.consumeToken();
            astEval = new AstEval(this.expr(true), bl2);
            this.consumeToken(Scanner.Symbol.END_EVAL);
        } else if (bl) {
            this.fail(symbol);
        }
        return astEval;
    }

    private AstNode expr(boolean bl) throws Scanner.ScanException, ParseException {
        AstNode astNode = this.or(bl);
        if (astNode == null) {
            return null;
        }
        if (this.symbol == Scanner.Symbol.QUESTION) {
            this.consumeToken();
            AstNode astNode2 = this.expr(true);
            this.consumeToken(Scanner.Symbol.COLON);
            AstNode astNode3 = this.expr(true);
            astNode = new AstChoice(astNode, astNode2, astNode3);
        }
        return astNode;
    }

    private AstNode or(boolean bl) throws Scanner.ScanException, ParseException {
        AstNode astNode = this.and(bl);
        if (astNode == null) {
            return null;
        }
        while (this.symbol == Scanner.Symbol.OR) {
            this.consumeToken();
            astNode = new AstBinary(astNode, this.and(true), AstBinary.OR);
        }
        return astNode;
    }

    private AstNode and(boolean bl) throws Scanner.ScanException, ParseException {
        AstNode astNode = this.eq(bl);
        if (astNode == null) {
            return null;
        }
        while (this.symbol == Scanner.Symbol.AND) {
            this.consumeToken();
            astNode = new AstBinary(astNode, this.eq(true), AstBinary.AND);
        }
        return astNode;
    }

    private AstNode eq(boolean bl) throws Scanner.ScanException, ParseException {
        AstNode astNode = this.cmp(bl);
        if (astNode == null) {
            return null;
        }
        block4: while (true) {
            switch (this.symbol) {
                case EQ: {
                    this.consumeToken();
                    astNode = new AstBinary(astNode, this.cmp(true), AstBinary.EQ);
                    continue block4;
                }
                case NE: {
                    this.consumeToken();
                    astNode = new AstBinary(astNode, this.cmp(true), AstBinary.NE);
                    continue block4;
                }
            }
            break;
        }
        return astNode;
    }

    private AstNode cmp(boolean bl) throws Scanner.ScanException, ParseException {
        AstNode astNode = this.add(bl);
        if (astNode == null) {
            return null;
        }
        block6: while (true) {
            switch (this.symbol) {
                case LT: {
                    this.consumeToken();
                    astNode = new AstBinary(astNode, this.add(true), AstBinary.LT);
                    continue block6;
                }
                case LE: {
                    this.consumeToken();
                    astNode = new AstBinary(astNode, this.add(true), AstBinary.LE);
                    continue block6;
                }
                case GE: {
                    this.consumeToken();
                    astNode = new AstBinary(astNode, this.add(true), AstBinary.GE);
                    continue block6;
                }
                case GT: {
                    this.consumeToken();
                    astNode = new AstBinary(astNode, this.add(true), AstBinary.GT);
                    continue block6;
                }
            }
            break;
        }
        return astNode;
    }

    private AstNode add(boolean bl) throws Scanner.ScanException, ParseException {
        AstNode astNode = this.mul(bl);
        if (astNode == null) {
            return null;
        }
        block4: while (true) {
            switch (this.symbol) {
                case PLUS: {
                    this.consumeToken();
                    astNode = new AstBinary(astNode, this.mul(true), AstBinary.ADD);
                    continue block4;
                }
                case MINUS: {
                    this.consumeToken();
                    astNode = new AstBinary(astNode, this.mul(true), AstBinary.SUB);
                    continue block4;
                }
            }
            break;
        }
        return astNode;
    }

    private AstNode mul(boolean bl) throws Scanner.ScanException, ParseException {
        AstNode astNode = this.unary(bl);
        if (astNode == null) {
            return null;
        }
        block5: while (true) {
            switch (this.symbol) {
                case MUL: {
                    this.consumeToken();
                    astNode = new AstBinary(astNode, this.unary(true), AstBinary.MUL);
                    continue block5;
                }
                case DIV: {
                    this.consumeToken();
                    astNode = new AstBinary(astNode, this.unary(true), AstBinary.DIV);
                    continue block5;
                }
                case MOD: {
                    this.consumeToken();
                    astNode = new AstBinary(astNode, this.unary(true), AstBinary.MOD);
                    continue block5;
                }
            }
            break;
        }
        return astNode;
    }

    private AstNode unary(boolean bl) throws Scanner.ScanException, ParseException {
        AstNode astNode = null;
        switch (this.symbol) {
            case NOT: {
                this.consumeToken();
                astNode = new AstUnary(this.unary(true), AstUnary.NOT);
                break;
            }
            case MINUS: {
                this.consumeToken();
                astNode = new AstUnary(this.unary(true), AstUnary.NEG);
                break;
            }
            case EMPTY: {
                this.consumeToken();
                astNode = new AstUnary(this.unary(true), AstUnary.EMPTY);
                break;
            }
            default: {
                astNode = this.value();
            }
        }
        if (astNode == null && bl) {
            this.fail(EXPR_FIRST);
        }
        return astNode;
    }

    private AstNode value() throws Scanner.ScanException, ParseException {
        boolean bl = true;
        AstNode astNode = this.nonliteral();
        if (astNode == null) {
            astNode = this.literal();
            if (astNode == null) {
                return null;
            }
            bl = false;
        }
        block4: while (true) {
            switch (this.symbol) {
                case DOT: {
                    this.consumeToken();
                    String string = this.image;
                    this.consumeToken(Scanner.Symbol.IDENTIFIER);
                    if (this.symbol == Scanner.Symbol.LPAREN && this.context.isEnabled(Builder.Feature.METHOD_INVOCATIONS)) {
                        this.consumeToken();
                        astNode = new AstMethod(astNode, string, this.list());
                        this.consumeToken(Scanner.Symbol.RPAREN);
                        continue block4;
                    }
                    astNode = new AstDot(astNode, string, bl);
                    continue block4;
                }
                case LBRACK: {
                    this.consumeToken();
                    AstNode astNode2 = this.expr(true);
                    boolean bl2 = !this.context.isEnabled(Builder.Feature.NULL_PROPERTIES);
                    astNode = new AstBracket(astNode, astNode2, bl, bl2);
                    this.consumeToken(Scanner.Symbol.RBRACK);
                    continue block4;
                }
            }
            break;
        }
        return astNode;
    }

    private AstNode nonliteral() throws Scanner.ScanException, ParseException {
        AstNode astNode = null;
        switch (this.symbol) {
            case IDENTIFIER: {
                String string = this.image;
                this.consumeToken();
                if (this.symbol == Scanner.Symbol.COLON && this.lookahead(0) == Scanner.Symbol.IDENTIFIER && this.lookahead(1) == Scanner.Symbol.LPAREN) {
                    this.consumeToken();
                    string = string + ":" + this.image;
                    this.consumeToken();
                }
                if (this.symbol == Scanner.Symbol.LPAREN) {
                    this.consumeToken();
                    List<AstNode> list = this.list();
                    this.consumeToken(Scanner.Symbol.RPAREN);
                    if (this.functions.isEmpty()) {
                        this.functions = new ArrayList<FunctionNode>(4);
                    }
                    AstFunction astFunction = new AstFunction(string, this.functions.size(), list);
                    this.functions.add(astFunction);
                    astNode = astFunction;
                    break;
                }
                if (this.identifiers.isEmpty()) {
                    this.identifiers = new ArrayList<IdentifierNode>(4);
                }
                AstIdentifier astIdentifier = new AstIdentifier(string, this.identifiers.size());
                this.identifiers.add(astIdentifier);
                astNode = astIdentifier;
                break;
            }
            case LPAREN: {
                this.consumeToken();
                astNode = this.expr(true);
                this.consumeToken(Scanner.Symbol.RPAREN);
                astNode = new AstNested(astNode);
            }
        }
        return astNode;
    }

    private List<AstNode> list() throws Scanner.ScanException, ParseException {
        ArrayList<AstNode> arrayList = null;
        AstNode astNode = this.expr(false);
        if (astNode != null) {
            arrayList = new ArrayList<AstNode>();
            arrayList.add(astNode);
            while (this.symbol == Scanner.Symbol.COMMA) {
                this.consumeToken();
                arrayList.add(this.expr(true));
            }
        }
        return arrayList;
    }

    private AstNode literal() throws Scanner.ScanException, ParseException {
        AstLiteral astLiteral = null;
        switch (this.symbol) {
            case TRUE: {
                astLiteral = new AstBoolean(true);
                this.consumeToken();
                break;
            }
            case FALSE: {
                astLiteral = new AstBoolean(false);
                this.consumeToken();
                break;
            }
            case STRING: {
                astLiteral = new AstString(this.image);
                this.consumeToken();
                break;
            }
            case INTEGER: {
                astLiteral = new AstNumber(this.parseInteger(this.image));
                this.consumeToken();
                break;
            }
            case FLOAT: {
                astLiteral = new AstNumber(this.parseFloat(this.image));
                this.consumeToken();
                break;
            }
            case NULL: {
                astLiteral = new AstNull();
                this.consumeToken();
            }
        }
        return astLiteral;
    }

    private static final class LookaheadToken {
        final Scanner.Symbol symbol;
        final String image;
        final int position;

        LookaheadToken(Scanner.Symbol symbol, String string, int n) {
            this.symbol = symbol;
            this.image = string;
            this.position = n;
        }
    }

    static class ParseException
    extends Exception {
        ParseException(int n, String string, String string2) {
            super(LocalMessages.get("error.parse", n, string, string2));
        }
    }
}

