/*
 * Decompiled with CFR 0.152.
 */
package de.odysseus.el.tree.impl.ast;

import de.odysseus.el.misc.TypeConversions;
import de.odysseus.el.tree.Bindings;
import de.odysseus.el.tree.impl.ast.AstNode;
import de.odysseus.el.tree.impl.ast.AstRightValue;
import java.util.List;
import javax.el.ELContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AstComposite
extends AstRightValue {
    private final List<AstNode> nodes;

    public AstComposite(List<AstNode> list) {
        this.nodes = list;
    }

    @Override
    public Object eval(Bindings bindings, ELContext eLContext) {
        StringBuilder stringBuilder = new StringBuilder(16);
        for (int i = 0; i < this.getCardinality(); ++i) {
            stringBuilder.append(TypeConversions.coerceToString(this.nodes.get(i).eval(bindings, eLContext)));
        }
        return stringBuilder.toString();
    }

    public String toString() {
        return "composite";
    }

    @Override
    public void appendStructure(StringBuilder stringBuilder, Bindings bindings) {
        for (int i = 0; i < this.getCardinality(); ++i) {
            this.nodes.get(i).appendStructure(stringBuilder, bindings);
        }
    }

    @Override
    public int getCardinality() {
        return this.nodes.size();
    }

    @Override
    public AstNode getChild(int n) {
        return this.nodes.get(n);
    }
}

