/*
 * Decompiled with CFR 0.152.
 */
package org.mc4j.ems.impl.jmx.connection.bean.notification;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import org.mc4j.ems.connection.EmsBeanNotFoundException;
import org.mc4j.ems.connection.bean.EmsBean;
import org.mc4j.ems.connection.bean.notification.EmsNotification;
import org.mc4j.ems.connection.bean.notification.EmsNotificationEvent;
import org.mc4j.ems.connection.bean.notification.EmsNotificationListener;
import org.mc4j.ems.impl.jmx.connection.bean.DBeanName;
import org.mc4j.ems.impl.jmx.connection.bean.DMBean;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DNotification
implements EmsNotification {
    protected MBeanNotificationInfo info;
    protected DMBean bean;
    protected List<String> notifTypes;
    protected List<EmsNotificationEvent> events = new ArrayList<EmsNotificationEvent>();
    protected Set<EmsNotificationListener> listeners = new HashSet<EmsNotificationListener>();
    protected NotificationListenerImpl notificationListener;
    protected NotificationFilterImpl notificationFilter;

    public DNotification(MBeanNotificationInfo info, DMBean bean) {
        this.info = info;
        this.bean = bean;
        this.notifTypes = Arrays.asList(this.getTypes());
    }

    public String getName() {
        return this.info.getName();
    }

    public String getDescription() {
        return this.info.getDescription();
    }

    public String[] getTypes() {
        return this.info.getNotifTypes();
    }

    public int compareTo(Object o) {
        DNotification otherNotification = (DNotification)o;
        return this.info.getName().compareTo(otherNotification.getName());
    }

    public void addNotificationListener(EmsNotificationListener listener) {
        this.listeners.add(listener);
    }

    public boolean removeNotificationListener(EmsNotificationListener listener) {
        return this.listeners.remove(listener);
    }

    public boolean isListening() {
        return this.notificationListener != null;
    }

    public void startListening() {
        if (this.isListening()) {
            return;
        }
        try {
            this.notificationListener = new NotificationListenerImpl(this);
            this.notificationFilter = new NotificationFilterImpl(this.notifTypes);
            this.bean.getConnectionProvider().getMBeanServer().addNotificationListener(((DBeanName)this.bean.getBeanName()).getObjectName(), this.notificationListener, null, null);
        }
        catch (InstanceNotFoundException e) {
            throw new EmsBeanNotFoundException("Could not register notification listener", (Throwable)e);
        }
    }

    public void stopListening() {
        if (!this.isListening()) {
            return;
        }
        try {
            this.bean.getConnectionProvider().getMBeanServer().removeNotificationListener(((DBeanName)this.bean.getBeanName()).getObjectName(), this.notificationListener, null, null);
            this.notificationListener = null;
            this.notificationFilter = null;
        }
        catch (InstanceNotFoundException e) {
            throw new EmsBeanNotFoundException("Could not deregister notification listener, bean missing", (Throwable)e);
        }
        catch (ListenerNotFoundException listenerNotFoundException) {
            // empty catch block
        }
    }

    protected EmsBean getBean() {
        return this.bean;
    }

    public List<EmsNotificationEvent> getEvents() {
        return Collections.unmodifiableList(this.events);
    }

    protected void fireNotifications(EmsNotificationEvent event) {
        this.events.add(event);
        for (EmsNotificationListener listener : this.listeners) {
            listener.handleNotification(event);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NotificationFilterImpl
    implements NotificationFilter {
        List<String> notifTypes;

        public NotificationFilterImpl(List<String> notifTypes) {
            this.notifTypes = notifTypes;
        }

        @Override
        public boolean isNotificationEnabled(Notification notification) {
            return this.notifTypes.contains(notification.getType());
        }
    }

    private static class NotificationListenerImpl
    implements NotificationListener,
    Serializable {
        DNotification n;

        public NotificationListenerImpl(DNotification n) {
            this.n = n;
        }

        public void handleNotification(Notification notification, Object object) {
            if (Arrays.asList(this.n.getTypes()).contains(notification.getType())) {
                EmsNotificationEvent event = new EmsNotificationEvent(this.n.getBean(), notification.getMessage(), notification.getSequenceNumber(), notification.getType(), notification.getTimeStamp(), notification.getUserData(), notification.getSource());
                this.n.fireNotifications(event);
            }
        }
    }
}

