/*
 * Decompiled with CFR 0.152.
 */
package org.mc4j.ems.impl.jmx.connection.support.providers.proxy;

import java.io.IOException;
import java.io.NotSerializableException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.rmi.ConnectException;
import java.rmi.NoSuchObjectException;
import javax.management.MBeanServer;
import javax.security.auth.login.LoginException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mc4j.ems.connection.EmsConnectException;
import org.mc4j.ems.connection.EmsUnsupportedTypeException;
import org.mc4j.ems.connection.LoadException;
import org.mc4j.ems.connection.support.ConnectionProvider;
import org.mc4j.ems.impl.jmx.connection.support.providers.JBossConnectionProvider;
import org.mc4j.ems.impl.jmx.connection.support.providers.proxy.StatsProxy;

public class GenericMBeanServerProxy
implements InvocationHandler,
StatsProxy {
    private static Log log = LogFactory.getLog(GenericMBeanServerProxy.class);
    private Object remoteServer;
    private ConnectionProvider provider;
    private long roundTrips;
    private long failures;
    private boolean reconnecting = false;

    public GenericMBeanServerProxy(Object remoteServer) {
        this.remoteServer = remoteServer;
    }

    public GenericMBeanServerProxy() {
    }

    public ConnectionProvider getProvider() {
        return this.provider;
    }

    public void setProvider(ConnectionProvider provider) {
        this.provider = provider;
    }

    public Object getRemoteServer() {
        return this.remoteServer;
    }

    public void setRemoteServer(Object remoteServer) {
        this.remoteServer = remoteServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
        Class<?> serverClass = this.remoteServer.getClass();
        Method method = GenericMBeanServerProxy.findMethod(m, serverClass);
        try {
            ++this.roundTrips;
            Object returnValue = this.invokeInternal(args, method);
            return returnValue;
        }
        catch (InvocationTargetException e) {
            ++this.failures;
            if (e.getCause() == null) throw e;
            Throwable t = e.getCause();
            if (t instanceof ConnectException) {
                throw new EmsConnectException(t);
            }
            if (t instanceof NoSuchObjectException) {
                if (this.provider == null) throw new EmsConnectException(t);
                if (this.reconnecting) throw new EmsConnectException(t);
                try {
                    Object returnValue;
                    log.info((Object)("Reestablishing RMI stub to restarted server [" + this.provider.getConnectionSettings().getServerUrl() + "]..."));
                    this.reconnecting = true;
                    this.provider.connect();
                    Object object = returnValue = this.invokeInternal(args, method);
                    return object;
                }
                catch (Exception f) {
                    log.warn((Object)("Unable to reestablish RMI stub to restarted server [" + this.provider.getConnectionSettings().getServerUrl() + "]."), (Throwable)f);
                    throw new EmsConnectException(t);
                }
                finally {
                    this.reconnecting = false;
                }
            }
            if (t instanceof IOException) {
                throw new EmsConnectException(t);
            }
            if (!(t instanceof NotSerializableException)) throw new EmsConnectException("Connection failure " + t.getLocalizedMessage(), t);
            throw new EmsUnsupportedTypeException("Value was not serializable " + t.getLocalizedMessage(), t);
        }
        catch (Exception e) {
            ++this.failures;
            log.error((Object)("Failed to invoke method [" + method + "]: " + e));
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object invokeInternal(Object[] args, Method method) throws LoginException, IllegalAccessException, InvocationTargetException {
        Object returnValue;
        boolean isJBossConnection = this.provider instanceof JBossConnectionProvider;
        if (isJBossConnection) {
            JBossConnectionProvider jbossProvider = (JBossConnectionProvider)this.provider;
            jbossProvider.login();
        }
        try {
            returnValue = method.invoke(this.remoteServer, args);
        }
        finally {
            if (isJBossConnection) {
                JBossConnectionProvider jbossProvider = (JBossConnectionProvider)this.provider;
                jbossProvider.logout();
            }
        }
        return returnValue;
    }

    public long getRoundTrips() {
        return this.roundTrips;
    }

    public long getFailures() {
        return this.failures;
    }

    public MBeanServer buildServerProxy() {
        try {
            Object proxy = Proxy.newProxyInstance(GenericMBeanServerProxy.class.getClassLoader(), new Class[]{Class.forName("javax.management.MBeanServer")}, (InvocationHandler)this);
            return (MBeanServer)proxy;
        }
        catch (ClassNotFoundException e) {
            throw new LoadException("Unable to find JMX Classes", (Throwable)e);
        }
    }

    private static Method findMethod(Method m, Class serverClass) throws NoSuchMethodException {
        Method method;
        if ("queryMBeans".equals(m.getName())) {
            Method[] ms = serverClass.getMethods();
            method = null;
            for (int i = 0; i < ms.length; ++i) {
                if (ms[i].getName().equals("queryMBeans")) {
                    method = ms[i];
                }
                if (method != null) continue;
                throw new EmsConnectException("Unsupported operation [" + m.getName() + "]");
            }
        } else {
            method = serverClass.getMethod(m.getName(), m.getParameterTypes());
        }
        return GenericMBeanServerProxy.getAccessibleMethod(method);
    }

    private static Method getAccessibleMethod(Method method) {
        try {
            method.setAccessible(true);
            return method;
        }
        catch (SecurityException e) {
            Method interfaceMethod;
            if (!Modifier.isPublic(method.getDeclaringClass().getModifiers()) && (interfaceMethod = GenericMBeanServerProxy.getInterfaceMethod(method)) != null) {
                return interfaceMethod;
            }
            return method;
        }
    }

    private static Method getInterfaceMethod(Method method) {
        for (Class<?> interfaceClass : method.getClass().getInterfaces()) {
            try {
                return interfaceClass.getMethod(method.getName(), method.getParameterTypes());
            }
            catch (NoSuchMethodException e) {
            }
            catch (SecurityException e) {
                // empty catch block
            }
        }
        return null;
    }
}

