/*
 * Decompiled with CFR 0.152.
 */
package org.mc4j.ems.connection.local;

import java.io.File;

public class LocalVirtualMachine {
    private String address;
    private String commandLine;
    private String displayName;
    private int vmid;
    private boolean isAttachSupported;
    private static final String LOCAL_CONNECTOR_ADDRESS_PROP = "com.sun.management.jmxremote.localConnectorAddress";

    public LocalVirtualMachine(int vmid, String commandLine, boolean attachSupported, String connectAddress) {
        this.vmid = vmid;
        this.commandLine = commandLine;
        this.address = connectAddress;
        this.isAttachSupported = attachSupported;
        this.displayName = LocalVirtualMachine.getDisplayName(commandLine);
    }

    private static String getDisplayName(String s) {
        String[] as = s.split(" ", 2);
        if (as[0].endsWith(".jar")) {
            File file = new File(as[0]);
            String s1 = file.getName();
            if (as.length == 2) {
                s1 = s1 + " " + as[1];
            }
            return s1;
        }
        return s;
    }

    public int getVmid() {
        return this.vmid;
    }

    public boolean isManageable() {
        return this.address != null;
    }

    public boolean isAttachable() {
        return this.isAttachSupported;
    }

    public void setConnectorAddress(String address) {
        this.address = address;
    }

    public String getConnectorAddress() {
        return this.address;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getCommandLine() {
        return this.commandLine;
    }

    public String toString() {
        return this.commandLine;
    }
}

