/*
 * Decompiled with CFR 0.152.
 */
package boopickle;

import java.nio.ByteBuffer;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001!3Q!\u0001\u0002\u0002\u0002\u0015\u0011qb\u0015;sS:<7i\u001c3fG\u001a\u000b7\u000f\u001e\u0006\u0002\u0007\u0005I!m\\8qS\u000e\\G.Z\u0002\u0001'\t\u0001a\u0001\u0005\u0002\b\u00155\t\u0001BC\u0001\n\u0003\u0015\u00198-\u00197b\u0013\tY\u0001B\u0001\u0004B]f\u0014VM\u001a\u0005\u0006\u001b\u0001!\tAD\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003=\u0001\"\u0001\u0005\u0001\u000e\u0003\tAQA\u0005\u0001\u0005\u0002M\t!\u0002Z3d_\u0012,g)Y:u)\r!2\u0004\t\t\u0003+aq!a\u0002\f\n\u0005]A\u0011A\u0002)sK\u0012,g-\u0003\u0002\u001a5\t11\u000b\u001e:j]\u001eT!a\u0006\u0005\t\u000bq\t\u0002\u0019A\u000f\u0002\u00071,g\u000e\u0005\u0002\b=%\u0011q\u0004\u0003\u0002\u0004\u0013:$\b\"B\u0011\u0012\u0001\u0004\u0011\u0013a\u00012vMB\u00111\u0005K\u0007\u0002I)\u0011QEJ\u0001\u0004]&|'\"A\u0014\u0002\t)\fg/Y\u0005\u0003S\u0011\u0012!BQ=uK\n+hMZ3s\u0011\u0015Y\u0003\u0001\"\u0001-\u0003))gnY8eK\u001a\u000b7\u000f\u001e\u000b\u0004[A\u0012\u0004CA\u0004/\u0013\ty\u0003B\u0001\u0003V]&$\b\"B\u0019+\u0001\u0004!\u0012!A:\t\u000bMR\u0003\u0019\u0001\u0012\u0002\u0005\t\u0014\u0007\"B\u001b\u0001\t\u00031\u0014aD3oG>$WMR1ti\u0006\u0013(/Y=\u0015\u00075:\u0004\bC\u00032i\u0001\u0007A\u0003C\u00034i\u0001\u0007!\u0005C\u0003;\u0001\u0011\u00051(A\u0007f]\u000e|G-\u001a$bgR\u0014UO\u001a\u000b\u0004[qj\u0004\"B\u0019:\u0001\u0004!\u0002\"B\u001a:\u0001\u0004\u0011\u0003\"B \u0001\t#\u0001\u0015a\u00043fG>$WMR1ti\u0006\u0013(/Y=\u0015\u0007Q\t%\tC\u0003\u001d}\u0001\u0007Q\u0004C\u0003\"}\u0001\u0007!\u0005C\u0003E\u0001\u0011EQ)A\u0007eK\u000e|G-\u001a$bgR\u0014UO\u001a\u000b\u0004)\u0019;\u0005\"\u0002\u000fD\u0001\u0004i\u0002\"B\u0011D\u0001\u0004\u0011\u0003")
public abstract class StringCodecFast {
    public String decodeFast(int len, ByteBuffer buf) {
        return buf.hasArray() ? this.decodeFastArray(len, buf) : this.decodeFastBuf(len, buf);
    }

    public void encodeFast(String s, ByteBuffer bb) {
        if (bb.hasArray()) {
            this.encodeFastArray(s, bb);
        } else {
            this.encodeFastBuf(s, bb);
        }
    }

    public void encodeFastArray(String s, ByteBuffer bb) {
        int len = s.length();
        byte[] buf = bb.array();
        int dst = bb.arrayOffset() + bb.position();
        int src = 0;
        int c = 32;
        while (src < len && (c = (int)s.charAt(src)) < 128) {
            buf[dst] = (byte)c;
            ++src;
            ++dst;
        }
        while (src < len) {
            c = s.charAt(src);
            if (c < 128) {
                buf[dst] = (byte)c;
                ++dst;
            } else if (c < 16384) {
                buf[dst] = (byte)(0x80 | c & 0x3F);
                buf[dst + 1] = (byte)(c >> 6 & 0xFF);
                dst += 2;
            } else {
                buf[dst] = (byte)(0xC0 | c & 0x3F);
                buf[dst + 1] = (byte)(c >> 6 & 0xFF);
                buf[dst + 2] = (byte)(c >> 14);
                dst += 3;
            }
            ++src;
        }
        bb.position(dst - bb.arrayOffset());
    }

    public void encodeFastBuf(String s, ByteBuffer bb) {
        int src;
        int len = s.length();
        int c = 32;
        for (src = 0; src < len && (c = (int)s.charAt(src)) < 128; ++src) {
            bb.put((byte)c);
        }
        while (src < len) {
            ByteBuffer byteBuffer;
            c = s.charAt(src);
            if (c < 128) {
                byteBuffer = bb.put((byte)c);
            } else if (c < 16384) {
                bb.put((byte)(0x80 | c & 0x3F));
                byteBuffer = bb.put((byte)(c >> 6 & 0xFF));
            } else {
                bb.put((byte)(0xC0 | c & 0x3F));
                bb.put((byte)(c >> 6 & 0xFF));
                byteBuffer = bb.put((byte)(c >> 14));
            }
            ++src;
        }
    }

    public String decodeFastArray(int len, ByteBuffer buf) {
        char[] cp = new char[len];
        byte[] src = buf.array();
        int offset = buf.arrayOffset() + buf.position();
        for (int dst = 0; dst < len; ++dst) {
            byte b = src[offset];
            ++offset;
            if ((b & 0x80) == 0) {
                cp[dst] = (char)(b & 0x7F);
                continue;
            }
            if ((b & 0xC0) == 128) {
                byte b1 = src[offset];
                ++offset;
                cp[dst] = (char)(b & 0x3F | (b1 & 0xFF) << 6);
                continue;
            }
            byte b1 = src[offset];
            byte b2 = src[offset + 1];
            offset += 2;
            cp[dst] = (char)(b & 0x3F | (b1 & 0xFF) << 6 | b2 << 14);
        }
        buf.position(offset - buf.arrayOffset());
        return new String(cp);
    }

    public String decodeFastBuf(int len, ByteBuffer buf) {
        char[] cp = new char[len];
        int i = 0;
        for (int dst = 0; dst < len; ++dst) {
            byte b = buf.get();
            if ((b & 0x80) == 0) {
                cp[dst] = (char)(b & 0x7F);
            } else if ((b & 0xC0) == 128) {
                byte b1 = buf.get();
                ++i;
                cp[dst] = (char)(b & 0x3F | (b1 & 0xFF) << 6);
            } else {
                byte b1 = buf.get();
                byte b2 = buf.get();
                i += 2;
                cp[dst] = (char)(b & 0x3F | (b1 & 0xFF) << 6 | b2 << 14);
            }
            ++i;
        }
        return new String(cp);
    }
}

