/*
 * Decompiled with CFR 0.152.
 */
package me.desair.tus.server;

import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public enum HttpMethod {
    GET,
    HEAD,
    POST,
    PUT,
    DELETE,
    CONNECT,
    OPTIONS,
    TRACE,
    PATCH;


    public static HttpMethod forName(String name) {
        for (HttpMethod method : HttpMethod.values()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)method.name(), (CharSequence)name)) continue;
            return method;
        }
        return null;
    }

    public static HttpMethod getMethodIfSupported(HttpServletRequest request, Set<HttpMethod> supportedHttpMethods) {
        HttpMethod httpMethod;
        Validate.notNull((Object)request, (String)"The HttpServletRequest cannot be null", (Object[])new Object[0]);
        String requestMethod = request.getHeader("X-HTTP-Method-Override");
        if (StringUtils.isBlank((CharSequence)requestMethod) || HttpMethod.forName(requestMethod) == null) {
            requestMethod = request.getMethod();
        }
        return (httpMethod = HttpMethod.forName(requestMethod)) != null && supportedHttpMethods.contains((Object)httpMethod) ? httpMethod : null;
    }
}

