/*
 * Decompiled with CFR 0.152.
 */
package me.desair.tus.server.checksum;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import me.desair.tus.server.HttpMethod;
import me.desair.tus.server.checksum.ChecksumAlgorithm;
import me.desair.tus.server.checksum.validation.ChecksumAlgorithmValidator;
import me.desair.tus.server.exception.TusException;
import me.desair.tus.server.exception.UploadChecksumMismatchException;
import me.desair.tus.server.upload.UploadStorageService;
import me.desair.tus.server.util.AbstractRequestHandler;
import me.desair.tus.server.util.TusServletRequest;
import me.desair.tus.server.util.TusServletResponse;
import org.apache.commons.lang3.StringUtils;

public class ChecksumPatchRequestHandler
extends AbstractRequestHandler {
    @Override
    public boolean supports(HttpMethod method) {
        return HttpMethod.PATCH.equals((Object)method);
    }

    @Override
    public void process(HttpMethod method, TusServletRequest servletRequest, TusServletResponse servletResponse, UploadStorageService uploadStorageService, String ownerKey) throws IOException, TusException {
        String uploadChecksumHeader = servletRequest.getHeader("Upload-Checksum");
        if (servletRequest.hasCalculatedChecksum() && StringUtils.isNotBlank((CharSequence)uploadChecksumHeader)) {
            new ChecksumAlgorithmValidator().validate(method, (HttpServletRequest)servletRequest, uploadStorageService, ownerKey);
            String expectedValue = StringUtils.substringAfter((String)uploadChecksumHeader, (String)" ");
            ChecksumAlgorithm checksumAlgorithm = ChecksumAlgorithm.forUploadChecksumHeader(uploadChecksumHeader);
            String calculatedValue = servletRequest.getCalculatedChecksum(checksumAlgorithm);
            if (!StringUtils.equals((CharSequence)expectedValue, (CharSequence)calculatedValue)) {
                throw new UploadChecksumMismatchException("Expected checksum " + expectedValue + " but was " + calculatedValue + " with algorithm " + (Object)((Object)checksumAlgorithm));
            }
        }
    }
}

