/*
 * Decompiled with CFR 0.152.
 */
package me.desair.tus.server.creation;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import me.desair.tus.server.HttpMethod;
import me.desair.tus.server.upload.UploadInfo;
import me.desair.tus.server.upload.UploadStorageService;
import me.desair.tus.server.util.AbstractRequestHandler;
import me.desair.tus.server.util.TusServletRequest;
import me.desair.tus.server.util.TusServletResponse;
import me.desair.tus.server.util.Utils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreationPostRequestHandler
extends AbstractRequestHandler {
    private static final Logger log = LoggerFactory.getLogger(CreationPostRequestHandler.class);

    @Override
    public boolean supports(HttpMethod method) {
        return HttpMethod.POST.equals((Object)method);
    }

    @Override
    public void process(HttpMethod method, TusServletRequest servletRequest, TusServletResponse servletResponse, UploadStorageService uploadStorageService, String ownerKey) throws IOException {
        UploadInfo info = this.buildUploadInfo((HttpServletRequest)servletRequest);
        info = uploadStorageService.create(info, ownerKey);
        String uploadURI = servletRequest.getRequestURI();
        String url = uploadURI + (StringUtils.endsWith((CharSequence)uploadURI, (CharSequence)"/") ? "" : "/") + info.getId();
        servletResponse.setHeader("Location", url);
        servletResponse.setStatus(201);
        log.info("Created upload with ID {} at {} for ip address {} with location {}", new Object[]{info.getId(), info.getCreationTimestamp(), info.getCreatorIpAddresses(), url});
    }

    private UploadInfo buildUploadInfo(HttpServletRequest servletRequest) {
        String metadata;
        UploadInfo info = new UploadInfo(servletRequest);
        Long length = Utils.getLongHeader(servletRequest, "Upload-Length");
        if (length != null) {
            info.setLength(length);
        }
        if (StringUtils.isNotBlank((CharSequence)(metadata = Utils.getHeader(servletRequest, "Upload-Metadata")))) {
            info.setEncodedMetadata(metadata);
        }
        return info;
    }
}

