/*
 * Decompiled with CFR 0.152.
 */
package me.desair.tus.server.upload;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import me.desair.tus.server.upload.UploadId;
import me.desair.tus.server.upload.UploadType;
import me.desair.tus.server.util.Utils;
import org.apache.commons.codec.Charsets;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class UploadInfo
implements Serializable {
    private static final String APPLICATION_OCTET_STREAM = "application/octet-stream";
    private static List<String> fileNameKeys = Arrays.asList("filename", "name");
    private static List<String> mimeTypeKeys = Arrays.asList("mimetype", "filetype", "type");
    private UploadType uploadType;
    private Long offset = 0L;
    private String encodedMetadata = null;
    private Long length = null;
    private UploadId id;
    private String ownerKey;
    private Long creationTimestamp = this.getCurrentTime();
    private String creatorIpAddresses;
    private Long expirationTimestamp;
    private List<String> concatenationPartIds;
    private String uploadConcatHeaderValue;

    public UploadInfo() {
    }

    public UploadInfo(HttpServletRequest servletRequest) {
        this();
        this.creatorIpAddresses = Utils.buildRemoteIpList(servletRequest);
    }

    public Long getOffset() {
        return this.offset;
    }

    public void setOffset(Long offset) {
        this.offset = offset;
    }

    public String getEncodedMetadata() {
        return this.encodedMetadata;
    }

    public void setEncodedMetadata(String encodedMetadata) {
        this.encodedMetadata = encodedMetadata;
    }

    public Map<String, String> getMetadata() {
        TreeMap<String, String> metadata = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        for (String valuePair : this.splitToArray(this.encodedMetadata, ",")) {
            int i;
            String[] keyValue = this.splitToArray(valuePair, "\\s");
            String key = null;
            String value = null;
            if (keyValue.length <= 0) continue;
            key = StringUtils.trimToEmpty((String)keyValue[0]);
            for (i = 1; keyValue.length > i && StringUtils.isBlank((CharSequence)keyValue[i]); ++i) {
            }
            if (keyValue.length > i) {
                value = this.decode(keyValue[i]);
            }
            metadata.put(key, value);
        }
        return metadata;
    }

    public boolean hasMetadata() {
        return StringUtils.isNotBlank((CharSequence)this.encodedMetadata);
    }

    public Long getLength() {
        return this.length;
    }

    public void setLength(Long length) {
        this.length = length != null && length > 0L ? length : null;
    }

    public boolean hasLength() {
        return this.length != null;
    }

    public boolean isUploadInProgress() {
        return this.length == null || !this.offset.equals(this.length);
    }

    public void setId(UploadId id) {
        this.id = id;
    }

    public UploadId getId() {
        return this.id;
    }

    public void setOwnerKey(String ownerKey) {
        this.ownerKey = ownerKey;
    }

    public String getOwnerKey() {
        return this.ownerKey;
    }

    public Long getExpirationTimestamp() {
        return this.expirationTimestamp;
    }

    public void updateExpiration(long expirationPeriod) {
        this.expirationTimestamp = this.getCurrentTime() + expirationPeriod;
    }

    public Long getCreationTimestamp() {
        return this.creationTimestamp;
    }

    public String getCreatorIpAddresses() {
        return this.creatorIpAddresses;
    }

    public UploadType getUploadType() {
        return this.uploadType;
    }

    public void setUploadType(UploadType uploadType) {
        this.uploadType = uploadType;
    }

    public void setConcatenationPartIds(List<String> concatenationPartIds) {
        this.concatenationPartIds = concatenationPartIds;
    }

    public List<String> getConcatenationPartIds() {
        return this.concatenationPartIds;
    }

    public void setUploadConcatHeaderValue(String uploadConcatHeaderValue) {
        this.uploadConcatHeaderValue = uploadConcatHeaderValue;
    }

    public String getUploadConcatHeaderValue() {
        return this.uploadConcatHeaderValue;
    }

    public String getFileName() {
        Map<String, String> metadata = this.getMetadata();
        for (String fileNameKey : fileNameKeys) {
            if (!metadata.containsKey(fileNameKey)) continue;
            return metadata.get(fileNameKey);
        }
        return this.getId().toString();
    }

    public String getFileMimeType() {
        Map<String, String> metadata = this.getMetadata();
        for (String fileNameKey : mimeTypeKeys) {
            if (!metadata.containsKey(fileNameKey)) continue;
            return metadata.get(fileNameKey);
        }
        return APPLICATION_OCTET_STREAM;
    }

    public boolean isExpired() {
        return this.expirationTimestamp != null && this.expirationTimestamp < this.getCurrentTime();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UploadInfo)) {
            return false;
        }
        UploadInfo that = (UploadInfo)o;
        return new EqualsBuilder().append((Object)this.getUploadType(), (Object)that.getUploadType()).append((Object)this.getOffset(), (Object)that.getOffset()).append((Object)this.getEncodedMetadata(), (Object)that.getEncodedMetadata()).append((Object)this.getLength(), (Object)that.getLength()).append((Object)this.getId(), (Object)that.getId()).append((Object)this.getOwnerKey(), (Object)that.getOwnerKey()).append((Object)this.getCreatorIpAddresses(), (Object)that.getCreatorIpAddresses()).append((Object)this.getExpirationTimestamp(), (Object)that.getExpirationTimestamp()).append(this.getConcatenationPartIds(), that.getConcatenationPartIds()).append((Object)this.getUploadConcatHeaderValue(), (Object)that.getUploadConcatHeaderValue()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.getUploadType()).append((Object)this.getOffset()).append((Object)this.getEncodedMetadata()).append((Object)this.getLength()).append((Object)this.getId()).append((Object)this.getOwnerKey()).append((Object)this.getCreatorIpAddresses()).append((Object)this.getExpirationTimestamp()).append(this.getConcatenationPartIds()).append((Object)this.getUploadConcatHeaderValue()).toHashCode();
    }

    protected long getCurrentTime() {
        return new Date().getTime();
    }

    private String[] splitToArray(String value, String separatorRegex) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return new String[0];
        }
        return StringUtils.trimToEmpty((String)value).split(separatorRegex);
    }

    private String decode(String encodedValue) {
        if (encodedValue == null) {
            return null;
        }
        return new String(Base64.decodeBase64((String)encodedValue), Charsets.UTF_8);
    }
}

