/*
 * Decompiled with CFR 0.152.
 */
package me.desair.tus.server.upload.disk;

import java.io.IOException;
import java.io.Serializable;
import java.nio.file.DirectoryStream;
import java.nio.file.Path;
import java.util.Objects;
import me.desair.tus.server.upload.UploadId;
import me.desair.tus.server.upload.UploadInfo;
import me.desair.tus.server.upload.UploadLockingService;
import me.desair.tus.server.upload.disk.DiskStorageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpiredUploadFilter
implements DirectoryStream.Filter<Path> {
    private static final Logger log = LoggerFactory.getLogger(ExpiredUploadFilter.class);
    private DiskStorageService diskStorageService;
    private UploadLockingService uploadLockingService;

    ExpiredUploadFilter(DiskStorageService diskStorageService, UploadLockingService uploadLockingService) {
        this.diskStorageService = diskStorageService;
        this.uploadLockingService = uploadLockingService;
    }

    @Override
    public boolean accept(Path upload) throws IOException {
        block3: {
            UploadId id = null;
            try {
                id = new UploadId((Serializable)((Object)upload.getFileName().toString()));
                UploadInfo info = this.diskStorageService.getUploadInfo(id);
                if (info != null && info.isExpired() && !this.uploadLockingService.isLocked(id)) {
                    return true;
                }
            }
            catch (Exception ex) {
                if (!log.isDebugEnabled()) break block3;
                log.debug("Not able to determine state of upload " + Objects.toString(id), (Throwable)ex);
            }
        }
        return false;
    }
}

